/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;

public class PersistenceProvider {
    protected static final Log log = LogFactory.getLog(PersistenceProvider.class);
    protected EntityManagerFactory emf;
    protected final EntityManagerFactoryProvider emfProvider;

    public PersistenceProvider(EntityManagerFactoryProvider emfProvider) {
        this.emfProvider = emfProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openPersistenceUnit() {
        if (this.emfProvider == null) {
            throw new IllegalArgumentException("emfProvider not set");
        }
        if (this.emf != null) return;
        Class<PersistenceProvider> clazz = PersistenceProvider.class;
        synchronized (PersistenceProvider.class) {
            if (this.emf != null) return;
            this.emf = this.emfProvider.getFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void closePersistenceUnit() {
        if (this.emf == null) {
            return;
        }
        if (this.emf.isOpen()) {
            this.emf.close();
        }
        this.emf = null;
    }

    protected EntityManager doAcquireEntityManager() {
        if (this.emf == null) {
            this.openPersistenceUnit();
        }
        return this.emf.createEntityManager();
    }

    protected EntityTransaction getTransaction(EntityManager em) {
        try {
            return em.getTransaction();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public EntityManager acquireEntityManagerWithActiveTransaction() {
        EntityManager em = this.doAcquireEntityManager();
        this.doBegin(em);
        return em;
    }

    protected void doBegin(EntityManager em) {
        EntityTransaction et = this.getTransaction(em);
        if (et != null) {
            et.begin();
        }
    }

    protected void doCommit(EntityManager em) {
        try {
            em.flush();
        }
        catch (TransactionRequiredException e) {
            // empty catch block
        }
        EntityTransaction et = this.getTransaction(em);
        if (et == null || !et.isActive()) {
            return;
        }
        et.commit();
    }

    protected void doRollback(EntityManager em) {
        try {
            em.flush();
        }
        catch (TransactionRequiredException e) {
            // empty catch block
        }
        EntityTransaction et = this.getTransaction(em);
        if (et == null || !et.isActive()) {
            return;
        }
        et.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseEntityManager(EntityManager em) {
        if (!em.isOpen()) {
            return;
        }
        try {
            this.doCommit(em);
        }
        finally {
            if (em.isOpen()) {
                em.clear();
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEntityManagerWithRollback(EntityManager em) {
        if (!em.isOpen()) {
            return;
        }
        try {
            this.doRollback(em);
        }
        finally {
            if (em.isOpen()) {
                em.clear();
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Boolean needActiveSession, RunCallback<T> callback) throws ClientException {
        Thread myThread = Thread.currentThread();
        ClassLoader lastLoader = myThread.getContextClassLoader();
        myThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            T t;
            EntityManager em = this.doAcquireEntityManager();
            if (needActiveSession.booleanValue()) {
                this.doBegin(em);
            }
            try {
                t = callback.runWith(em);
                this.releaseEntityManager(em);
            }
            catch (Throwable throwable) {
                this.releaseEntityManager(em);
                throw throwable;
            }
            return t;
        }
        finally {
            myThread.setContextClassLoader(lastLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Boolean needActiveSession, RunVoid callback) throws ClientException {
        Thread myThread = Thread.currentThread();
        ClassLoader lastLoader = myThread.getContextClassLoader();
        myThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            EntityManager em = this.doAcquireEntityManager();
            if (needActiveSession.booleanValue()) {
                this.doBegin(em);
            }
            try {
                callback.runWith(em);
            }
            finally {
                this.releaseEntityManager(em);
            }
        }
        finally {
            myThread.setContextClassLoader(lastLoader);
        }
    }

    public static interface RunVoid {
        public void runWith(EntityManager var1) throws ClientException;
    }

    public static interface RunCallback<T> {
        public T runWith(EntityManager var1) throws ClientException;
    }
}

