/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="siteActions")
@Scope(value=ScopeType.STATELESS)
public class SiteActionsBean {
    private static final Log log = LogFactory.getLog(SiteActionsBean.class);
    @In(create=true)
    protected transient CoreSession documentManager;
    protected static final String WEBSITE = "WebSite";
    protected static final String WEBBLOG = "BlogSite";

    public void validateName(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String wcId = (String)attributes.get("webContainerId");
        if (wcId == null) {
            log.debug((Object)"Cannot validate name: input wcId not found");
            return;
        }
        UIInput wcComp = (UIInput)component.findComponent(wcId);
        if (wcComp == null) {
            log.debug((Object)"Cannot validate name: input wcId not found second time");
            return;
        }
        Boolean propValue = (Boolean)wcComp.getLocalValue();
        boolean isWC = false;
        if (propValue != null) {
            isWC = propValue;
        }
        if (!isWC) {
            return;
        }
        String nameId = (String)attributes.get("nameId");
        if (nameId == null) {
            log.error((Object)"Cannot validate name: input id(s) not found");
            return;
        }
        UIInput nameComp = (UIInput)component.findComponent(nameId);
        if (nameComp == null) {
            log.error((Object)"Cannot validate name: input(s) not found second time");
            return;
        }
        Object nameObj = nameComp.getLocalValue();
        if (nameObj == null || StringUtils.isBlank((String)nameObj.toString())) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.error.need.name.webcontainer"), null);
            throw new ValidatorException(message);
        }
    }

    public void validateSiteTitle(FacesContext context, UIComponent component, Object value) {
        this.validateSite(context, component, value, WEBSITE);
    }

    public void validateBlogTitle(FacesContext context, UIComponent component, Object value) {
        this.validateSite(context, component, value, WEBBLOG);
    }

    private void validateSite(FacesContext context, UIComponent component, Object value, String siteType) {
        if (value instanceof String) {
            String name = IdUtils.generateId((String)((String)value));
            try {
                DocumentModelList sites = this.querySitesByUrlAndDocType(this.documentManager, name, siteType);
                if (!sites.isEmpty()) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.site.notunique.title"), null);
                    context.addMessage(null, message);
                    throw new ValidatorException(message);
                }
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
    }

    private DocumentModelList querySitesByUrlAndDocType(CoreSession session, String url, String documentType) throws ClientException {
        QuerySitesUnrestricted unrestrictedRunner = new QuerySitesUnrestricted(session, documentType, url);
        unrestrictedRunner.runUnrestricted();
        return unrestrictedRunner.getResultList();
    }

    private class QuerySitesUnrestricted
    extends UnrestrictedSessionRunner {
        private final String documentType;
        private final String url;
        private DocumentModelList list;

        public QuerySitesUnrestricted(CoreSession session, String documentType, String url) {
            super(session);
            this.documentType = documentType;
            this.url = url;
        }

        public void run() throws ClientException {
            String queryString = String.format("SELECT * FROM %s WHERE ecm:mixinType = 'WebView' AND webc:url = \"%s\" AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' AND webc:isWebContainer = 1", this.documentType, this.url);
            this.list = this.session.query(queryString);
        }

        DocumentModelList getResultList() {
            return this.list;
        }
    }
}

