/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Manager;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.el.ContextStringWrapper;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.contentbrowser.WorkspaceActions;
import org.nuxeo.ecm.webapp.documenttemplates.DocumentTemplatesActions;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.ecm.webapp.security.SecurityActions;

@Name(value="workspaceActions")
@Scope(value=ScopeType.CONVERSATION)
public class WorkspaceActionsBean
extends InputController
implements WorkspaceActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WorkspaceActionsBean.class);
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(create=true)
    private transient Principal currentUser;
    @In(required=false)
    private transient DocumentActions documentActions;
    @In(create=true)
    private transient PrincipalListManager principalListManager;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    private transient SecurityActions securityActions;
    @In(value="org.jboss.seam.core.manager")
    private transient Manager conversationManager;
    private Boolean useTemplateFlag;
    @In(required=false)
    private transient DocumentModel tmpWorkspace;
    @In(create=true)
    private transient DocumentModelList availableTemplates;
    @In(value="#{selectedTemplateId.value}", required=false)
    private transient String selectedTemplateId;
    @In(value="#{selectedSecurityModel.value}", required=false)
    private transient String selectedSecurityModel;
    @In(value="#{selectedOwnerModel.value}", required=false)
    private transient String selectedOwnerModel;
    @In(create=true)
    private transient DocumentTemplatesActions documentTemplatesActions;

    @Override
    @Create
    public void initialize() {
    }

    @Override
    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    public String cancel() {
        return "view_workspaces";
    }

    @PrePassivate
    public void saveState() {
        log.info((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.info((Object)"PostActivate");
    }

    @Override
    public void setUseTemplate(Boolean value) {
        this.useTemplateFlag = value;
    }

    @Override
    public Boolean getUseTemplate() {
        if (this.availableTemplates == null) {
            return false;
        }
        if (this.useTemplateFlag == null) {
            return false;
        }
        return this.useTemplateFlag;
    }

    @Override
    @Factory(value="selectedTemplateId")
    public ContextStringWrapper FactoryForSelectedTemplateId() {
        return new ContextStringWrapper("none");
    }

    @Override
    @Factory(value="selectedSecurityModel")
    public ContextStringWrapper FactoryForSelectSecurityModel() {
        return new ContextStringWrapper("inherit");
    }

    @Override
    @Factory(value="selectedOwnerModel")
    public ContextStringWrapper FactoryForSelectSecurityOwner() {
        return new ContextStringWrapper("me");
    }

    @Override
    @Begin(pageflow="createWorkspace", nested=true)
    @Factory(value="tmpWorkspace")
    public DocumentModel getTmpWorkspace() {
        if (this.tmpWorkspace == null) {
            try {
                this.tmpWorkspace = this.documentManager.createDocumentModel("Workspace");
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return this.tmpWorkspace;
    }

    @Override
    @Factory(value="availableWorkspaceTemplates")
    public DocumentModelList getTemplates() throws ClientException {
        this.availableTemplates = this.documentTemplatesActions.getTemplates("Workspace");
        return this.availableTemplates;
    }

    @Override
    public String finishPageFlow() {
        return "done";
    }

    @Override
    public String getSelectedTemplateDescription() {
        if (this.selectedTemplateId == null) {
            return "";
        }
        if (this.selectedTemplateId.equals("none")) {
            return "no_template";
        }
        try {
            for (DocumentModel t : this.getTemplates()) {
                if (!this.selectedTemplateId.equals(t.getId())) continue;
                return (String)t.getProperty("dublincore", "description");
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return "";
    }

    @Override
    public DocumentModel getSelectedTemplate() {
        if (this.selectedTemplateId == null) {
            return null;
        }
        if (this.selectedTemplateId.equals("none")) {
            return null;
        }
        try {
            for (DocumentModel t : this.getTemplates()) {
                if (!this.selectedTemplateId.equals(t.getId())) continue;
                return t;
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return null;
    }

    @Override
    @End
    public String createWorkspace() throws ClientException {
        String navResult = null;
        navResult = this.useTemplateFlag == null || this.useTemplateFlag == false || this.selectedTemplateId == null || this.selectedTemplateId.equals("none") ? this.documentTemplatesActions.createDocumentFromTemplate(this.tmpWorkspace, null) : this.documentTemplatesActions.createDocumentFromTemplate(this.tmpWorkspace, this.selectedTemplateId);
        if (!this.selectedSecurityModel.equals("inherit")) {
            List<String> principalsName;
            if (this.selectedOwnerModel.equals("me")) {
                principalsName = new ArrayList();
                principalsName.add(this.currentUser.getName());
            } else {
                principalsName = this.principalListManager.getSelectedUsers();
            }
            principalsName.addAll(this.userManager.getAdministratorsGroups());
            for (String principalName : principalsName) {
                this.securityActions.addPermission(principalName, "Everything", true);
            }
            this.securityActions.addPermission("Everyone", "Everything", false);
            this.securityActions.updateSecurityOnDocument();
        }
        String res = this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
        this.navigationContext.setChangeableDocument(this.navigationContext.getCurrentDocument());
        return res;
    }

    @End(beforeRedirect=true)
    public String createWorkspaceOld() throws ClientException {
        String navResult = null;
        if (!this.useTemplateFlag.booleanValue() || this.selectedTemplateId.equals("none")) {
            navResult = this.documentActions.saveDocument(this.tmpWorkspace);
        } else {
            Blob blob;
            DocumentRef currentDocRef = this.navigationContext.getCurrentDocument().getRef();
            String title = (String)this.tmpWorkspace.getProperty("dublincore", "title");
            String name = IdUtils.generateId((String)title);
            this.documentManager.copy((DocumentRef)new IdRef(this.selectedTemplateId), currentDocRef, name);
            DocumentModel created = this.documentManager.getChild(currentDocRef, name);
            created.setProperty("dublincore", "title", (Object)title);
            String descr = (String)this.tmpWorkspace.getProperty("dublincore", "description");
            if (!descr.equals("")) {
                created.setProperty("dublincore", "description", (Object)descr);
            }
            if ((blob = (Blob)this.tmpWorkspace.getProperty("file", "content")) != null) {
                created.setProperty("file", "content", (Object)blob);
                String fname = (String)this.tmpWorkspace.getProperty("file", "filename");
                created.setProperty("file", "filename", (Object)fname);
            }
            created = this.documentManager.saveDocument(created);
            this.documentManager.save();
            navResult = this.navigationContext.navigateToDocument(created, "after-create");
        }
        if (!this.selectedSecurityModel.equals("inherit")) {
            List<String> principalsName;
            if (this.selectedOwnerModel.equals("me")) {
                principalsName = new ArrayList();
                principalsName.add(this.currentUser.getName());
            } else {
                principalsName = this.principalListManager.getSelectedUsers();
            }
            for (String principalName : principalsName) {
                this.securityActions.addPermission(principalName, "Everything", true);
            }
            principalsName.addAll(this.userManager.getAdministratorsGroups());
            this.securityActions.addPermission("Everyone", "Everything", false);
            this.securityActions.updateSecurityOnDocument();
        }
        String res = this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
        this.navigationContext.setChangeableDocument(this.navigationContext.getCurrentDocument());
        return res;
    }

    @Override
    @End(beforeRedirect=true)
    public String exitWizard() throws ClientException {
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    @Override
    public String getA4JHackingURL() {
        String url = BaseURL.getBaseURL() + "wizards/createWorkspace/a4jUploadHack.faces?";
        url = this.conversationManager.encodeConversationId(url);
        return url;
    }
}

