/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.pathelements.ArchivedVersionsPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.DocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.PathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.VersionDocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.util.BadDocumentUriException;
import org.nuxeo.ecm.platform.ui.web.util.DocumentLocator;
import org.nuxeo.ecm.platform.ui.web.util.DocumentsListsUtils;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.context.NavigationContextLocal;
import org.nuxeo.ecm.webapp.context.ServerContextBean;
import org.nuxeo.ecm.webapp.delegate.DocumentManagerBusinessDelegate;
import org.nuxeo.ecm.webapp.helpers.ApplicationControllerHelper;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="navigationContext")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class NavigationContextBean
implements NavigationContextLocal,
Serializable {
    private static final long serialVersionUID = -3708768859028774906L;
    private static final Log log = LogFactory.getLog(NavigationContextBean.class);
    @In
    protected transient Context conversationContext;
    @In
    protected transient Context eventContext;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true, required=false)
    private ServerContextBean serverLocator;
    private DocumentModel currentDomain;
    private DocumentModel currentContentRoot;
    private DocumentModel currentWorkspace;
    protected DocumentModel currentDocument;
    protected DocumentModel currentSuperSpace;
    protected DocumentModelList currentDocumentChildren;
    protected List<DocumentModel> currentDocumentParents;
    private DocumentModel changeableDocument;
    private List<PathElement> parents;
    private SchemaManager schemaManager;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @RequestParameter
    String docRef;

    @Create
    @PostActivate
    public void init() {
        log.debug((Object)"<init> ");
        this.parents = null;
    }

    @BypassInterceptors
    public DocumentModel getCurrentDocument() {
        return this.currentDocument;
    }

    public String getCurrentDomainPath() throws ClientException {
        Path path;
        if (this.currentDomain != null) {
            return this.currentDomain.getPathAsString();
        }
        if (this.currentDocument != null) {
            path = this.currentDocument.getPath();
        } else {
            DocumentModelList docs = this.documentManager.query("SELECT * FROM Document", 1);
            if (docs.size() < 1) {
                log.debug((Object)"Could not find a single document readable by current user.");
                return null;
            }
            path = ((DocumentModel)docs.get(0)).getPath();
        }
        if (path.segmentCount() > 0) {
            String[] segs = new String[]{path.segment(0)};
            return Path.createFromSegments((String[])segs).toString();
        }
        return null;
    }

    public void setCurrentDocument(DocumentModel documentModel) throws ClientException {
        if (!this.checkIfUpdateNeeded(this.currentDocument, documentModel)) {
            return;
        }
        this.invalidateChildrenProvider();
        this.currentSuperSpace = null;
        this.currentDocument = documentModel;
        if (this.currentDocument == null) {
            this.currentDocumentParents = null;
        } else {
            DocumentRef ref = this.currentDocument.getRef();
            if (ref == null) {
                throw new ClientException("DocumentRef is null for currentDocument: " + this.currentDocument.getName());
            }
            this.currentDocumentParents = this.documentManager.getParentDocuments(ref);
        }
        this.updateContextVariables();
        this.resetCurrentPath();
        this.eventContext.remove("currentDocument");
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)this.currentDocument);
    }

    @BypassInterceptors
    public DocumentModel getChangeableDocument() {
        return this.changeableDocument;
    }

    public void setChangeableDocument(DocumentModel changeableDocument) {
        this.changeableDocument = changeableDocument;
        this.eventContext.set("changeableDocument", (Object)changeableDocument);
    }

    public DocumentModelList getCurrentPath() throws ClientException {
        DocumentModelListImpl parentDocsList = new DocumentModelListImpl();
        List fromRoot = this.documentManager.getParentDocuments(this.currentDocument.getRef());
        parentDocsList.addAll((Collection)fromRoot);
        Collections.reverse(parentDocsList);
        return parentDocsList;
    }

    public DocumentModel getCurrentSuperSpace() throws ClientException {
        if (this.currentSuperSpace == null && this.currentDocument != null) {
            if (this.currentDocument.hasFacet("SuperSpace")) {
                this.currentSuperSpace = this.currentDocument;
            } else if (this.documentManager != null) {
                this.currentSuperSpace = this.documentManager.getSuperSpace(this.currentDocument);
            }
        }
        return this.currentSuperSpace;
    }

    @Deprecated
    public DocumentModelList getCurrentDocumentChildren() throws ClientException {
        String logPrefix = "<getCurrentDocumentChildren> ";
        if (this.documentManager == null) {
            log.error((Object)"<getCurrentDocumentChildren> documentManager not initialized");
            return new DocumentModelListImpl();
        }
        QueryModelDescriptor queryDescriptor = this.queryModelActions.get("CURRENT_DOC_CHILDREN").getDescriptor();
        String query = queryDescriptor.getQuery(new Object[]{this.currentDocument.getId()});
        this.currentDocumentChildren = this.documentManager.query(query);
        return this.currentDocumentChildren;
    }

    public void invalidateChildrenProvider() {
        ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
        resultsProvidersCache.invalidate("CURRENT_DOC_CHILDREN");
    }

    public void invalidateCurrentDocument() throws ClientException {
        this.currentDocument = this.documentManager.getDocument(this.currentDocument.getRef());
        this.updateContextVariables();
    }

    @Deprecated
    public DocumentModelList getCurrentDocumentChildrenPage() throws ClientException {
        String logPrefix = "<getCurrentDocumentChildrenPage> ";
        if (this.documentManager == null) {
            log.error((Object)"<getCurrentDocumentChildrenPage> documentManager not initialized");
            return new DocumentModelListImpl();
        }
        try {
            ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
            PagedDocumentsProvider resultsProvider = resultsProvidersCache.get("CURRENT_DOC_CHILDREN");
            this.currentDocumentChildren = resultsProvider.getCurrentPage();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
        return this.currentDocumentChildren;
    }

    @BypassInterceptors
    public DocumentModel getCurrentDomain() {
        return this.currentDomain;
    }

    public void setCurrentDomain(DocumentModel domainDocModel) throws ClientException {
        if (!this.checkIfUpdateNeeded(this.currentDomain, domainDocModel)) {
            return;
        }
        this.currentDomain = domainDocModel;
        this.eventContext.remove("currentDomain");
        if (domainDocModel == null) {
            Events.instance().raiseEvent("domainSelectionChanged", new Object[]{this.currentDomain});
            return;
        }
        if (this.currentDocument == null) {
            try {
                this.setCurrentDocument(null);
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        if (this.currentDocumentParents != null && !DocumentsListsUtils.isDocumentInList((DocumentModel)domainDocModel, this.currentDocumentParents)) {
            try {
                this.setCurrentDocument(domainDocModel);
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        Events.instance().raiseEvent("domainSelectionChanged", new Object[]{this.currentDomain});
    }

    protected boolean checkIfUpdateNeeded(DocumentModel ctxDoc, DocumentModel newDoc) {
        if (ctxDoc == null && newDoc != null || ctxDoc != null && newDoc == null) {
            return true;
        }
        if (ctxDoc == null && newDoc == null) {
            return false;
        }
        try {
            return !ctxDoc.getCacheKey().equals(newDoc.getCacheKey());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void saveCurrentDocument() throws ClientException {
        if (null == this.currentDocument) {
            throw new IllegalStateException("null currentDocument");
        }
        this.currentDocument = this.documentManager.saveDocument(this.currentDocument);
        this.documentManager.save();
    }

    public List<PathElement> getCurrentPathList() throws ClientException {
        if (this.parents == null) {
            this.resetCurrentPath();
        }
        return this.parents;
    }

    public RepositoryLocation getCurrentServerLocation() {
        return this.serverLocator.getCurrentServerLocation();
    }

    @Deprecated
    public RepositoryLocation getSelectedServerLocation() {
        return this.serverLocator.getCurrentServerLocation();
    }

    public void setCurrentServerLocation(RepositoryLocation serverLocation) throws ClientException {
        if (serverLocation == null) {
            log.warn((Object)"Setting ServerLocation to null, is this normal ?");
        }
        RepositoryLocation currentServerLocation = serverLocation;
        this.serverLocator.setRepositoryLocation(serverLocation);
        this.resetCurrentContext();
        this.eventContext.set("currentServerLocation", (Object)currentServerLocation);
        this.documentManager = null;
        this.documentManager = this.getOrCreateDocumentManager();
        Events.instance().raiseEvent("locationSelectionChanged", new Object[0]);
        DocumentModel rootDocument = this.documentManager.getRootDocument();
        if (this.documentManager.hasPermission(rootDocument.getRef(), "Read")) {
            this.currentDocument = rootDocument;
            this.updateContextVariables();
        }
    }

    public CoreSession getOrCreateDocumentManager() throws ClientException {
        if (this.documentManager != null) {
            return this.documentManager;
        }
        Object supposedDocumentManager = Contexts.lookupInStatefulContexts((String)"documentManager");
        DocumentManagerBusinessDelegate documentManagerBD = null;
        if (supposedDocumentManager != null) {
            if (supposedDocumentManager instanceof DocumentManagerBusinessDelegate) {
                documentManagerBD = (DocumentManagerBusinessDelegate)supposedDocumentManager;
            } else {
                log.error((Object)("Found the documentManager being " + supposedDocumentManager.getClass() + " instead of DocumentManagerBusinessDelegate. This is wrong."));
            }
        }
        if (documentManagerBD == null) {
            documentManagerBD = new DocumentManagerBusinessDelegate();
            this.conversationContext.set("documentManager", (Object)documentManagerBD);
        }
        this.documentManager = documentManagerBD.getDocumentManager(this.getCurrentServerLocation());
        return this.documentManager;
    }

    @BypassInterceptors
    public DocumentModel getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    @Factory(value="currentDocument", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentDocument() {
        return this.currentDocument;
    }

    @Factory(value="changeableDocument", scope=ScopeType.EVENT)
    public DocumentModel factoryChangeableDocument() {
        return this.changeableDocument;
    }

    @Factory(value="currentDomain", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentDomain() {
        return this.currentDomain;
    }

    @Factory(value="currentWorkspace", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentWorkspace() {
        return this.currentWorkspace;
    }

    @Factory(value="currentContentRoot", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentContentRoot() {
        return this.currentContentRoot;
    }

    public RepositoryLocation factoryCurrentServerLocation() {
        return this.getCurrentServerLocation();
    }

    @Factory(value="currentDocumentChildren", scope=ScopeType.EVENT)
    public DocumentModelList factoryCurrentDocumentChildren() throws ClientException {
        return this.getCurrentDocumentChildren();
    }

    @Factory(value="currentSuperSpace", scope=ScopeType.EVENT)
    public DocumentModel factoryCurrentSuperSpace() throws ClientException {
        return this.getCurrentSuperSpace();
    }

    public void setCurrentWorkspace(DocumentModel workspaceDocModel) throws ClientException {
        if (!this.checkIfUpdateNeeded(this.currentWorkspace, workspaceDocModel)) {
            return;
        }
        this.currentWorkspace = workspaceDocModel;
        if (workspaceDocModel == null) {
            return;
        }
        if (this.currentDocument == null) {
            this.setCurrentDocument(workspaceDocModel);
            return;
        }
        if (this.currentDocumentParents != null && !DocumentsListsUtils.isDocumentInList((DocumentModel)workspaceDocModel, this.currentDocumentParents)) {
            this.setCurrentDocument(workspaceDocModel);
            return;
        }
    }

    public void updateDocumentContext(DocumentModel doc) throws ClientException {
        this.setCurrentDocument(doc);
    }

    protected void updateContextVariables() throws ClientException {
        String docType;
        this.eventContext.set("currentDocument", (Object)this.currentDocument);
        if (this.currentDocument != null) {
            this.changeableDocument = this.currentDocument;
            this.eventContext.set("changeableDocument", (Object)this.changeableDocument);
        } else {
            this.changeableDocument = this.currentDocument;
            this.eventContext.remove("changeableDocument");
        }
        if (this.currentDocument == null) {
            return;
        }
        if (this.currentDocumentParents == null) {
            this.currentDocumentParents = this.documentManager.getParentDocuments(this.currentDocument.getRef());
        }
        if (this.currentDocumentParents != null) {
            for (int i = this.currentDocumentParents.size() - 1; i >= 0; --i) {
                DocumentModel docModel = this.currentDocumentParents.get(i);
                docType = docModel.getType();
                if (docType != null && this.hasSuperType(docType, "Workspace")) {
                    this.setCurrentWorkspace(docModel);
                }
                if (null == docType || this.hasSuperType(docType, "WorkspaceRoot") || this.hasSuperType(docType, "SectionRoot")) {
                    this.setCurrentContentRoot(docModel);
                }
                if (docType == null || !this.hasSuperType(docType, "Domain")) continue;
                this.setCurrentDomain(docModel);
            }
        }
        if ((docType = this.currentDocument.getType()).equals("Root")) {
            this.setCurrentDomain(null);
            this.setCurrentContentRoot(null);
            this.setCurrentWorkspace(null);
        } else if (this.hasSuperType(docType, "Domain")) {
            this.setCurrentDomain(this.currentDocument);
            this.setCurrentContentRoot(null);
            this.setCurrentWorkspace(null);
        } else if (this.hasSuperType(docType, "WorkspaceRoot") || this.hasSuperType(docType, "SectionRoot")) {
            this.setCurrentContentRoot(this.currentDocument);
            this.setCurrentWorkspace(null);
        } else if (this.hasSuperType(docType, "Workspace")) {
            this.setCurrentWorkspace(this.currentDocument);
        }
    }

    private SchemaManager getSchemaManager() throws Exception {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            if (this.schemaManager == null) {
                throw new ClientException("Could not find SchemaManager service");
            }
        }
        return this.schemaManager;
    }

    private boolean hasSuperType(String targetDocType, String superType) throws ClientException {
        if (targetDocType == null) {
            return false;
        }
        try {
            Set typeNames = this.getSchemaManager().getDocumentTypeNamesExtending(superType);
            for (String type : typeNames) {
                if (!type.equals(targetDocType)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ClientException("Could not extending types", (Throwable)e);
        }
    }

    public void resetCurrentContext() {
        this.eventContext.remove("currentDocument");
        this.eventContext.remove("changeableDocument");
        this.eventContext.remove("currentDocumentChildren");
        this.eventContext.remove("currentDomain");
        this.eventContext.remove("currentServerLocation");
        this.eventContext.remove("currentWorkspace");
        this.eventContext.remove("currentContentRoot");
        this.eventContext.remove("currentSuperSpace");
    }

    public String getActionResult(DocumentModel doc, UserAction action) throws ClientException {
        String result;
        TypesTool typesTool = (TypesTool)Component.getInstance((String)"typesTool");
        String logPrefix = "<getActionResult> ";
        if (doc == null) {
            return null;
        }
        if (UserAction.CREATE == action) {
            this.changeableDocument = doc;
            this.eventContext.set("changeableDocument", (Object)doc);
        } else {
            this.updateDocumentContext(doc);
        }
        Type type = typesTool.getType(doc.getType());
        if (UserAction.VIEW == action) {
            assert (this.currentDocument != null);
            EventManager.raiseEventsOnDocumentSelected((DocumentModel)this.currentDocument);
            result = ApplicationControllerHelper.getPageOnSelectedDocumentType(type);
        } else {
            if (UserAction.EDIT == action) {
                throw new UnsupportedOperationException("for action " + action);
            }
            if (UserAction.AFTER_EDIT == action) {
                assert (this.currentDocument != null);
                EventManager.raiseEventsOnDocumentChange((DocumentModel)this.currentDocument);
                result = ApplicationControllerHelper.getPageOnEditedDocumentType(type);
            } else if (UserAction.CREATE == action) {
                EventManager.raiseEventsOnDocumentCreate((DocumentModel)this.changeableDocument);
                result = ApplicationControllerHelper.getPageOnCreateDocumentType(type);
            } else if (UserAction.AFTER_CREATE == action) {
                assert (this.currentDocument != null);
                EventManager.raiseEventsOnDocumentSelected((DocumentModel)this.currentDocument);
                result = ApplicationControllerHelper.getPageOnCreatedDocumentType(type);
            } else if (UserAction.GO_HOME == action) {
                EventManager.raiseEventsOnGoingHome();
                result = "home";
            } else {
                log.error((Object)("<getActionResult> Bad action: " + action));
                result = null;
            }
        }
        return result;
    }

    public String goHome() {
        this.resetCurrentContext();
        EventManager.raiseEventsOnGoingHome();
        return "home";
    }

    public String goBack() throws ClientException {
        if (this.currentDocument != null) {
            this.setChangeableDocument(null);
            return this.navigateToDocument(this.currentDocument);
        }
        return this.goHome();
    }

    public String navigateToId(String documentId) throws ClientException {
        if (this.documentManager == null) {
            throw new IllegalStateException("documentManager not initialized");
        }
        IdRef docRef = new IdRef(documentId);
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)docRef);
        return this.navigateToDocument(doc, "view");
    }

    public String navigateToRef(DocumentRef docRef) throws ClientException {
        if (this.documentManager == null) {
            throw new IllegalStateException("documentManager not initialized");
        }
        DocumentModel doc = this.documentManager.getDocument(docRef);
        return this.navigateToDocument(doc, "view");
    }

    public String navigateToDocument(DocumentModel doc) throws ClientException {
        return this.navigateToDocument(doc, "view");
    }

    public String navigateToDocument(DocumentModel doc, String viewId) throws ClientException {
        if (doc != null) {
            this.updateDocumentContext(doc);
        }
        assert (this.currentDocument != null);
        TypeInfo typeInfo = (TypeInfo)this.currentDocument.getAdapter(TypeInfo.class);
        String chosenView = null;
        if (typeInfo != null) {
            String defaultView = typeInfo.getDefaultView();
            chosenView = "view".equals(viewId) ? defaultView : ("create".equals(viewId) ? typeInfo.getCreateView() : ("edit".equals(viewId) ? typeInfo.getEditView() : typeInfo.getView(viewId)));
            if (chosenView == null) {
                chosenView = defaultView;
            }
        }
        return chosenView;
    }

    public String navigateToDocumentWithView(DocumentModel doc, String viewId) throws ClientException {
        return this.navigateToDocument(doc, viewId);
    }

    public String navigateToDocument(DocumentModel docModel, VersionModel versionModel) throws ClientException {
        DocumentModel docVersion = this.documentManager.getDocumentWithVersion(docModel.getRef(), versionModel);
        return this.navigateToDocument(docVersion);
    }

    public void selectionChanged() {
        String logPrefix = "<selectionChanged> ";
        try {
            this.resetCurrentPath();
        }
        catch (ClientException e) {
            log.error((Object)"<selectionChanged> error reseting current path", (Throwable)e);
        }
    }

    public String getCurrentDocumentUrl() {
        if (null == this.currentDocument) {
            log.error((Object)"current document is null");
            return null;
        }
        return DocumentLocator.getDocumentUrl((RepositoryLocation)this.getCurrentServerLocation(), (DocumentRef)this.currentDocument.getRef());
    }

    public String getCurrentDocumentFullUrl() {
        if (null == this.currentDocument) {
            log.error((Object)"current document is null");
            return null;
        }
        return DocumentLocator.getFullDocumentUrl((RepositoryLocation)this.getCurrentServerLocation(), (DocumentRef)this.currentDocument.getRef());
    }

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String navigateTo(RepositoryLocation serverLocation, DocumentRef docRef) throws ClientException {
        if (!serverLocation.equals((Object)this.getCurrentServerLocation())) {
            this.setCurrentServerLocation(serverLocation);
        }
        return this.navigateToRef(docRef);
    }

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String navigateToURL(String documentUrl) throws ClientException {
        DocumentLocation docLoc;
        try {
            docLoc = DocumentLocator.parseDocRef((String)documentUrl);
        }
        catch (BadDocumentUriException e) {
            log.error((Object)("Cannot get document ref from uri " + documentUrl + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
        DocumentRef docRef = docLoc.getDocRef();
        RepositoryLocation repLoc = new RepositoryLocation(docLoc.getServerName());
        return this.navigateTo(repLoc, docRef);
    }

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String navigateToURL() throws ClientException {
        if (this.docRef == null) {
            return null;
        }
        return this.navigateToURL(this.docRef);
    }

    @Override
    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"<destroy> ");
    }

    protected void resetCurrentPath() throws ClientException {
        String logPrefix = "<resetCurrentPath> ";
        this.parents = new ArrayList<PathElement>();
        if (null == this.documentManager) {
            log.error((Object)"<resetCurrentPath> documentManager not initialized");
            return;
        }
        if (this.currentDocument != null) {
            if (this.currentDocument.isVersion()) {
                DocumentModel sourceDocument = this.documentManager.getSourceDocument(this.currentDocument.getRef());
                List parentList = this.documentManager.getParentDocuments(sourceDocument.getRef());
                for (DocumentModel docModel : parentList) {
                    this.parents.add((PathElement)new DocumentPathElement(docModel));
                }
                this.parents.add((PathElement)new ArchivedVersionsPathElement(sourceDocument));
                this.parents.add((PathElement)new VersionDocumentPathElement(this.currentDocument));
            } else if (this.currentDocumentParents != null) {
                for (DocumentModel docModel : this.currentDocumentParents) {
                    this.parents.add((PathElement)new DocumentPathElement(docModel));
                }
            }
        }
    }

    private void logDocWithTitle(String msg, DocumentModel doc) {
        if (null != doc) {
            try {
                log.debug((Object)(msg + " " + doc.getProperty("dublincore", "title")));
            }
            catch (ClientException e) {
                log.debug((Object)(msg + ", ERROR: " + (Object)((Object)e)));
            }
        } else {
            log.debug((Object)(msg + " NULL DOC"));
        }
    }

    public DocumentModel getCurrentContentRoot() {
        return this.currentContentRoot;
    }

    public void setCurrentContentRoot(DocumentModel crDocumentModel) {
        if (!this.checkIfUpdateNeeded(this.currentContentRoot, crDocumentModel)) {
            return;
        }
        this.currentContentRoot = crDocumentModel;
        this.eventContext.remove("currentContentRoot");
        if (crDocumentModel == null) {
            return;
        }
        if (this.currentDocument == null) {
            try {
                this.setCurrentDocument(null);
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
            return;
        }
        if (this.currentDocumentParents != null && !DocumentsListsUtils.isDocumentInList((DocumentModel)crDocumentModel, this.currentDocumentParents)) {
            try {
                this.setCurrentDocument(crDocumentModel);
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
    }
}

