/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.versioning;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.versioning.api.SnapshotOptions;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;
import org.nuxeo.ecm.webapp.versioning.VersionInfo;

@Name(value="documentVersioning")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DocumentVersioningBean
implements DocumentVersioning,
Serializable {
    private static final long serialVersionUID = 75409841629876L;
    private static final Log log = LogFactory.getLog(DocumentVersioningBean.class);
    private static final String VER_INFO_AUTO_INC_KEY = "message.versioning.editoptionsinfo.auto_increment";
    private static final String VER_INFO_NO_INC_KEY = "message.versioning.editoptionsinfo.no_increment";
    private static final String VER_INFO_UNDEF_KEY = "message.versioning.editoptionsinfo.undefined";
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected Map<String, String> availableVersioningOptionsMap;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    private transient VersioningManager versioningManager;
    private Boolean rendered;
    private VersioningActions selectedOption;
    private final Map<String, Boolean> uidInfoAvailableCache = new HashMap<String, Boolean>();

    @Override
    public Collection<VersioningActions> getCurrentItemVersioningOptions() {
        VersionIncEditOptions options = this.getAvailableVersioningOptions(this.navigationContext.getCurrentDocument());
        if (null == options) {
            return Collections.emptyList();
        }
        return options.getOptions();
    }

    @Override
    public Collection<VersionModel> getItemVersioningHistory(DocumentModel document) {
        return this.getAvailableVersioningHistory(document);
    }

    @Override
    public Collection<VersionModel> getCurrentItemVersioningHistory() {
        return this.getItemVersioningHistory(this.navigationContext.getCurrentDocument());
    }

    @Override
    @Factory(value="currentDocumentIncrementationRules", scope=ScopeType.EVENT)
    public String factoryForIncrementationRules() {
        if (!this.getRendered().booleanValue()) {
            return null;
        }
        return this.getIncRulesResult();
    }

    @Factory(autoCreate=true, value="currentDocumentVersionInfo", scope=ScopeType.EVENT)
    public VersionInfo getCurrentDocumentVersionInfo() throws ClientException {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        return new VersionInfo(this.getVersionLabel(docModel), this.getUidInfoAvailable());
    }

    @Override
    public String getIncRulesResult() {
        String editOptionsInfo = null;
        VersionIncEditOptions options = this.getAvailableVersioningOptions(this.navigationContext.getCurrentDocument());
        if (null == options) {
            editOptionsInfo = "Error retrieving inc options.";
            return editOptionsInfo;
        }
        VersioningActions vAction = options.getVersioningAction();
        if (vAction == VersioningActions.ACTION_AUTO_INCREMENT) {
            editOptionsInfo = (String)this.resourcesAccessor.getMessages().get(VER_INFO_AUTO_INC_KEY);
        } else if (vAction == VersioningActions.ACTION_NO_INCREMENT) {
            editOptionsInfo = (String)this.resourcesAccessor.getMessages().get(VER_INFO_NO_INC_KEY);
        } else if (vAction == VersioningActions.ACTION_UNDEFINED) {
            editOptionsInfo = (String)this.resourcesAccessor.getMessages().get(VER_INFO_UNDEF_KEY);
        } else if (vAction == VersioningActions.NO_VERSIONING) {
            editOptionsInfo = null;
        } else if (vAction == null) {
            editOptionsInfo = "please review versioning rules: " + options.getInfo();
        } else if (options.getOptions().isEmpty()) {
            editOptionsInfo = "Error. option: " + vAction + "; info: " + options.getInfo();
        }
        return editOptionsInfo;
    }

    private Collection<VersionModel> getAvailableVersioningHistory(DocumentModel doc) {
        List versions = Collections.emptyList();
        try {
            versions = this.documentManager.getVersionsForDocument(doc.getRef());
            for (VersionModel model : versions) {
                DocumentModel tempDoc = this.documentManager.getDocumentWithVersion(doc.getRef(), model);
                if (tempDoc == null) continue;
                VersioningDocument docVer = (VersioningDocument)tempDoc.getAdapter(VersioningDocument.class);
                String minorVer = docVer.getMinorVersion().toString();
                String majorVer = docVer.getMajorVersion().toString();
                model.setDescription(majorVer + '.' + minorVer);
            }
        }
        catch (ClientException e) {
            log.error((Object)"Error retrieving versioning history ", (Throwable)e);
        }
        catch (DocumentException e) {
            log.error((Object)"Error retrieving versioning history ", (Throwable)e);
        }
        return versions;
    }

    @Observer(value={"documentSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void resetVersioningOption() {
        this.availableVersioningOptionsMap = null;
        this.selectedOption = null;
        this.rendered = null;
    }

    public Map<String, String> getAvailableVersioningOptionsMap() {
        String logPrefix = "<getAvailableVersioningOptionsMap> ";
        log.debug((Object)"<getAvailableVersioningOptionsMap> Recomputing versioning options list");
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        Map<String, String> versioningOptionsMap = this.getVersioningOptionsMap(docModel);
        this.availableVersioningOptionsMap = new LinkedHashMap<String, String>();
        for (String key : versioningOptionsMap.keySet()) {
            String value = versioningOptionsMap.get(key);
            this.availableVersioningOptionsMap.put(value, key);
        }
        return this.availableVersioningOptionsMap;
    }

    @Observer(value={"changeableDocumentCreated"}, create=false, inject=false)
    @BypassInterceptors
    public void resetRenderingStatus() {
        this.rendered = false;
    }

    @Override
    public Map<String, String> getVersioningOptionsMap(DocumentModel documentModel) {
        if (documentModel == null) {
            throw new IllegalArgumentException("null documentModel");
        }
        LinkedHashMap<String, String> versioningOptionsMap = new LinkedHashMap<String, String>();
        VersionIncEditOptions options = this.getAvailableVersioningOptions(documentModel);
        if (options == null) {
            return versioningOptionsMap;
        }
        for (VersioningActions option : options.getOptions()) {
            String optionResName;
            String label = optionResName = "label.versioning.option." + option.toString();
            if (this.resourcesAccessor != null) {
                label = (String)this.resourcesAccessor.getMessages().get(optionResName);
            }
            versioningOptionsMap.put(option.name(), label);
        }
        return versioningOptionsMap;
    }

    private VersionIncEditOptions getAvailableVersioningOptions(DocumentModel documentModel) {
        VersionIncEditOptions options = null;
        try {
            options = this.versioningManager.getVersionIncEditOptions(documentModel);
        }
        catch (ClientException e) {
            log.error((Object)"Error retrieving versioning options ", (Throwable)e);
        }
        log.debug((Object)("Available options (retrieved from server): " + options));
        return options;
    }

    @Override
    public String getVersionLabel(DocumentModel document) throws ClientException {
        return this.versioningManager.getVersionLabel(document);
    }

    @Override
    @Deprecated
    public void incrementVersions(DocumentModel documentModel, VersioningActions selectedOption) {
        String logPrefix = "<incrementVersions> ";
        log.debug((Object)("<incrementVersions> " + selectedOption));
        try {
            this.saveDocumentAsNewVersion(documentModel);
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        try {
            if (selectedOption == VersioningActions.ACTION_INCREMENT_MAJOR) {
                this.incrementMajor(documentModel);
            } else if (selectedOption == VersioningActions.ACTION_INCREMENT_MINOR) {
                this.incrementMinor(documentModel);
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
    }

    private VersionModel saveDocumentAsNewVersion(DocumentModel documentModel) throws ClientException {
        DocumentRef docRef = documentModel.getRef();
        VersionModelImpl newVersion = new VersionModelImpl();
        newVersion.setLabel(this.documentManager.generateVersionLabelFor(docRef));
        this.documentManager.checkIn(docRef, (VersionModel)newVersion);
        log.debug((Object)("Checked in " + documentModel));
        this.documentManager.checkOut(docRef);
        log.debug((Object)("Checked out " + documentModel));
        return newVersion;
    }

    public String getVersioningOptionInstanceId() {
        if (this.selectedOption == null) {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            VersionIncEditOptions options = this.getAvailableVersioningOptions(currentDoc);
            this.selectedOption = options.getDefaultVersioningAction();
            if (this.selectedOption == null) {
                this.selectedOption = VersioningActions.ACTION_NO_INCREMENT;
            }
        }
        return this.selectedOption.name();
    }

    @Override
    public void setVersioningOptionInstanceId(String optionId) throws ClientException {
        this.setVersioningOptionInstanceId(this.navigationContext.getCurrentDocument(), optionId);
    }

    @Override
    public void setVersioningOptionInstanceId(DocumentModel docModel, String optionId) throws ClientException {
        log.debug((Object)("selected option: " + optionId));
        if (optionId != null) {
            this.selectedOption = VersioningActions.valueOf((String)optionId);
            this.setVersioningOptionInstanceId(docModel, this.selectedOption);
        }
    }

    @Override
    public void setVersioningOptionInstanceId(DocumentModel docModel, VersioningActions option) throws ClientException {
        boolean evaluateCreateSnapshot = !this.getDisplayCreateSnapshotOption();
        DocumentVersioningBean.setVersioningOptionInstanceId(docModel, option, evaluateCreateSnapshot);
    }

    public static void setVersioningOptionInstanceId(DocumentModel docModel, VersioningActions option, boolean evaluateCreateSnapshot) {
        docModel.putContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "VersioningOption", (Serializable)option);
        if (evaluateCreateSnapshot && (option == VersioningActions.ACTION_INCREMENT_MAJOR || option == VersioningActions.ACTION_INCREMENT_MINOR)) {
            docModel.putContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(true));
        }
    }

    @Override
    public void validateOptionSelection(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            return;
        }
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.versioning.none_selected", null, (Locale)locale);
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        throw new ValidatorException(message);
    }

    @Override
    public void setCreateSnapshot(boolean createSnapshot) {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        docModel.putContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(createSnapshot));
    }

    @Override
    public boolean getCreateSnapshot() throws ClientException {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        Serializable ctxCreateSnapshot = docModel.getContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE");
        boolean createSnapshot = ctxCreateSnapshot == null ? this.getDefaultCreateSnapshot() : ((Boolean)ctxCreateSnapshot).booleanValue();
        return createSnapshot;
    }

    @Override
    public boolean getDefaultCreateSnapshot() throws ClientException {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        SnapshotOptions option = this.versioningManager.getCreateSnapshotOption(docModel);
        return option == SnapshotOptions.DISPLAY_SELECTED;
    }

    @Override
    public boolean getDisplayCreateSnapshotOption() throws ClientException {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        SnapshotOptions option = this.versioningManager.getCreateSnapshotOption(docModel);
        return option == SnapshotOptions.DISPLAY_SELECTED || option == SnapshotOptions.DISPLAY_NOT_SELECTED;
    }

    @Override
    @Factory(value="renderVersioningOptionsForCurrentDocument", scope=ScopeType.EVENT)
    public boolean factoryForRenderVersioningOption() {
        return this.getRendered();
    }

    public Boolean getRendered() {
        if (this.rendered == null) {
            Map<String, String> options;
            this.rendered = false;
            if (this.navigationContext.getCurrentDocument() != null && (options = this.getAvailableVersioningOptionsMap()) != null && !options.isEmpty()) {
                this.rendered = true;
            }
        }
        return this.rendered;
    }

    public void setRendered(Boolean rendered) {
        this.rendered = rendered;
    }

    public Boolean getUidInfoAvailable() {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        String typeName = docModel.getType();
        Boolean isAvailable = this.uidInfoAvailableCache.get(typeName);
        if (isAvailable == null) {
            String majorProp = this.versioningManager.getMajorVersionPropertyName(typeName);
            String schemaName = DocumentModelUtils.getSchemaName((String)majorProp);
            try {
                isAvailable = docModel.getDataModel(schemaName) != null;
            }
            catch (ClientException e) {
                isAvailable = false;
            }
            this.uidInfoAvailableCache.put(typeName, isAvailable);
        }
        return isAvailable;
    }

    public Boolean getUidDataAvailable() {
        DocumentModel docModel = this.navigationContext.getCurrentDocument();
        String majorProp = this.versioningManager.getMajorVersionPropertyName(docModel.getType());
        String schemaName = DocumentModelUtils.getSchemaName((String)majorProp);
        String fieldName = DocumentModelUtils.getFieldName((String)majorProp);
        try {
            return docModel.getProperty(schemaName, fieldName) != null;
        }
        catch (ClientException e) {
            return null;
        }
    }

    @Deprecated
    public void incrementMajor(DocumentModel doc) throws ClientException {
        this.versioningManager.incrementMajor(doc);
    }

    @Deprecated
    public void incrementMinor(DocumentModel doc) throws ClientException {
        this.versioningManager.incrementMinor(doc);
    }
}

