/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Type;
import org.apache.chemistry.cmissql.CmisSqlLexer;
import org.apache.chemistry.cmissql.CmisSqlParser;
import org.apache.chemistry.impl.simple.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.chemistry.impl.DocumentModelHolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoCmisWalker;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoProperty;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class CMISQLQueryMaker
implements QueryMaker {
    private static final Log log = LogFactory.getLog(CMISQLQueryMaker.class);
    public static final String TYPE = "CMISQL";
    private static final String CMIS_PREFIX = "cmis:";
    public static final String DC_FRAGMENT_NAME = "dublincore";
    public static final String DC_CREATOR_KEY = "creator";
    public static final String DC_CREATED_KEY = "created";
    public static final String DC_MODIFIED_KEY = "modified";
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    protected Table hierTable;
    protected Map<String, String> propertyInfoNames;
    protected Map<String, String> allPropNames;
    public Map<String, Column> columns = new HashMap<String, Column>();
    public Map<String, Set<String>> columnsPerQual = new LinkedHashMap<String, Set<String>>();
    public final Map<String, SelectedColumn> columnAliases = new HashMap<String, SelectedColumn>();
    public final List<org.nuxeo.ecm.core.storage.sql.jdbc.db.Join> ftJoins = new LinkedList<org.nuxeo.ecm.core.storage.sql.jdbc.db.Join>();
    public List<String> errorMessages = new LinkedList<String>();
    public boolean hasScoreInSelect;
    public boolean hasContains;
    public Dialect.FulltextMatchInfo fulltextMatchInfo;
    protected static Map<String, String> systemPropNames = new HashMap<String, String>();

    public String getName() {
        return TYPE;
    }

    public boolean accepts(String queryType) {
        return queryType.equals(TYPE);
    }

    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String query, QueryFilter queryFilter, Object ... params) throws StorageException {
        NuxeoCmisWalker walker;
        NuxeoConnection conn = (NuxeoConnection)params[0];
        boolean addSystemColumns = params.length >= 2 && Boolean.TRUE.equals(params[1]);
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        this.propertyInfoNames = new HashMap<String, String>();
        for (String name : model.getPropertyInfoNames()) {
            this.propertyInfoNames.put(name.toUpperCase(), name);
        }
        this.allPropNames = new HashMap<String, String>(this.propertyInfoNames);
        for (PropertyDefinition pd : SimpleType.PROPS_MAP.values()) {
            String name = pd.getId();
            this.allPropNames.put(name.toUpperCase(), name);
        }
        this.hierTable = this.database.getTable("hierarchy");
        try {
            ANTLRInputStream input = new ANTLRInputStream((InputStream)new ByteArrayInputStream(query.getBytes("UTF-8")));
            CmisSqlLexer lexer = new CmisSqlLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            CommonTree tree = (CommonTree)new CmisSqlParser((TokenStream)tokens).query().getTree();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)tokens);
            walker = new NuxeoCmisWalker((TreeNodeStream)nodes);
            walker.query(this);
        }
        catch (IOException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
        catch (RecognitionException e) {
            throw new StorageException("Cannot parse query: " + query, (Throwable)e);
        }
        if (!this.errorMessages.isEmpty()) {
            throw new StorageException("Cannot parse query: " + query + " (" + StringUtils.join(this.errorMessages, (String)", ") + ")");
        }
        boolean distinct = walker.select_distinct;
        boolean skipHidden = true;
        ArrayList<SelectedColumn> columnsWhat = new ArrayList<SelectedColumn>();
        VirtualColumn sampleVirtualColumn = null;
        for (SelectedColumn sc : walker.select_what) {
            if (!(sc instanceof StarColumn)) {
                columnsWhat.add(sc);
                if (!(sc instanceof VirtualColumn)) continue;
                sampleVirtualColumn = (VirtualColumn)sc;
                continue;
            }
            String qual = ((StarColumn)sc).qual;
            for (Join join : walker.from_joins) {
                if (!this.sameString(qual, join.corr)) continue;
                Type type = conn.getRepository().getType(join.table);
                if (type == null && (type = conn.getRepository().getType(join.table.toLowerCase())) == null) {
                    throw new QueryMakerException("Unknown type: " + join.table);
                }
                for (PropertyDefinition pd : type.getPropertyDefinitions()) {
                    if (pd.isMultiValued()) continue;
                    try {
                        NamedColumn nc = this.referToColumnInSelect(pd.getId(), qual);
                        columnsWhat.add(nc);
                        if (!(nc instanceof VirtualColumn)) continue;
                        sampleVirtualColumn = (VirtualColumn)nc;
                    }
                    catch (QueryMakerException e) {}
                }
            }
        }
        ArrayList<DirectColumn> addedSystemColumns = new ArrayList<DirectColumn>(0);
        for (Map.Entry<String, Set<String>> entry : this.columnsPerQual.entrySet()) {
            String qual = entry.getKey();
            HashSet hashSet = new HashSet(entry.getValue());
            for (String propertyId : Arrays.asList("cmis:objectId")) {
                DirectColumn sc = (DirectColumn)this.referToColumnInSelect(propertyId, qual);
                String fqn = sc.column.getFullQuotedName();
                if (hashSet.contains(fqn)) continue;
                addedSystemColumns.add(sc);
            }
            if (!skipHidden) continue;
            Table table = this.getTable(this.database.getTable("misc"), qual);
            Column col = table.getColumn("lifecyclestate");
            this.recordCol(col, qual);
        }
        if (distinct) {
            if (!addedSystemColumns.isEmpty()) {
                if (sampleVirtualColumn != null) {
                    throw new QueryMakerException("Cannot use DISTINCT with virtual column " + CMISQLQueryMaker.getColumnName(sampleVirtualColumn));
                }
                if (addSystemColumns) {
                    throw new QueryMakerException("Cannot use DISTINCT without explicit cmis:objectId");
                }
            }
        } else {
            columnsWhat.addAll(addedSystemColumns);
        }
        HashMap tablesPerQual = new HashMap();
        for (Map.Entry<String, Set<String>> entry : this.columnsPerQual.entrySet()) {
            String string = entry.getKey();
            LinkedHashMap<String, Table> tables = (LinkedHashMap<String, Table>)tablesPerQual.get(string);
            if (tables == null) {
                tables = new LinkedHashMap<String, Table>();
                tablesPerQual.put(string, tables);
            }
            for (String fqn : entry.getValue()) {
                Column col = this.columns.get(fqn);
                tables.put(col.getTable().getName(), col.getTable());
            }
        }
        LinkedHashMap qualTables = new LinkedHashMap();
        for (Map.Entry entry : tablesPerQual.entrySet()) {
            String qual = (String)entry.getKey();
            Map tableMap = (Map)entry.getValue();
            tableMap.remove(this.getTableAlias(this.hierTable, qual));
            LinkedList tables = new LinkedList(tableMap.values());
            tables.add(this.getTable(this.hierTable, qual));
            qualTables.put(qual, tables);
        }
        LinkedList<String> whereClauses = new LinkedList<String>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        StringBuilder from = new StringBuilder();
        LinkedList<String> fromParams = new LinkedList<String>();
        int njoin = 0;
        for (Join j : walker.from_joins) {
            Object permissions;
            Object principals;
            boolean skipFolderish;
            String nuxeoType;
            String qual = j.corr;
            Table qualHierTable = this.getTable(this.hierTable, qual);
            Table table = null;
            if (++njoin == 1) {
                table = qualHierTable;
            } else {
                if (j.kind.equals("LEFT") || j.kind.equals("RIGHT")) {
                    from.append(" ");
                    from.append(j.kind);
                }
                from.append(" JOIN ");
                Set<String> fqns = this.columnsPerQual.get(qual);
                for (String fqn : Arrays.asList(j.on1, j.on2)) {
                    if (!fqns.contains(fqn)) continue;
                    Column col = this.columns.get(fqn);
                    table = col.getTable();
                }
                if (table == null) {
                    throw new StorageException("Bad query, qualifier not found: " + qual);
                }
            }
            String tableMainId = table.getColumn("id").getFullQuotedName();
            String name = table.isAlias() ? table.getRealTable().getQuotedName() + " " + table.getQuotedName() : table.getQuotedName();
            from.append(name);
            if (njoin != 1) {
                from.append(" ON ");
                from.append(j.on1);
                from.append(" = ");
                from.append(j.on2);
            }
            for (Table t : (List)qualTables.get(qual)) {
                if (t.getName().equals(table.getName())) continue;
                String n = t.isAlias() ? t.getRealTable().getQuotedName() + " " + t.getQuotedName() : t.getQuotedName();
                from.append(" LEFT JOIN ");
                from.append(n);
                from.append(" ON ");
                from.append(t.getColumn("id").getFullQuotedName());
                from.append(" = ");
                from.append(tableMainId);
            }
            if (j.table.equalsIgnoreCase(BaseType.DOCUMENT.getId())) {
                nuxeoType = "Document";
                skipFolderish = true;
            } else if (j.table.equalsIgnoreCase(BaseType.FOLDER.getId())) {
                nuxeoType = "Folder";
                skipFolderish = false;
            } else {
                nuxeoType = j.table;
                skipFolderish = false;
            }
            Set subTypes = model.getDocumentSubTypes(nuxeoType);
            if (subTypes == null) {
                throw new QueryMakerException("Unknown type: " + j.table);
            }
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> qms = new ArrayList<String>();
            for (String type : subTypes) {
                Set facets = model.getDocumentTypeFacets(type);
                if (skipFolderish && facets.contains("Folderish") || skipHidden && facets.contains("HiddenInNavigation")) continue;
                if (type.equals("Root")) continue;
                types.add(type);
                qms.add("?");
            }
            if (types.isEmpty()) {
                types.add("__NOSUCHTYPE__");
                qms.add("?");
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = qualHierTable.getColumn("primarytype").getFullQuotedName();
            objectArray[1] = StringUtils.join(qms, (String)", ");
            whereClauses.add(String.format("%s IN (%s)", objectArray));
            for (String type : types) {
                linkedList.add(type);
            }
            if (skipHidden) {
                Table misc = this.getTable(this.database.getTable("misc"), qual);
                Column lscol = misc.getColumn("lifecyclestate");
                whereClauses.add(String.format("%s <> ?", lscol.getFullQuotedName()));
                linkedList.add("deleted");
            }
            if (queryFilter == null || queryFilter.getPrincipals() == null) continue;
            if (this.dialect.supportsArrays()) {
                principals = queryFilter.getPrincipals();
                permissions = queryFilter.getPermissions();
            } else {
                principals = StringUtils.join((Object[])queryFilter.getPrincipals(), (char)'|');
                permissions = StringUtils.join((Object[])queryFilter.getPermissions(), (char)'|');
            }
            if (this.dialect.supportsReadAcl()) {
                String readAclAclIdCol;
                String readAclIdCol;
                String readAclTable;
                if (walker.from_joins.size() == 1) {
                    readAclTable = "hierarchy_read_acl";
                    readAclIdCol = "hierarchy_read_acl" + '.' + "id";
                    readAclAclIdCol = "hierarchy_read_acl" + '.' + "acl_id";
                } else {
                    String alias = "nxr" + njoin;
                    readAclTable = "hierarchy_read_acl" + " " + alias;
                    readAclIdCol = alias + '.' + "id";
                    readAclAclIdCol = alias + '.' + "acl_id";
                }
                whereClauses.add(this.dialect.getReadAclsCheckSql(readAclAclIdCol));
                linkedList.add(principals);
                from.append(String.format(" JOIN %s ON %s = %s", readAclTable, tableMainId, readAclIdCol));
                continue;
            }
            whereClauses.add(this.dialect.getSecurityCheckSql(tableMainId));
            linkedList.add(principals);
            linkedList.add(permissions);
        }
        Collections.sort(this.ftJoins);
        for (org.nuxeo.ecm.core.storage.sql.jdbc.db.Join join : this.ftJoins) {
            from.append(join.toString());
            if (join.tableParam == null) continue;
            fromParams.add(join.tableParam);
        }
        if (walker.select_where != null) {
            whereClauses.add('(' + walker.select_where + ')');
            linkedList.addAll(walker.select_where_params);
        }
        CMISQLMapMaker mapMaker = new CMISQLMapMaker(columnsWhat, conn);
        String what = StringUtils.join(mapMaker.selectWhat, (String)", ");
        if (distinct) {
            what = "DISTINCT " + what;
        }
        List<Serializable> whatParams = mapMaker.selectWhatParams;
        Select select = new Select(null);
        select.setWhat(what);
        select.setFrom(from.toString());
        select.setWhere(StringUtils.join(whereClauses, (String)" AND "));
        select.setOrderBy(StringUtils.join(walker.select_orderby, (String)", "));
        QueryMaker.Query q = new QueryMaker.Query();
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), (SQLInfo.MapMaker)mapMaker);
        q.selectParams = whatParams;
        q.selectParams.addAll(fromParams);
        q.selectParams.addAll(linkedList);
        return q;
    }

    public SelectedColumn referToAllColumns(String qual) {
        return new StarColumn(qual);
    }

    public SelectedColumn referToScoreInSelect() {
        if (this.hasScoreInSelect) {
            throw new QueryMakerException("At most one SCORE() is allowed");
        }
        this.hasScoreInSelect = true;
        ScoreColumn sc = new ScoreColumn();
        this.columnAliases.put(sc.alias, sc);
        Object qual = null;
        Set<String> fqns = this.columnsPerQual.get(qual);
        if (fqns == null) {
            fqns = new LinkedHashSet<String>();
            this.columnsPerQual.put((String)qual, fqns);
        }
        return sc;
    }

    public NamedColumn referToColumnInSelect(String c, String qual) {
        NamedColumn nc = this.findColumn(c, qual, false);
        if (nc instanceof DirectColumn) {
            this.recordCol(((DirectColumn)nc).column, qual);
        }
        return nc;
    }

    public String referToColumnInWhere(String c, String qual) {
        NamedColumn nc = this.findColumn(c, qual, false);
        if (!(nc instanceof DirectColumn)) {
            throw new QueryMakerException("Column " + c + " is not queryable");
        }
        Column col = ((DirectColumn)nc).column;
        this.recordCol(col, qual);
        return col.getFullQuotedName();
    }

    public String referToColumnInOrderBy(String c, String qual) {
        NamedColumn nc;
        if (qual == null && this.columnAliases.containsKey(c)) {
            SelectedColumn sc = this.columnAliases.get(c);
            if (sc instanceof ScoreColumn) {
                return this.fulltextMatchInfo.scoreAlias;
            }
            nc = (NamedColumn)sc;
        } else {
            nc = this.findColumn(c, qual, false);
            for (SelectedColumn asc : this.columnAliases.values()) {
                if (!this.columnAliases.values().contains(nc)) continue;
                throw new QueryMakerException("Column " + c + " cannot be used in ORDER BY because it is aliased");
            }
        }
        if (!(nc instanceof DirectColumn)) {
            throw new QueryMakerException("Column " + c + " cannot be used in ORDER BY because it is virtual");
        }
        Column col = ((DirectColumn)nc).column;
        this.recordCol(col, qual);
        return col.getFullQuotedName();
    }

    protected void recordCol(Column col, String qual) {
        String fqn = col.getFullQuotedName();
        this.columns.put(fqn, col);
        Set<String> fqns = this.columnsPerQual.get(qual);
        if (fqns == null) {
            fqns = new LinkedHashSet<String>();
            this.columnsPerQual.put(qual, fqns);
        }
        fqns.add(fqn);
    }

    public void aliasColumn(SelectedColumn sc, String alias) {
        sc.alias = alias;
        this.columnAliases.put(alias, sc);
    }

    public Column findMultiColumn(String name, String qual) {
        NamedColumn nc = this.findColumn(name, qual, true);
        if (!(nc instanceof DirectColumn)) {
            throw new QueryMakerException("Not a valid multi-valued property: " + name);
        }
        return ((DirectColumn)nc).column;
    }

    protected NamedColumn findColumn(String name, String qual, boolean multi) {
        String ucname = name.toUpperCase();
        if (ucname.startsWith(CMIS_PREFIX.toUpperCase())) {
            if (multi) {
                throw new QueryMakerException("Must use multi-valued property instead of " + name);
            }
            return this.getSpecialColumn(name, qual);
        }
        String propertyName = this.propertyInfoNames.get(ucname);
        if (propertyName == null) {
            throw new QueryMakerException("Unknown field: " + name);
        }
        ModelProperty propertyInfo = this.model.getPropertyInfo(propertyName);
        if (multi != propertyInfo.propertyType.isArray()) {
            String msg = multi ? "Must use multi-valued property instead of %s" : "Cannot use multi-valued property %s";
            throw new QueryMakerException(String.format(msg, name));
        }
        Table table = this.getTable(this.database.getTable(propertyInfo.fragmentName), qual);
        Column col = table.getColumn(multi ? "item" : propertyInfo.fragmentKey);
        String cname = this.allPropNames.get(ucname);
        return new DirectColumn(cname, qual, col);
    }

    protected Table getTable(Table table, String qual) {
        if (qual == null) {
            return table;
        }
        return new TableAlias(table, this.getTableAlias(table, qual));
    }

    protected String getTableAlias(Table table, String qual) {
        return "_" + qual + "_" + table.getName();
    }

    protected NamedColumn getSpecialColumn(String name, String qual) {
        String cname = this.allPropNames.get(name.toUpperCase());
        if (cname == null) {
            throw new QueryMakerException("Unknown field: " + name);
        }
        Column col = this.getSpecialColumn(cname);
        if (col != null) {
            if (qual != null) {
                col = this.getTable(col.getTable(), qual).getColumn(col.getKey());
            }
            return new DirectColumn(cname, qual, col);
        }
        return new VirtualColumn(cname, qual);
    }

    protected Column getSpecialColumn(String name) {
        if (name.equals("cmis:objectId")) {
            return this.hierTable.getColumn("id");
        }
        if (name.equals("cmis:objectTypeId")) {
            return this.hierTable.getColumn("primarytype");
        }
        if (name.equals("cmis:parentId")) {
            return this.hierTable.getColumn("parentid");
        }
        if (name.equals("cmis:name")) {
            return this.hierTable.getColumn("name");
        }
        if (name.equals("cmis:createdBy")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_CREATOR_KEY);
        }
        if (name.equals("cmis:creationDate")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_CREATED_KEY);
        }
        if (name.equals("cmis:lastModificationDate")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_MODIFIED_KEY);
        }
        return null;
    }

    protected static String getColumnName(NamedColumn nc) {
        String key = nc.name;
        if (nc.qual != null) {
            key = nc.qual + '.' + key;
        }
        return key;
    }

    protected String getInFolderSql(String qual, String arg, List<Serializable> params) {
        String idCol = this.referToColumnInWhere("cmis:parentId", qual);
        params.add((Serializable)((Object)arg));
        return idCol + " = ?";
    }

    protected String getInTreeSql(String qual, String arg, List<Serializable> params) {
        String idCol = this.referToColumnInWhere("cmis:objectId", qual);
        params.add((Serializable)((Object)arg));
        return this.dialect.getInTreeSql(idCol);
    }

    protected String getContainsSql(String qual, String arg, List<Serializable> params) {
        Dialect.FulltextMatchInfo info;
        if (this.hasContains) {
            throw new QueryMakerException("At most one CONTAINS() is allowed");
        }
        this.hasContains = true;
        Column mainColumn = this.hierTable.getColumn("id");
        this.fulltextMatchInfo = info = this.dialect.getFulltextScoredMatchInfo(arg, "default", 1, mainColumn, this.model, this.database);
        for (org.nuxeo.ecm.core.storage.sql.jdbc.db.Join join : info.joins) {
            if (join.kind != 2) continue;
        }
        if (info.joins != null) {
            this.ftJoins.addAll(info.joins);
        }
        String sql = info.whereExpr;
        if (info.whereExprParam != null) {
            params.add((Serializable)((Object)info.whereExprParam));
        }
        return sql;
    }

    private boolean sameString(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    static {
        for (String prop : Arrays.asList("cmis:objectId", "cmis:objectTypeId", "cmis:parentId", "cmis:name", "cmis:createdBy", "cmis:creationDate", "cmis:lastModificationDate")) {
            systemPropNames.put(prop.toUpperCase(), prop);
        }
    }

    public class CMISQLMapMaker
    implements SQLInfo.MapMaker {
        public final List<String> selectWhat;
        public final List<Serializable> selectWhatParams;
        public final List<Column> columns;
        public final List<String> keys;
        public final List<VirtualColumn> virtual;
        public final NuxeoConnection conn;

        public CMISQLMapMaker(List<SelectedColumn> columnsWhat, NuxeoConnection conn) {
            this.conn = conn;
            this.selectWhat = new ArrayList<String>(columnsWhat.size());
            this.selectWhatParams = new ArrayList<Serializable>(0);
            this.columns = new ArrayList<Column>(columnsWhat.size());
            this.keys = new ArrayList<String>(columnsWhat.size());
            this.virtual = new ArrayList<VirtualColumn>();
            for (SelectedColumn sc : columnsWhat) {
                if (sc instanceof DirectColumn) {
                    DirectColumn dc = (DirectColumn)sc;
                    Column col = dc.column;
                    this.columns.add(col);
                    this.selectWhat.add(col.getFullQuotedName());
                    this.keys.add(CMISQLQueryMaker.getColumnName(dc));
                    continue;
                }
                if (sc instanceof VirtualColumn) {
                    this.virtual.add((VirtualColumn)sc);
                    continue;
                }
                if (!(sc instanceof ScoreColumn)) continue;
                this.columns.add(CMISQLQueryMaker.this.fulltextMatchInfo.scoreCol);
                this.selectWhat.add(CMISQLQueryMaker.this.fulltextMatchInfo.scoreExpr);
                if (CMISQLQueryMaker.this.fulltextMatchInfo.scoreExprParam != null) {
                    this.selectWhatParams.add((Serializable)((Object)CMISQLQueryMaker.this.fulltextMatchInfo.scoreExprParam));
                }
                this.keys.add(sc.alias);
            }
        }

        public Map<String, Serializable> makeMap(ResultSet rs) throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (Column column : this.columns) {
                Serializable value;
                String key = this.keys.get(i - 1);
                if ((value = column.getFromResultSet(rs, i++)) instanceof Double) {
                    value = BigDecimal.valueOf((Double)value);
                }
                map.put(key, value);
            }
            HashMap<String, DocumentModel> docs = null;
            for (VirtualColumn vc : this.virtual) {
                Serializable v;
                DocumentModel doc;
                String qual = vc.qual;
                if (docs == null) {
                    docs = new HashMap<String, DocumentModel>(2);
                }
                if ((doc = (DocumentModel)docs.get(qual)) == null) {
                    NamedColumn idsc = CMISQLQueryMaker.this.getSpecialColumn("cmis:objectId", qual);
                    String id = (String)map.get(CMISQLQueryMaker.getColumnName(idsc));
                    try {
                        doc = this.conn.session.getDocument((DocumentRef)new IdRef(id));
                    }
                    catch (ClientException e) {
                        log.error((Object)("Cannot get document: " + id), (Throwable)e);
                    }
                    docs.put(qual, doc);
                }
                if (doc == null) {
                    v = null;
                } else {
                    PropertyDefinition pd = (PropertyDefinition)SimpleType.PROPS_MAP.get(vc.name);
                    Property p = NuxeoProperty.construct(vc.name, pd, (DocumentModelHolder)new DocHolder(doc));
                    v = p.getValue();
                }
                map.put(CMISQLQueryMaker.getColumnName(vc), v);
            }
            return map;
        }
    }

    public static class DocHolder
    implements DocumentModelHolder {
        public DocumentModel doc;

        public DocHolder(DocumentModel doc) {
            this.doc = doc;
        }

        @Override
        public DocumentModel getDocumentModel() {
            return this.doc;
        }

        @Override
        public void setDocumentModel(DocumentModel doc) {
            throw new UnsupportedOperationException();
        }
    }

    public static class VirtualColumn
    extends NamedColumn {
        public VirtualColumn(String name, String qual) {
            super(name, qual);
        }
    }

    public static class DirectColumn
    extends NamedColumn {
        public final Column column;

        public DirectColumn(String name, String qual, Column column) {
            super(name, qual);
            this.column = column;
        }
    }

    public static abstract class NamedColumn
    extends SelectedColumn {
        public final String name;
        public final String qual;

        public NamedColumn(String name, String qual) {
            this.name = name;
            this.qual = qual;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + (this.qual == null ? this.name : this.qual + '.' + this.name) + (this.alias == null ? "" : " AS " + this.alias) + ')';
        }

        protected String identity() {
            return this.qual + "." + this.name;
        }

        public int hashCode() {
            return this.identity().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NamedColumn)) {
                return false;
            }
            return this.identity().equals(((NamedColumn)obj).identity());
        }
    }

    public static class ScoreColumn
    extends SelectedColumn {
        public ScoreColumn() {
            this.alias = "SEARCH_SCORE";
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + (this.alias == null ? "" : this.alias) + ')';
        }
    }

    public static class StarColumn
    extends SelectedColumn {
        public final String qual;

        public StarColumn(String qual) {
            this.qual = qual;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + (this.qual == null ? "" : this.qual) + ')';
        }
    }

    public static abstract class SelectedColumn {
        public String alias;
    }

    protected static class QueryMakerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryMakerException(String message) {
            super(message);
        }
    }

    protected static class Join {
        String kind;
        String table;
        String corr;
        String on1;
        String on2;

        protected Join() {
        }
    }
}

