/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.chemistry.ACE;
import org.apache.chemistry.ACLPropagation;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentAlreadyExistsException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Policy;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.Rendition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.StreamNotSupportedException;
import org.apache.chemistry.Tree;
import org.apache.chemistry.Type;
import org.apache.chemistry.Unfiling;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.VersioningState;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleListPage;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.impl.simple.SimpleTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoDocument;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoFolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoObject;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoObjectEntry;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoPolicy;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoProperty;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoRelationship;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoRepository;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoType;
import org.nuxeo.ecm.core.security.SecurityPolicyService;
import org.nuxeo.runtime.api.Framework;

public class NuxeoConnection
implements Connection,
SPI {
    private static final Log log = LogFactory.getLog(NuxeoConnection.class);
    protected static final String DC_TITLE = "dc:title";
    protected final NuxeoRepository repository;
    protected final CoreSession session;
    protected final boolean ownSession;
    protected final NuxeoFolder rootFolder;
    protected final Map<String, String> queryTypeNames;
    protected final Map<String, String> queryPropNames;
    protected final Filter documentFilter;

    public NuxeoConnection(NuxeoRepository repository, Map<String, Serializable> params) {
        this(repository, NuxeoConnection.createSession(repository.getId(), params), true);
    }

    public NuxeoConnection(NuxeoRepository repository, CoreSession session) {
        this(repository, session, false);
    }

    protected NuxeoConnection(NuxeoRepository repository, CoreSession session, boolean ownSession) {
        if (!repository.getId().equals(session.getRepositoryName())) {
            throw new IllegalArgumentException("Session does not correspond to repository");
        }
        this.repository = repository;
        this.session = session;
        this.ownSession = ownSession;
        try {
            this.rootFolder = new NuxeoFolder(session.getRootDocument(), this, "");
        }
        catch (ClientException e) {
            throw new CMISRuntimeException("Could not get root document", (Throwable)e);
        }
        this.queryTypeNames = new HashMap<String, String>();
        this.queryPropNames = new HashMap<String, String>();
        for (Type type : repository.getTypeDescendants(null)) {
            String tname = type.getQueryName();
            String nxname = tname.equals(BaseType.FOLDER.getId().toLowerCase()) ? "Folder" : (tname.equals(BaseType.DOCUMENT.getId().toLowerCase()) ? "Document" : tname);
            this.queryTypeNames.put(tname.toLowerCase(), nxname);
            for (PropertyDefinition pd : type.getPropertyDefinitions()) {
                String id = pd.getId();
                this.queryPropNames.put(id, id);
            }
        }
        this.queryPropNames.putAll(NuxeoProperty.propertyNameToNXQL);
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        LifeCycleFilter lcFilter = new LifeCycleFilter("deleted", false);
        this.documentFilter = new CompoundFilter(new Filter[]{facetFilter, lcFilter});
    }

    protected static CoreSession createSession(String repositoryId, Map<String, Serializable> params) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (params != null) {
            context.putAll(params);
            context.put("username", params.get("username"));
        }
        if (context.get("username") == null) {
            context.put("username", "Administrator");
        }
        try {
            return CoreInstance.getInstance().open(repositoryId, context);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException("Could not connect", (Throwable)e);
        }
    }

    public SPI getSPI() {
        return this;
    }

    public void close() {
        if (this.ownSession) {
            CoreInstance.getInstance().close(this.session);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    public ObjectId newObjectId(String id) {
        return new SimpleObjectId(id);
    }

    public ObjectEntry newObjectEntry(String typeId) {
        DocumentModelImpl doc = new DocumentModelImpl(typeId);
        return new NuxeoObjectEntry((DocumentModel)doc, this);
    }

    private DocumentModel createDoc(String typeId, ObjectId folder, BaseType baseType) {
        DocumentModel doc;
        if (typeId == null) {
            throw new IllegalArgumentException("Missing object type id");
        }
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != baseType) {
            throw new IllegalArgumentException(typeId);
        }
        try {
            String typeName = ((NuxeoType)type).getNuxeoTypeName();
            doc = this.session.createDocumentModel(typeName);
        }
        catch (ClientException e) {
            throw new IllegalArgumentException(type.getId());
        }
        if (folder != null) {
            DocumentModel parentDoc;
            if (folder instanceof NuxeoFolder) {
                parentDoc = ((NuxeoFolder)folder).doc;
            } else {
                try {
                    parentDoc = this.session.getDocument((DocumentRef)new IdRef(folder.getId()));
                }
                catch (ClientException e) {
                    throw new CMISRuntimeException("Cannot create object", (Throwable)e);
                }
            }
            doc.setPathInfo(parentDoc.getPathAsString(), typeId);
        }
        return doc;
    }

    public Document newDocument(String typeId, Folder folder) {
        return new NuxeoDocument(this.createDoc(typeId, (ObjectId)folder, BaseType.DOCUMENT), this);
    }

    public Folder newFolder(String typeId, Folder folder) {
        return new NuxeoFolder(this.createDoc(typeId, (ObjectId)folder, BaseType.FOLDER), this);
    }

    public Relationship newRelationship(String typeId) {
        return new NuxeoRelationship(this.createDoc(typeId, null, BaseType.RELATIONSHIP), this);
    }

    public Policy newPolicy(String typeId, Folder folder) {
        return new NuxeoPolicy(this.createDoc(typeId, (ObjectId)folder, BaseType.POLICY), this);
    }

    protected List<Tree<ObjectEntry>> getTreeChildren(ObjectId entry, int depth, Inclusion inclusion, String orderBy, BaseType baseType) {
        ArrayList<Tree<ObjectEntry>> children = new ArrayList<Tree<ObjectEntry>>();
        for (ObjectEntry child : this.getChildren(entry, inclusion, orderBy, null)) {
            BaseType childBaseType = child.getBaseType();
            if (baseType != null && baseType != childBaseType) continue;
            List<Tree<ObjectEntry>> c = childBaseType != BaseType.FOLDER || depth == 1 ? null : this.getTreeChildren((ObjectId)child, depth - 1, inclusion, orderBy, baseType);
            children.add((Tree<ObjectEntry>)new SimpleTree((Object)child, c));
        }
        return children;
    }

    public Tree<ObjectEntry> getFolderTree(ObjectId folder, int depth, Inclusion inclusion) {
        return new SimpleTree(null, this.getTreeChildren(folder, depth, inclusion, null, BaseType.FOLDER));
    }

    public Tree<ObjectEntry> getDescendants(ObjectId folder, int depth, String orderBy, Inclusion inclusion) {
        return new SimpleTree(null, this.getTreeChildren(folder, depth, inclusion, orderBy, null));
    }

    public ListPage<ObjectEntry> getChildren(ObjectId folder, Inclusion inclusion, String orderBy, Paging paging) {
        DocumentModelList docs;
        try {
            String id = folder.getId();
            IdRef docRef = new IdRef(id);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(id);
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                throw new ObjectNotFoundException(id);
            }
            if (!doc.isFolder()) {
                throw new IllegalArgumentException("Not a folder: " + id);
            }
            docs = this.session.getChildren((DocumentRef)docRef, null, this.getDocumentFilter(), null);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        ArrayList<NuxeoObjectEntry> all = new ArrayList<NuxeoObjectEntry>(docs.size());
        for (DocumentModel child : docs) {
            all.add(new NuxeoObjectEntry(child, this));
        }
        return SimpleListPage.fromPaging(all, (Paging)paging);
    }

    protected Filter getDocumentFilter() {
        return this.documentFilter;
    }

    protected boolean isFilteredOut(DocumentModel doc) throws ClientException {
        return !this.documentFilter.accept(doc);
    }

    public ObjectEntry getFolderParent(ObjectId folder, String filter) {
        return this.getParent(folder, filter);
    }

    public Collection<ObjectEntry> getObjectParents(ObjectId object, String filter) {
        return Collections.singleton(this.getParent(object, filter));
    }

    protected ObjectEntry getParent(ObjectId object, String filter) {
        String objectId = object.getId();
        if (this.repository.getInfo().getRootFolderId().getId().equals(objectId)) {
            return null;
        }
        try {
            IdRef docRef = new IdRef(objectId);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(objectId);
            }
            DocumentModel parent = this.session.getParentDocument((DocumentRef)docRef);
            return new NuxeoObjectEntry(parent, this);
        }
        catch (DocumentSecurityException e) {
            return null;
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ListPage<ObjectEntry> getCheckedOutDocuments(ObjectId folder, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    protected NuxeoObjectEntry getObjectEntry(ObjectId object) {
        if (object instanceof NuxeoObjectEntry) {
            return (NuxeoObjectEntry)object;
        }
        try {
            IdRef docRef = new IdRef(object.getId());
            if (!this.session.exists((DocumentRef)docRef)) {
                return null;
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                return null;
            }
            return new NuxeoObjectEntry(doc, this);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException((Throwable)e);
        }
    }

    public ObjectId createDocumentFromSource(ObjectId source, ObjectId folder, Map<String, Serializable> properties, VersioningState versioningState) throws NameConstraintViolationException {
        if (folder == null) {
            throw new ConstraintViolationException("Unfiling not supported");
        }
        try {
            String id = source.getId();
            IdRef docRef = new IdRef(id);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(id);
            }
            String folderId = folder.getId();
            IdRef folderRef = new IdRef(folderId);
            if (!this.session.exists((DocumentRef)folderRef)) {
                throw new ObjectNotFoundException(folderId);
            }
            DocumentModel doc = this.session.copy((DocumentRef)docRef, (DocumentRef)folderRef, null);
            NuxeoObjectEntry entry = new NuxeoObjectEntry(doc, this);
            if (properties != null) {
                entry = this.updateProperties((ObjectId)entry, null, properties, true);
                entry.save();
            }
            this.session.save();
            return entry;
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ObjectId createDocument(Map<String, Serializable> properties, ObjectId folder, ContentStream contentStream, VersioningState versioningState) {
        if (folder == null) {
            throw new IllegalArgumentException("Missing folder");
        }
        if (BaseType.DOCUMENT.getId().equals(properties.get("cmis:objectTypeId"))) {
            properties = new HashMap<String, Serializable>(properties);
            properties.put("cmis:objectTypeId", (Serializable)((Object)"File"));
        }
        return this.createObject(properties, folder, BaseType.DOCUMENT, contentStream);
    }

    public ObjectId createFolder(Map<String, Serializable> properties, ObjectId folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Missing folder");
        }
        return this.createObject(properties, folder, BaseType.FOLDER, null);
    }

    public ObjectId createRelationship(Map<String, Serializable> properties) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createPolicy(Map<String, Serializable> properties, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    protected ObjectId createObject(Map<String, Serializable> properties, ObjectId folder, BaseType baseType, ContentStream contentStream) {
        String typeId = (String)((Object)properties.get("cmis:objectTypeId"));
        DocumentModel doc = this.createDoc(typeId, folder, baseType);
        NuxeoObjectEntry entry = new NuxeoObjectEntry(doc, this, true);
        this.updateProperties((ObjectId)entry, null, properties, true);
        try {
            if (contentStream != null) {
                try {
                    NuxeoProperty.setContentStream(doc, contentStream, true);
                }
                catch (ContentAlreadyExistsException e) {
                    // empty catch block
                }
            }
            doc = this.session.createDocument(doc);
            this.session.save();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException("Cannot create", (Throwable)e);
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        return NuxeoObject.construct(doc, this);
    }

    public Set<QName> getAllowableActions(ObjectId object) {
        NuxeoObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new ObjectNotFoundException(object.getId());
        }
        return entry.getAllowableActions();
    }

    public ObjectEntry getObject(ObjectId objectId, Inclusion inclusion) {
        return this.getProperties(objectId, inclusion);
    }

    public ObjectEntry getProperties(ObjectId object, Inclusion inclusion) {
        return this.getObjectEntry(object);
    }

    public ObjectEntry getObjectByPath(String path, Inclusion inclusion) {
        try {
            PathRef docRef = new PathRef(path);
            if (!this.session.exists((DocumentRef)docRef)) {
                return null;
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                return null;
            }
            return new NuxeoObjectEntry(doc, this);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public Folder getFolder(String path) {
        try {
            PathRef docRef = new PathRef(path);
            if (!this.session.exists((DocumentRef)docRef)) {
                return null;
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                return null;
            }
            return new NuxeoFolder(doc, this);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public CMISObject getObject(ObjectId object) {
        DocumentModel doc;
        try {
            IdRef docRef = new IdRef(object.getId());
            if (!this.session.exists((DocumentRef)docRef)) {
                return null;
            }
            doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                return null;
            }
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        switch (this.repository.getType(NuxeoType.mappedId(doc.getType())).getBaseType()) {
            case DOCUMENT: {
                return new NuxeoDocument(doc, this);
            }
            case FOLDER: {
                return new NuxeoFolder(doc, this);
            }
            case RELATIONSHIP: {
                return new NuxeoRelationship(doc, this);
            }
            case POLICY: {
                return new NuxeoPolicy(doc, this);
            }
        }
        throw new AssertionError();
    }

    public ListPage<Rendition> getRenditions(ObjectId object, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    public boolean hasContentStream(ObjectId document) {
        try {
            return this.getContentStream(document, null) != null;
        }
        catch (StreamNotSupportedException e) {
            return false;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ContentStream getContentStream(ObjectId object, String contentStreamId) throws IOException {
        DocumentModel doc;
        try {
            String objectId = object.getId();
            IdRef docRef = new IdRef(objectId);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(objectId);
            }
            doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                throw new ObjectNotFoundException(objectId);
            }
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        return NuxeoProperty.getContentStream(doc);
    }

    public ObjectId setContentStream(ObjectId document, ContentStream contentStream, boolean overwrite) throws IOException, ContentAlreadyExistsException {
        try {
            String documentId = document.getId();
            IdRef docRef = new IdRef(documentId);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(documentId);
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                throw new ObjectNotFoundException(documentId);
            }
            NuxeoProperty.setContentStream(doc, contentStream, overwrite);
            this.session.saveDocument(doc);
            this.session.save();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        return document;
    }

    public ObjectId deleteContentStream(ObjectId document) {
        try {
            return this.setContentStream(document, null, true);
        }
        catch (ContentAlreadyExistsException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public ObjectId updateProperties(ObjectId object, String changeToken, Map<String, Serializable> properties) {
        NuxeoObjectEntry entry = this.updateProperties(object, changeToken, properties, false);
        try {
            entry.save();
            this.session.save();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        return entry;
    }

    protected NuxeoObjectEntry updateProperties(ObjectId object, String changeToken, Map<String, Serializable> properties, boolean creation) {
        NuxeoObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new ObjectNotFoundException(object.getId());
        }
        for (Map.Entry<String, Serializable> en : properties.entrySet()) {
            String key = en.getKey();
            Type type = this.getRepository().getType(entry.getTypeId());
            PropertyDefinition prop = type.getPropertyDefinition(key);
            if (prop == null) {
                log.error((Object)("Unknown property, ignored: " + key));
                continue;
            }
            Updatability updatability = prop.getUpdatability();
            if (updatability == Updatability.READ_ONLY || updatability == Updatability.ON_CREATE && !creation || "cmis:objectTypeId".equals(key) || "cmis:lastModificationDate".equals(key)) continue;
            entry.setValue(key, en.getValue());
        }
        try {
            if (entry.getValue(DC_TITLE) == null) {
                entry.setValue(DC_TITLE, entry.getValue("cmis:name"));
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return entry;
    }

    public ObjectId moveObject(ObjectId object, ObjectId targetFolder, ObjectId sourceFolder) {
        String id = object.getId();
        if (this.repository.getInfo().getRootFolderId().getId().equals(id)) {
            throw new ConstraintViolationException("Cannot move root");
        }
        try {
            IdRef docRef = new IdRef(id);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(id);
            }
            DocumentModel parent = this.session.getParentDocument((DocumentRef)docRef);
            if (sourceFolder == null) {
                String sourceFolderId = parent.getId();
            } else {
                String sourceFolderId = sourceFolder.getId();
                if (!parent.getId().equals(sourceFolderId)) {
                    throw new ConstraintViolationException("Object " + id + " is not filed in " + sourceFolderId);
                }
            }
            DocumentModel doc = this.session.move((DocumentRef)docRef, (DocumentRef)new IdRef(targetFolder.getId()), null);
            this.session.save();
            if (object instanceof NuxeoObjectEntry) {
                NuxeoObjectEntry noe = (NuxeoObjectEntry)object;
                noe.setDocumentModel(doc);
                return noe;
            }
            return this.newObjectId(doc.getId());
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void deleteObject(ObjectId object, boolean allVersions) {
        String objectId = object.getId();
        if (this.repository.getInfo().getRootFolderId().getId().equals(objectId)) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        try {
            DocumentModelList docs;
            IdRef docRef = new IdRef(objectId);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(objectId);
            }
            NuxeoObjectEntry entry = this.getObjectEntry(object);
            if (entry == null) {
                throw new ObjectNotFoundException(objectId);
            }
            if (entry.getBaseType() == BaseType.FOLDER && (docs = this.session.getChildren((DocumentRef)docRef, null, this.getDocumentFilter(), null)).size() > 0) {
                throw new ConstraintViolationException("Cannot delete non-empty folder: " + objectId);
            }
            this.session.removeDocument((DocumentRef)docRef);
            this.session.save();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public Collection<ObjectId> deleteTree(ObjectId folder, Unfiling unfiling, boolean continueOnFailure) {
        if (unfiling == Unfiling.UNFILE) {
            throw new ConstraintViolationException("Unfiling not supported");
        }
        String folderId = folder.getId();
        if (this.repository.getInfo().getRootFolderId().getId().equals(folderId)) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        try {
            IdRef docRef = new IdRef(folderId);
            if (!this.session.exists((DocumentRef)docRef)) {
                throw new ObjectNotFoundException(folderId);
            }
            NuxeoObjectEntry entry = this.getObjectEntry(folder);
            if (entry == null) {
                throw new ObjectNotFoundException(folderId);
            }
            if (entry.getBaseType() != BaseType.FOLDER) {
                throw new IllegalArgumentException("Not a folder: " + folderId);
            }
            this.session.removeDocument((DocumentRef)docRef);
            this.session.save();
            return Collections.emptyList();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void addObjectToFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    public void removeObjectFromFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    public ListPage<ObjectEntry> query(String statement, boolean searchAllVersions, Inclusion inclusion, Paging paging) {
        IterableQueryResult iterable;
        try {
            iterable = this.session.queryAndFetch(statement, "CMISQL", new Object[]{this});
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        iterable = this.getPolicyFilteredMaps(iterable);
        if (paging != null && paging.skipCount > 0) {
            iterable.skipTo((long)paging.skipCount);
        }
        Iterator it = iterable.iterator();
        int maxItems = paging == null || paging.maxItems == 0 ? -1 : paging.maxItems;
        SimpleListPage page = new SimpleListPage();
        while (it.hasNext()) {
            Type type;
            Map next = (Map)it.next();
            SimpleData data = new SimpleData(null, null);
            String typeId = null;
            for (Map.Entry entry : next.entrySet()) {
                String key = (String)entry.getKey();
                Object value = (Serializable)entry.getValue();
                if (key.endsWith("cmis:objectTypeId")) {
                    value = NuxeoType.mappedId((String)value);
                    if (typeId == null) {
                        typeId = (String)value;
                    }
                }
                if (value == null) continue;
                data.put((Object)key, value);
            }
            if (typeId != null && (type = this.repository.getType(typeId)) != null) {
                data.put((Object)"cmis:baseTypeId", (Object)type.getBaseType().getId());
            }
            page.add((Object)new SimpleObjectEntry(data, (Connection)this));
            if (--maxItems != 0) continue;
            break;
        }
        page.setHasMoreItems(it.hasNext());
        page.setNumItems((int)iterable.size());
        iterable.close();
        return page;
    }

    public Collection<CMISObject> query(String statement, boolean searchAllVersions) {
        IterableQueryResult iterable;
        try {
            iterable = this.session.queryAndFetch(statement, "CMISQL", new Object[]{this, Boolean.TRUE});
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        List<String> ids = this.getPolicyFilteredIds(iterable);
        ArrayList<CMISObject> results = new ArrayList<CMISObject>(ids.size());
        for (String id : ids) {
            DocumentModel doc;
            try {
                doc = this.session.getDocument((DocumentRef)new IdRef(id));
            }
            catch (ClientException e) {
                log.error((Object)("Cannot fetch document: " + id), (Throwable)e);
                continue;
            }
            results.add(NuxeoObject.construct(doc, this));
        }
        iterable.close();
        return results;
    }

    protected List<String> getPolicyFilteredIds(IterableQueryResult iterable) {
        SecurityPolicyService service;
        try {
            service = (SecurityPolicyService)Framework.getService(SecurityPolicyService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
        String permission = "Browse";
        boolean filterPolicies = service.arePoliciesRestrictingPermission(permission);
        ArrayList<String> ids = new ArrayList<String>();
        block4: for (Map map : iterable) {
            boolean gotId = false;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.equals("cmis:objectId") && !key.endsWith(".cmis:objectId")) continue;
                String id = (String)entry.getValue();
                if (filterPolicies) {
                    boolean ok;
                    try {
                        ok = this.session.hasPermission((DocumentRef)new IdRef(id), permission);
                    }
                    catch (ClientException e) {
                        log.error((Object)("Cannot fetch document: " + id), (Throwable)e);
                        ok = false;
                    }
                    if (!ok) continue block4;
                }
                if (gotId) continue;
                ids.add(id);
                gotId = true;
            }
        }
        return ids;
    }

    protected IterableQueryResult getPolicyFilteredMaps(IterableQueryResult iterable) {
        SecurityPolicyService service;
        try {
            service = (SecurityPolicyService)Framework.getService(SecurityPolicyService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
        String permission = "Browse";
        boolean filterPolicies = service.arePoliciesRestrictingPermission(permission);
        if (!filterPolicies) {
            return iterable;
        }
        ArrayList<Map<String, Serializable>> list = new ArrayList<Map<String, Serializable>>();
        block4: for (Map map : iterable) {
            for (Map.Entry entry : map.entrySet()) {
                boolean ok;
                String key = (String)entry.getKey();
                if (!key.equals("cmis:objectId") && !key.endsWith(".cmis:objectId")) continue;
                String id = (String)entry.getValue();
                try {
                    ok = this.session.hasPermission((DocumentRef)new IdRef(id), permission);
                }
                catch (ClientException e) {
                    log.error((Object)("Cannot fetch document: " + id), (Throwable)e);
                    ok = false;
                }
                if (ok) continue;
                continue block4;
            }
            list.add(map);
        }
        iterable.close();
        return new ListQueryResult(list);
    }

    public ListPage<ObjectEntry> getChangeLog(String changeLogToken, boolean includeProperties, Paging paging, String[] lastChangeLogToken) {
        lastChangeLogToken[0] = null;
        return SimpleListPage.emptyList();
    }

    public ObjectId checkOut(ObjectId document, boolean[] contentCopied) {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut(ObjectId document) {
        throw new UnsupportedOperationException();
    }

    public ObjectId checkIn(ObjectId document, Map<String, Serializable> properties, ContentStream contentStream, boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Serializable> getPropertiesOfLatestVersion(String versionSeriesId, boolean major, String filter) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAllVersions(String versionSeriesId, String filter) {
        throw new UnsupportedOperationException();
    }

    public ListPage<ObjectEntry> getRelationships(ObjectId object, String typeId, boolean includeSubRelationshipTypes, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    public void applyPolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAppliedPolicies(ObjectId policy, String filter) {
        return Collections.emptyList();
    }

    public List<ACE> getACL(ObjectId object, boolean onlyBasicPermissions, boolean[] exact) {
        return Collections.emptyList();
    }

    public List<ACE> applyACL(ObjectId object, List<ACE> addACEs, List<ACE> removeACEs, ACLPropagation propagation, boolean[] exact, String[] changeToken) {
        throw new UnsupportedOperationException();
    }

    public static class ListQueryResult
    implements IterableQueryResult,
    Iterator<Map<String, Serializable>> {
        public final List<Map<String, Serializable>> list;
        public int pos;

        public ListQueryResult(List<Map<String, Serializable>> list) {
            this.list = list;
            this.pos = 0;
        }

        public Iterator<Map<String, Serializable>> iterator() {
            return this;
        }

        public long pos() {
            return this.pos;
        }

        public long size() {
            return this.list.size();
        }

        public void skipTo(long pos) {
            if (pos < 0L || pos > (long)this.list.size()) {
                throw new NoSuchElementException();
            }
            this.pos = (int)pos;
        }

        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        @Override
        public Map<String, Serializable> next() {
            try {
                return this.list.get(this.pos++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

