/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentAlreadyExistsException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.StreamNotSupportedException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoFolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoObject;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoProperty;

public class NuxeoDocument
extends NuxeoObject
implements Document {
    public NuxeoDocument(DocumentModel doc, NuxeoConnection connection) {
        super(doc, connection);
    }

    public Document checkOut() {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut() {
        throw new UnsupportedOperationException();
    }

    public Document checkIn(boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    public Document getLatestVersion(boolean major) {
        throw new UnsupportedOperationException();
    }

    public Collection<Document> getAllVersions() {
        throw new UnsupportedOperationException();
    }

    public void deleteAllVersions() {
        throw new UnsupportedOperationException();
    }

    public boolean hasContentStream() {
        if (this.getType().getContentStreamAllowed() == ContentStreamPresence.NOT_ALLOWED) {
            return false;
        }
        try {
            return NuxeoProperty.getContentStream(this.doc) != null;
        }
        catch (StreamNotSupportedException e) {
            return false;
        }
    }

    public ContentStream getContentStream() {
        return NuxeoProperty.getContentStream(this.doc);
    }

    public void setContentStream(ContentStream contentStream) throws IOException, CMISRuntimeException {
        ContentStreamPresence csa = this.getType().getContentStreamAllowed();
        if (csa == ContentStreamPresence.NOT_ALLOWED && contentStream != null) {
            throw new ConstraintViolationException("Content stream not allowed");
        }
        if (csa == ContentStreamPresence.REQUIRED && contentStream == null) {
            throw new ConstraintViolationException("Content stream required");
        }
        try {
            NuxeoProperty.setContentStream(this.doc, contentStream, true);
        }
        catch (ContentAlreadyExistsException contentAlreadyExistsException) {
            // empty catch block
        }
    }

    public Document copy(Folder folder) throws NameConstraintViolationException {
        if (folder == null) {
            throw new ConstraintViolationException("Unfiling not supported");
        }
        try {
            DocumentModel newdoc = this.connection.session.copy(this.doc.getRef(), ((NuxeoFolder)folder).doc.getRef(), null);
            this.connection.session.save();
            return new NuxeoDocument(newdoc, this.connection);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }
}

