/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Unfiling;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoObject;

public class NuxeoFolder
extends NuxeoObject
implements Folder {
    public final String name;

    public NuxeoFolder(DocumentModel doc, NuxeoConnection connection) {
        super(doc, connection);
        this.name = null;
    }

    public NuxeoFolder(DocumentModel doc, NuxeoConnection connection, String name) {
        super(doc, connection);
        this.name = name;
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public void add(CMISObject object) {
        throw new UnsupportedOperationException();
    }

    public void remove(CMISObject object) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectId> deleteTree(Unfiling unfiling) {
        throw new UnsupportedOperationException();
    }

    public List<CMISObject> getChildren() {
        DocumentModelList docs;
        try {
            docs = this.connection.session.getChildren(this.doc.getRef(), null, this.connection.getDocumentFilter(), null);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException((Throwable)e);
        }
        if (docs == null) {
            throw new IllegalArgumentException(this.doc.getId());
        }
        ArrayList<CMISObject> children = new ArrayList<CMISObject>(docs.size());
        for (DocumentModel child : docs) {
            children.add(NuxeoObject.construct(child, this.connection));
        }
        return children;
    }

    public Document newDocument(String typeId) {
        return this.connection.newDocument(typeId, this);
    }

    public Folder newFolder(String typeId) {
        return this.connection.newFolder(typeId, this);
    }
}

