/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Property;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Type;
import org.apache.chemistry.impl.base.BaseObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.chemistry.impl.DocumentModelHolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoDocument;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoFolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoProperty;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoType;

public class NuxeoObject
extends BaseObject
implements CMISObject,
DocumentModelHolder {
    protected DocumentModel doc;
    protected NuxeoConnection connection;

    protected NuxeoObject(DocumentModel doc, NuxeoConnection connection) {
        this.doc = doc;
        this.connection = connection;
    }

    @Override
    public void setDocumentModel(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocumentModel() {
        return this.doc;
    }

    protected static NuxeoObject construct(DocumentModel doc, NuxeoConnection connection) {
        if (doc.isFolder()) {
            return new NuxeoFolder(doc, connection);
        }
        return new NuxeoDocument(doc, connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void move(Folder targetFolder, Folder sourceFolder) {
        this.connection.moveObject((ObjectId)this, (ObjectId)targetFolder, (ObjectId)sourceFolder);
    }

    public void delete() {
        this.connection.deleteObject((ObjectId)this, false);
    }

    public void unfile() {
        this.connection.removeObjectFromFolder((ObjectId)this, null);
    }

    public Folder getParent() {
        if (this.doc.getPathAsString().equals("/")) {
            return null;
        }
        DocumentRef parentRef = this.doc.getParentRef();
        if (parentRef == null) {
            return null;
        }
        try {
            return new NuxeoFolder(this.connection.session.getDocument(parentRef), this.connection);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public Collection<Folder> getParents() {
        if (this.doc.getPathAsString().equals("/")) {
            return Collections.emptyList();
        }
        DocumentRef parentRef = this.doc.getParentRef();
        if (parentRef == null) {
            return Collections.emptyList();
        }
        try {
            NuxeoFolder folder = new NuxeoFolder(this.connection.session.getDocument(parentRef), this.connection);
            return Collections.singletonList(folder);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public List<Relationship> getRelationships(RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public void applyPolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    public Collection<Policy> getPolicies() {
        throw new UnsupportedOperationException();
    }

    public Type getType() {
        return this.connection.repository.getType(NuxeoType.mappedId(this.doc.getType()));
    }

    public BaseType getBaseType() {
        return this.getType().getBaseType();
    }

    public Serializable getValue(String name) {
        return this.getProperty(name).getValue();
    }

    public Property getProperty(String name) {
        return NuxeoProperty.construct(name, this.getType(), (DocumentModelHolder)this);
    }

    public ContentStream getContentStream(String contentStreamId) {
        throw new UnsupportedOperationException();
    }

    public void save() {
        try {
            if (this.getId() == null) {
                if (this.getName() == null) {
                    throw new IllegalArgumentException("Missing name");
                }
                this.connection.session.createDocument(this.doc);
            } else {
                this.connection.session.saveDocument(this.doc);
            }
            this.connection.session.save();
        }
        catch (ClientException e) {
            throw new RuntimeException("Cannot save: " + (Object)((Object)e), e);
        }
    }
}

