/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.chemistry.AllowableAction;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ChangeInfo;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Type;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.chemistry.impl.DocumentModelHolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoProperty;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoType;

public class NuxeoObjectEntry
implements ObjectEntry,
DocumentModelHolder {
    private DocumentModel doc;
    private final Type type;
    private final boolean canWrite;

    protected NuxeoObjectEntry(DocumentModel doc, NuxeoConnection connection) {
        this(doc, connection, false);
    }

    protected NuxeoObjectEntry(DocumentModel doc, NuxeoConnection connection, boolean creation) {
        boolean canWrite;
        this.doc = doc;
        this.type = connection.repository.getType(NuxeoType.mappedId(doc.getType()));
        try {
            canWrite = creation || connection.session.hasPermission(doc.getRef(), "Write");
        }
        catch (ClientException e) {
            canWrite = false;
        }
        this.canWrite = canWrite;
    }

    @Override
    public void setDocumentModel(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocumentModel() {
        return this.doc;
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getTypeId() {
        return NuxeoType.mappedId(this.doc.getType());
    }

    public BaseType getBaseType() {
        return this.type.getBaseType();
    }

    public ChangeInfo getChangeInfo() {
        return null;
    }

    public String getPathSegment() {
        return this.doc.getName();
    }

    public Serializable getValue(String id) {
        return NuxeoProperty.construct(id, this.type, (DocumentModelHolder)this).getValue();
    }

    public void setValue(String id, Serializable value) {
        NuxeoProperty.construct(id, this.type, (DocumentModelHolder)this).setValue(value);
    }

    public Map<String, Serializable> getValues() {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (PropertyDefinition propertyDefinition : this.type.getPropertyDefinitions()) {
            String id = propertyDefinition.getId();
            values.put(id, this.getValue(id));
        }
        return values;
    }

    public void setValues(Map<String, Serializable> values) {
        for (String id : values.keySet()) {
            this.setValue(id, values.get(id));
        }
    }

    public Set<QName> getAllowableActions() {
        boolean isFolder = this.doc.isFolder();
        HashSet<QName> set = new HashSet<QName>();
        set.add(AllowableAction.CAN_GET_OBJECT_PARENTS);
        set.add(AllowableAction.CAN_GET_PROPERTIES);
        if (isFolder) {
            set.add(AllowableAction.CAN_GET_DESCENDANTS);
            set.add(AllowableAction.CAN_GET_FOLDER_PARENT);
            set.add(AllowableAction.CAN_GET_FOLDER_TREE);
            set.add(AllowableAction.CAN_GET_CHILDREN);
        } else {
            set.add(AllowableAction.CAN_GET_CONTENT_STREAM);
        }
        if (this.canWrite) {
            if (isFolder) {
                set.add(AllowableAction.CAN_CREATE_DOCUMENT);
                set.add(AllowableAction.CAN_CREATE_FOLDER);
                set.add(AllowableAction.CAN_CREATE_RELATIONSHIP);
                set.add(AllowableAction.CAN_DELETE_TREE);
                set.add(AllowableAction.CAN_ADD_OBJECT_TO_FOLDER);
                set.add(AllowableAction.CAN_REMOVE_OBJECT_FROM_FOLDER);
            } else {
                set.add(AllowableAction.CAN_SET_CONTENT_STREAM);
                set.add(AllowableAction.CAN_DELETE_CONTENT_STREAM);
            }
            set.add(AllowableAction.CAN_UPDATE_PROPERTIES);
            set.add(AllowableAction.CAN_MOVE_OBJECT);
            set.add(AllowableAction.CAN_DELETE_OBJECT);
        }
        if (Boolean.FALSE.booleanValue()) {
            set.add(AllowableAction.CAN_GET_RENDITIONS);
            set.add(AllowableAction.CAN_CHECK_OUT);
            set.add(AllowableAction.CAN_CANCEL_CHECK_OUT);
            set.add(AllowableAction.CAN_CHECK_IN);
            set.add(AllowableAction.CAN_GET_ALL_VERSIONS);
            set.add(AllowableAction.CAN_GET_OBJECT_RELATIONSHIPS);
            set.add(AllowableAction.CAN_APPLY_POLICY);
            set.add(AllowableAction.CAN_REMOVE_POLICY);
            set.add(AllowableAction.CAN_GET_APPLIED_POLICIES);
            set.add(AllowableAction.CAN_GET_ACL);
            set.add(AllowableAction.CAN_APPLY_ACL);
        }
        return set;
    }

    public Collection<ObjectEntry> getRelationships() {
        throw new UnsupportedOperationException();
    }

    protected void save() throws ClientException {
        this.doc.getCoreSession().saveDocument(this.doc);
    }
}

