/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.ContentAlreadyExistsException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.StreamNotSupportedException;
import org.apache.chemistry.Type;
import org.apache.chemistry.Updatability;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.chemistry.impl.DocumentModelHolder;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoContentStream;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoPropertyBase;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoType;

public class NuxeoProperty
extends NuxeoPropertyBase {
    protected final String name;
    protected final boolean readOnly;
    public static final Map<String, String> propertyNameToNXQL;

    public NuxeoProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder, String name, boolean readOnly) {
        super(propertyDefinition, docHolder);
        this.name = name;
        this.readOnly = readOnly;
    }

    public Serializable getValue() {
        try {
            Serializable value = this.docHolder.getDocumentModel().getPropertyValue(this.name);
            if (value instanceof Double) {
                value = BigDecimal.valueOf((Double)value);
            }
            return value;
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    @Override
    public void setValue(Serializable value) {
        try {
            if (this.readOnly) {
                super.setValue(value);
            } else {
                if (value instanceof BigDecimal) {
                    value = Double.valueOf(((BigDecimal)value).doubleValue());
                }
                this.docHolder.getDocumentModel().setPropertyValue(this.name, value);
            }
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected static Property construct(String name, Type type, DocumentModelHolder docHolder) {
        return NuxeoProperty.construct(name, type.getPropertyDefinition(name), docHolder);
    }

    protected static Property construct(String name, PropertyDefinition pd, DocumentModelHolder docHolder) {
        if (pd == null) {
            throw new IllegalArgumentException(name);
        }
        DocumentModel doc = docHolder.getDocumentModel();
        if ("cmis:objectId".equals(name)) {
            return new FixedProperty(pd, (Serializable)((Object)doc.getId()));
        }
        if ("cmis:objectTypeId".equals(name)) {
            return new FixedProperty(pd, (Serializable)((Object)NuxeoType.mappedId(doc.getType())));
        }
        if ("cmis:baseTypeId".equals(name)) {
            return new FixedProperty(pd, (Serializable)((Object)(doc.isFolder() ? BaseType.FOLDER.getId() : BaseType.DOCUMENT.getId())));
        }
        if ("cmis:createdBy".equals(name)) {
            return new NuxeoProperty(pd, docHolder, "dc:creator", true);
        }
        if ("cmis:creationDate".equals(name)) {
            return new NuxeoProperty(pd, docHolder, "dc:created", true);
        }
        if ("cmis:lastModifiedBy".equals(name)) {
            return new LastModifiedByProperty(pd, docHolder);
        }
        if ("cmis:lastModificationDate".equals(name)) {
            return new NuxeoProperty(pd, docHolder, "dc:modified", true);
        }
        if ("cmis:changeToken".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:name".equals(name)) {
            return new NameProperty(pd, docHolder);
        }
        if ("cmis:isImmutable".equals(name)) {
            return new FixedProperty(pd, Boolean.FALSE);
        }
        if ("cmis:isLatestVersion".equals(name)) {
            return new FixedProperty(pd, Boolean.TRUE);
        }
        if ("cmis:isMajorVersion".equals(name)) {
            return new FixedProperty(pd, Boolean.FALSE);
        }
        if ("cmis:isLatestMajorVersion".equals(name)) {
            return new FixedProperty(pd, Boolean.FALSE);
        }
        if ("cmis:versionLabel".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:versionSeriesId".equals(name)) {
            return new FixedProperty(pd, (Serializable)((Object)doc.getId()));
        }
        if ("cmis:isVersionSeriesCheckedOut".equals(name)) {
            return new FixedProperty(pd, Boolean.FALSE);
        }
        if ("cmis:versionSeriesCheckedOutBy".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:versionSeriesCheckedOutId".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:checkinComment".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:contentStreamLength".equals(name)) {
            return new ContentStreamLengthProperty(pd, docHolder);
        }
        if ("cmis:contentStreamMimeType".equals(name)) {
            return new ContentStreamMimeTypeProperty(pd, docHolder);
        }
        if ("cmis:contentStreamFileName".equals(name)) {
            return new ContentStreamFileNameProperty(pd, docHolder);
        }
        if ("cmis:contentStreamId".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:parentId".equals(name)) {
            return new ParentIdProperty(pd, docHolder);
        }
        if ("cmis:path".equals(name)) {
            return new PathProperty(pd, docHolder);
        }
        if ("cmis:allowedChildObjectTypeIds".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:sourceId".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:targetId".equals(name)) {
            return new FixedProperty(pd, null);
        }
        if ("cmis:policyText".equals(name)) {
            return new FixedProperty(pd, null);
        }
        boolean readOnly = pd.getUpdatability() != Updatability.READ_WRITE;
        return new NuxeoProperty(pd, docHolder, name, readOnly);
    }

    protected static ContentStream getContentStream(DocumentModel doc) throws CMISRuntimeException {
        Blob blob;
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            throw new StreamNotSupportedException();
        }
        try {
            blob = blobHolder.getBlob();
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
        return blob == null ? null : new NuxeoContentStream(blob);
    }

    protected static void setContentStream(DocumentModel doc, ContentStream contentStream, boolean overwrite) throws IOException, ContentAlreadyExistsException, CMISRuntimeException {
        Blob blob;
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            throw new StreamNotSupportedException();
        }
        if (!overwrite) {
            try {
                blob = blobHolder.getBlob();
            }
            catch (ClientException e) {
                throw new CMISRuntimeException(e.toString(), (Throwable)e);
            }
            if (blob != null) {
                throw new ContentAlreadyExistsException();
            }
        }
        blob = contentStream == null ? null : new InputStreamBlob(contentStream.getStream(), contentStream.getMimeType(), null, contentStream.getFileName(), null);
        try {
            blobHolder.setBlob(blob);
        }
        catch (ClientException e) {
            throw new CMISRuntimeException(e.toString(), (Throwable)e);
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmis:objectId", "ecm:uuid");
        map.put("cmis:objectTypeId", "ecm:primaryType");
        map.put("cmis:parentId", "ecm:parentId");
        map.put("cmis:name", "ecm:name");
        map.put("cmis:createdBy", "dc:creator");
        map.put("cmis:creationDate", "dc:created");
        map.put("cmis:lastModifiedBy", "dc:contributors");
        map.put("cmis:lastModificationDate", "dc:modified");
        propertyNameToNXQL = Collections.unmodifiableMap(map);
    }

    protected static class NameProperty
    extends NuxeoPropertyBase {
        protected NameProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            String name = this.docHolder.getDocumentModel().getName();
            return name == null ? "" : name;
        }

        @Override
        public void setValue(Serializable value) {
            Serializable name = this.getValue();
            if (name.equals(value)) {
                return;
            }
            if (value == null || "".equals(value)) {
                throw new IllegalArgumentException("Illegal empty name");
            }
            DocumentModel doc = this.docHolder.getDocumentModel();
            if (doc.getId() == null) {
                doc.setPathInfo(doc.getPath().removeLastSegments(1).toString(), (String)((Object)value));
            } else {
                DocumentModel newDoc;
                CoreSession session = doc.getCoreSession();
                try {
                    newDoc = session.move(doc.getRef(), doc.getParentRef(), (String)((Object)value));
                }
                catch (ClientException e) {
                    throw new CMISRuntimeException(e.toString(), (Throwable)e);
                }
                this.docHolder.setDocumentModel(newDoc);
            }
        }
    }

    protected static class ContentStreamMimeTypeProperty
    extends NuxeoPropertyBase {
        protected ContentStreamMimeTypeProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            ContentStream cs = NuxeoProperty.getContentStream(this.docHolder.getDocumentModel());
            return cs == null ? null : cs.getMimeType();
        }
    }

    protected static class ContentStreamLengthProperty
    extends NuxeoPropertyBase {
        protected ContentStreamLengthProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            ContentStream cs = NuxeoProperty.getContentStream(this.docHolder.getDocumentModel());
            return cs == null ? null : Integer.valueOf((int)cs.getLength());
        }
    }

    protected static class ContentStreamFileNameProperty
    extends NuxeoPropertyBase {
        protected ContentStreamFileNameProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            ContentStream cs = NuxeoProperty.getContentStream(this.docHolder.getDocumentModel());
            return cs == null ? null : cs.getFileName();
        }

        @Override
        public void setValue(Serializable value) {
            Blob blob;
            BlobHolder blobHolder = (BlobHolder)this.docHolder.getDocumentModel().getAdapter(BlobHolder.class);
            if (blobHolder == null) {
                throw new StreamNotSupportedException();
            }
            try {
                blob = blobHolder.getBlob();
            }
            catch (ClientException e) {
                throw new CMISRuntimeException(e.toString(), (Throwable)e);
            }
            if (blob != null) {
                blob.setFilename((String)((Object)value));
            }
        }
    }

    protected static class LastModifiedByProperty
    extends NuxeoPropertyBase {
        protected LastModifiedByProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            DocumentModel doc = this.docHolder.getDocumentModel();
            try {
                String[] value = (String[])doc.getPropertyValue("dc:contributors");
                if (value == null || value.length == 0) {
                    return null;
                }
                return value[0];
            }
            catch (ClientException e) {
                throw new CMISRuntimeException(e.toString(), (Throwable)e);
            }
        }
    }

    protected static class ParentIdProperty
    extends NuxeoPropertyBase {
        protected ParentIdProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            DocumentModel doc = this.docHolder.getDocumentModel();
            if (doc.getName() == null) {
                return null;
            }
            DocumentRef parentRef = doc.getParentRef();
            if (parentRef instanceof IdRef) {
                return ((IdRef)parentRef).value;
            }
            try {
                return doc.getCoreSession().getDocument(parentRef).getId();
            }
            catch (ClientException e) {
                throw new CMISRuntimeException(e.toString(), (Throwable)e);
            }
        }
    }

    protected static class PathProperty
    extends NuxeoPropertyBase {
        protected PathProperty(PropertyDefinition propertyDefinition, DocumentModelHolder docHolder) {
            super(propertyDefinition, docHolder);
        }

        public Serializable getValue() {
            String path = this.docHolder.getDocumentModel().getPathAsString();
            return path == null ? "" : path;
        }
    }

    protected static class FixedProperty
    implements Property {
        protected final PropertyDefinition propertyDefinition;
        protected final Serializable value;

        protected FixedProperty(PropertyDefinition propertyDefinition, Serializable value) {
            this.propertyDefinition = propertyDefinition;
            this.value = value;
        }

        public PropertyDefinition getDefinition() {
            return this.propertyDefinition;
        }

        public Serializable getValue() {
            return this.value;
        }

        public void setValue(Serializable v) {
            if (this.value == null && v == null) {
                return;
            }
            if (this.value != null && this.value.equals(v)) {
                return;
            }
            throw new UnsupportedOperationException("Read-only property: " + this.propertyDefinition.getId());
        }
    }
}

