/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.ACLCapabilityType;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CapabilityACL;
import org.apache.chemistry.CapabilityChange;
import org.apache.chemistry.CapabilityJoin;
import org.apache.chemistry.CapabilityQuery;
import org.apache.chemistry.CapabilityRendition;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Paging;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.SPI;
import org.apache.chemistry.TypeManager;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.impl.simple.SimpleTypeManager;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoConnection;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoType;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Document;

public class NuxeoRepository
implements Repository,
RepositoryInfo,
RepositoryCapabilities {
    protected final String repositoryName;
    protected TypeManager typeManager;
    protected ObjectId rootFolderId;

    public NuxeoRepository(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    protected void initializeTypes() {
        SchemaManager schemaManager;
        if (this.typeManager != null) {
            return;
        }
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.toString(), e);
        }
        HashMap<String, List<String>> typesChildren = new HashMap<String, List<String>>();
        for (DocumentType dt : schemaManager.getDocumentTypes()) {
            Type st = dt.getSuperType();
            if (st == null) continue;
            String name = st.getName();
            LinkedList<String> siblings = (LinkedList<String>)typesChildren.get(name);
            if (siblings == null) {
                siblings = new LinkedList<String>();
                typesChildren.put(name, siblings);
            }
            siblings.add(dt.getName());
        }
        HashSet<String> done = new HashSet<String>();
        this.typeManager = new SimpleTypeManager();
        this.addTypeRecursively("Folder", typesChildren, done, schemaManager);
        this.addTypeRecursively("Document", typesChildren, done, schemaManager);
    }

    protected void addTypeRecursively(String name, Map<String, List<String>> typesChildren, Set<String> done, SchemaManager schemaManager) {
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        DocumentType dt = schemaManager.getDocumentType(name);
        this.typeManager.addType((org.apache.chemistry.Type)new NuxeoType(dt));
        List<String> children = typesChildren.get(name);
        if (children == null) {
            return;
        }
        for (String sub : children) {
            this.addTypeRecursively(sub, typesChildren, done, schemaManager);
        }
    }

    public String getId() {
        return this.repositoryName;
    }

    public String getName() {
        return this.repositoryName;
    }

    public String getRelationshipName() {
        return null;
    }

    public URI getThinClientURI() {
        return null;
    }

    public Connection getConnection(Map<String, Serializable> params) {
        return new NuxeoConnection(this, params);
    }

    public SPI getSPI(Map<String, Serializable> params) {
        return new NuxeoConnection(this, params);
    }

    public <T> T getExtension(Class<T> klass) {
        return null;
    }

    public RepositoryInfo getInfo() {
        return this;
    }

    public void addType(org.apache.chemistry.Type type) {
        throw new UnsupportedOperationException("Cannot add types");
    }

    public org.apache.chemistry.Type getType(String typeId) {
        this.initializeTypes();
        return this.typeManager.getType(typeId);
    }

    public PropertyDefinition getPropertyDefinition(String id) {
        this.initializeTypes();
        return this.typeManager.getPropertyDefinition(id);
    }

    public Collection<org.apache.chemistry.Type> getTypes() {
        this.initializeTypes();
        return this.typeManager.getTypes();
    }

    public Collection<org.apache.chemistry.Type> getTypeDescendants(String typeId) {
        this.initializeTypes();
        return this.typeManager.getTypeDescendants(typeId);
    }

    public ListPage<org.apache.chemistry.Type> getTypeChildren(String typeId, boolean includePropertyDefinitions, Paging paging) {
        this.initializeTypes();
        return this.typeManager.getTypeChildren(typeId, includePropertyDefinitions, paging);
    }

    public Collection<org.apache.chemistry.Type> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        this.initializeTypes();
        return this.typeManager.getTypeDescendants(typeId, depth, includePropertyDefinitions);
    }

    public String getDescription() {
        return "Repository " + this.repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId getRootFolderId() {
        if (this.rootFolderId == null) {
            Connection conn = this.getConnection(null);
            try {
                this.rootFolderId = new SimpleObjectId(conn.getRootFolder().getId());
            }
            finally {
                conn.close();
            }
        }
        return this.rootFolderId;
    }

    public String getVendorName() {
        return "Nuxeo";
    }

    public String getProductName() {
        return "Nuxeo Repository";
    }

    public String getProductVersion() {
        return "5.4.0-SNAPSHOT";
    }

    public String getVersionSupported() {
        return "1.0";
    }

    public Document getRepositorySpecificInformation() {
        return null;
    }

    public RepositoryCapabilities getCapabilities() {
        return this;
    }

    public Set<BaseType> getChangeLogBaseTypes() {
        HashSet<BaseType> changeLogBaseTypes = new HashSet<BaseType>();
        changeLogBaseTypes.add(BaseType.DOCUMENT);
        changeLogBaseTypes.add(BaseType.FOLDER);
        changeLogBaseTypes.add(BaseType.RELATIONSHIP);
        changeLogBaseTypes.add(BaseType.POLICY);
        return changeLogBaseTypes;
    }

    public boolean isChangeLogIncomplete() {
        return false;
    }

    public String getLatestChangeLogToken() {
        return "";
    }

    public ACLCapabilityType getACLCapabilityType() {
        return null;
    }

    public Collection<RepositoryEntry> getRelatedRepositories() {
        return Collections.emptySet();
    }

    public boolean hasMultifiling() {
        return false;
    }

    public boolean hasUnfiling() {
        return false;
    }

    public boolean hasVersionSpecificFiling() {
        return false;
    }

    public boolean isPWCUpdatable() {
        return true;
    }

    public boolean isPWCSearchable() {
        return true;
    }

    public boolean isAllVersionsSearchable() {
        return true;
    }

    public boolean hasGetDescendants() {
        return true;
    }

    public boolean hasGetFolderTree() {
        return true;
    }

    public boolean isContentStreamUpdatableAnytime() {
        return true;
    }

    public CapabilityJoin getJoinCapability() {
        return CapabilityJoin.INNER_AND_OUTER;
    }

    public CapabilityQuery getQueryCapability() {
        return CapabilityQuery.BOTH_COMBINED;
    }

    public CapabilityRendition getRenditionCapability() {
        return CapabilityRendition.NONE;
    }

    public CapabilityChange getChangeCapability() {
        return CapabilityChange.NONE;
    }

    public CapabilityACL getACLCapability() {
        return CapabilityACL.NONE;
    }
}

