/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.impl;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.impl.simple.SimplePropertyDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

public class NuxeoType
implements org.apache.chemistry.Type {
    private static final Log log = LogFactory.getLog(NuxeoType.class);
    public static final String NX_DC_CREATED = "dc:created";
    public static final String NX_DC_CREATOR = "dc:creator";
    public static final String NX_DC_MODIFIED = "dc:modified";
    private final DocumentType documentType;
    private final String id;
    private final String parentId;
    private final Map<String, PropertyDefinition> propertyDefinitions;
    private final ContentStreamPresence contentStreamAllowed;

    public NuxeoType(DocumentType documentType) {
        this.documentType = documentType;
        this.id = NuxeoType.mappedId(documentType.getName());
        DocumentType superType = (DocumentType)documentType.getSuperType();
        if (this.id.equals(BaseType.DOCUMENT.getId()) || this.id.equals(BaseType.FOLDER.getId()) || superType == null) {
            this.parentId = null;
        } else {
            String pid = NuxeoType.mappedId(superType.getName());
            if (pid.equals(BaseType.DOCUMENT.getId()) && documentType.isFolder()) {
                pid = BaseType.FOLDER.getId();
            }
            this.parentId = pid;
        }
        LinkedHashMap<String, PropertyDefinition> map = new LinkedHashMap<String, PropertyDefinition>();
        for (PropertyDefinition def : org.apache.chemistry.impl.simple.SimpleType.getBasePropertyDefinitions((BaseType)this.getBaseType())) {
            map.put(def.getId(), def);
        }
        for (Schema schema : documentType.getSchemas()) {
            for (Field field : schema.getFields()) {
                boolean multiValued;
                String prefixedName = field.getName().getPrefixedName();
                boolean inherited = false;
                List choices = null;
                boolean openChoice = false;
                boolean required = false;
                Serializable defaultValue = null;
                boolean queryable = true;
                boolean orderable = true;
                PropertyType cmisType = PropertyType.STRING;
                Type fieldType = field.getType();
                if (fieldType.isComplexType()) {
                    log.debug((Object)("Chemistry: ignoring complex type: " + schema.getName() + '/' + field.getName()));
                    continue;
                }
                if (fieldType.isListType()) {
                    Type listFieldType = ((ListType)fieldType).getFieldType();
                    if (!listFieldType.isSimpleType()) {
                        log.debug((Object)("Chemistry: ignoring complex list: " + schema.getName() + '/' + field.getName()));
                        continue;
                    }
                    multiValued = true;
                    cmisType = this.getPropertType((SimpleType)listFieldType);
                } else {
                    multiValued = false;
                    cmisType = this.getPropertType((SimpleType)fieldType);
                }
                if (NX_DC_CREATED.equals(prefixedName) || NX_DC_CREATOR.equals(prefixedName) || NX_DC_MODIFIED.equals(prefixedName)) continue;
                String name = prefixedName;
                SimplePropertyDefinition def = new SimplePropertyDefinition(name, "def:nx:" + name, null, name, name, "", inherited, cmisType, multiValued, choices, openChoice, required, defaultValue, Updatability.READ_WRITE, queryable, orderable, 0, null, null, -1, null);
                if (map.containsKey(name)) {
                    throw new RuntimeException("Property already defined for name: " + name);
                }
                map.put(name, (PropertyDefinition)def);
            }
        }
        ContentStreamPresence contentStreamPresence = this.contentStreamAllowed = BaseType.DOCUMENT.equals((Object)this.getBaseType()) && this.supportsBlobHolder(documentType) ? ContentStreamPresence.ALLOWED : ContentStreamPresence.NOT_ALLOWED;
        if (this.contentStreamAllowed == ContentStreamPresence.NOT_ALLOWED) {
            map.remove("cmis:contentStreamLength");
            map.remove("cmis:contentStreamFileName");
            map.remove("cmis:contentStreamMimeType");
            map.remove("cmis:contentStreamId");
        }
        this.propertyDefinitions = map;
    }

    protected boolean supportsBlobHolder(DocumentType documentType) {
        DocumentModelImpl doc = new DocumentModelImpl(null, documentType.getName(), null, new Path("/"), null, null, null, documentType.getSchemaNames(), documentType.getFacets(), null, "default");
        return doc.getAdapter(BlobHolder.class) != null;
    }

    protected String getNuxeoTypeName() {
        return this.documentType.getName();
    }

    protected static String mappedId(String id) {
        if (id.equals("Document")) {
            return BaseType.DOCUMENT.getId();
        }
        if (id.equals("Folder")) {
            return BaseType.FOLDER.getId();
        }
        return id;
    }

    protected PropertyType getPropertType(SimpleType type) {
        SimpleType primitive = type.getPrimitiveType();
        if (primitive == StringType.INSTANCE) {
            return PropertyType.STRING;
        }
        if (primitive == BooleanType.INSTANCE) {
            return PropertyType.BOOLEAN;
        }
        if (primitive == DateType.INSTANCE) {
            return PropertyType.DATETIME;
        }
        if (primitive == LongType.INSTANCE) {
            return PropertyType.INTEGER;
        }
        if (primitive == DoubleType.INSTANCE) {
            return PropertyType.DECIMAL;
        }
        return PropertyType.STRING;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return this.id;
    }

    public URI getLocalNamespace() {
        Namespace ns = this.documentType.getNamespace();
        try {
            return ns == null ? null : new URI(ns.uri);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid URI: " + ns.uri + " for type: " + this.getId()), (Throwable)e);
            return null;
        }
    }

    public String getQueryName() {
        return this.getId();
    }

    public String getDisplayName() {
        return this.getId();
    }

    public String getParentId() {
        return this.parentId;
    }

    public BaseType getBaseType() {
        if (this.documentType.isFolder()) {
            return BaseType.FOLDER;
        }
        return BaseType.DOCUMENT;
    }

    public String getDescription() {
        return this.id;
    }

    public boolean isCreatable() {
        return true;
    }

    public boolean isQueryable() {
        return true;
    }

    public boolean isControllablePolicy() {
        return true;
    }

    public boolean isControllableACL() {
        return true;
    }

    public boolean isFulltextIndexed() {
        return true;
    }

    public boolean isIncludedInSuperTypeQuery() {
        return true;
    }

    public boolean isFileable() {
        return true;
    }

    public boolean isVersionable() {
        return BaseType.DOCUMENT.equals((Object)this.getBaseType());
    }

    public ContentStreamPresence getContentStreamAllowed() {
        return this.contentStreamAllowed;
    }

    public String[] getAllowedSourceTypes() {
        return null;
    }

    public String[] getAllowedTargetTypes() {
        return null;
    }

    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.propertyDefinitions.values());
    }

    public PropertyDefinition getPropertyDefinition(String name) {
        return this.propertyDefinitions.get(name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.id + ')';
    }
}

