/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.perspectives;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.relations.DefaultPredicate;
import org.nuxeo.theme.relations.DyadicRelation;
import org.nuxeo.theme.relations.Predicate;
import org.nuxeo.theme.relations.Relation;
import org.nuxeo.theme.relations.RelationStorage;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

public class PerspectiveManager
implements Registrable {
    private static final String PREDICATE_NAME = "_ is visible in perspective _";
    private static final Predicate predicate = new DefaultPredicate("_ is visible in perspective _");
    private final RelationStorage relationStorage = Manager.getRelationStorage();

    public static PerspectiveType getPerspectiveByName(String name) {
        return (PerspectiveType)Manager.getTypeRegistry().lookup(TypeFamily.PERSPECTIVE, name);
    }

    public static boolean hasPerspective(String perspectiveName) {
        List<String> perspectiveNames = Manager.getTypeRegistry().getTypeNames(TypeFamily.PERSPECTIVE);
        if (perspectiveNames == null) {
            return false;
        }
        return perspectiveNames.contains(perspectiveName);
    }

    public boolean isVisibleInPerspective(Element element, PerspectiveType perspective) {
        if (this.relationStorage.search(predicate, element, null).isEmpty()) {
            return true;
        }
        return !this.relationStorage.search(predicate, element, perspective).isEmpty();
    }

    public static void setVisibleInPerspective(Element element, PerspectiveType perspective) {
        Manager.getRelationStorage().add(new DyadicRelation(predicate, element, perspective));
    }

    public void setVisibleInAllPerspectives(Element element) {
        this.removeRelationsFrom(element);
        for (PerspectiveType perspective : PerspectiveManager.listPerspectives()) {
            Manager.getRelationStorage().add(new DyadicRelation(predicate, element, perspective));
        }
    }

    public void setVisibleInPerspectives(Element element, List<String> perspectiveNames) {
        this.removeRelationsFrom(element);
        for (String perspectiveName : perspectiveNames) {
            PerspectiveType perspective = PerspectiveManager.getPerspectiveByName(perspectiveName);
            Manager.getRelationStorage().add(new DyadicRelation(predicate, element, perspective));
        }
    }

    public void setAlwaysVisible(Element element) {
        this.removeRelationsFrom(element);
    }

    public boolean isAlwaysVisible(Element element) {
        return this.getPerspectivesFor(element).isEmpty();
    }

    public List<PerspectiveType> getPerspectivesFor(Element element) {
        ArrayList<PerspectiveType> perspectives = new ArrayList<PerspectiveType>();
        for (Relation relation : this.relationStorage.search(predicate, element, null)) {
            PerspectiveType perspective = (PerspectiveType)relation.getRelate(2);
            perspectives.add(perspective);
        }
        return perspectives;
    }

    @Override
    public void clear() {
    }

    public static List<PerspectiveType> listPerspectives() {
        ArrayList<PerspectiveType> perspectives = new ArrayList<PerspectiveType>();
        for (Type perspective : Manager.getTypeRegistry().getTypes(TypeFamily.PERSPECTIVE)) {
            perspectives.add((PerspectiveType)perspective);
        }
        return perspectives;
    }

    private void removeRelationsFrom(Element element) {
        for (Relation relation : this.relationStorage.search(predicate, element, null)) {
            this.relationStorage.remove(relation);
        }
    }
}

