/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.presets;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.presets.PaletteParser;

public class PhotoshopPaletteParser
extends PaletteParser {
    private static final Log log = LogFactory.getLog(PhotoshopPaletteParser.class);
    private static final int RGB = 0;
    private static final int HSB = 1;
    private static final int CMYK = 2;
    private static final int LAB = 7;
    private static final int GRAYSCALE = 8;
    private static final int WIDE_CMYK = 9;

    public static boolean checkSanity(byte[] bytes) {
        return true;
    }

    public static Map<String, String> parse(byte[] bytes) {
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(is);
        char[] words = new char[bytes.length];
        int size = 0;
        try {
            while (true) {
                words[size] = dis.readChar();
                ++size;
            }
        }
        catch (Exception e) {
            try {
                is.close();
                dis.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            int offset = 1;
            int version = words[0] & 0xFFFF;
            int nc = words[1] & 0xFFFF;
            if (version == 1 && size > nc * 5 + 2) {
                version = words[(offset += nc * 5 + 2) - 1] & 0xFFFF;
                nc = words[offset] & 0xFFFF;
            }
            if (version == 1) {
                log.debug((Object)"Found ACO v1 color file (Photoshop < 7.0)");
            } else if (version == 2) {
                log.debug((Object)"Found ACO v2 color file (Photoshop >= 7.0)");
            } else {
                log.error((Object)("Unknown ACO file version: " + version));
                return entries;
            }
            log.debug((Object)("Found " + nc + " colors."));
            int counter = 1;
            for (int j = 0; j < nc; ++j) {
                String value = null;
                int colorSpace = words[offset + 1] & 0xFF;
                int w = words[offset + 2] & 0xFFFF;
                int x = words[offset + 3] & 0xFFFF;
                int y = words[offset + 4] & 0xFFFF;
                int z = words[offset + 5] & 0xFFFF;
                if (colorSpace == 0) {
                    value = PhotoshopPaletteParser.rgbToHex(w / 256, x / 256, y / 256);
                } else if (colorSpace == 1) {
                    float hue = (float)w / 65535.0f;
                    float saturation = (float)x / 65535.0f;
                    float brightness = (float)y / 65535.0f;
                    Color color = Color.getHSBColor(hue, saturation, brightness);
                    value = PhotoshopPaletteParser.rgbToHex(color.getRed(), color.getGreen(), color.getBlue());
                } else if (colorSpace == 2) {
                    float cyan = 1.0f - (float)w / 65535.0f;
                    float magenta = 1.0f - (float)x / 65535.0f;
                    float yellow = 1.0f - (float)y / 65535.0f;
                    float black = 1.0f - (float)z / 65535.0f;
                    log.warn((Object)"Unsupported color space: CMYK");
                } else if (colorSpace == 8) {
                    int gray = (int)((float)w * 256.0f / 10000.0f);
                    value = PhotoshopPaletteParser.rgbToHex(gray, gray, gray);
                } else if (colorSpace == 7) {
                    float l = (float)w / 100.0f;
                    float a = (float)x / 100.0f;
                    float b = (float)y / 100.0f;
                    log.warn((Object)"Unsupported color space: CIE Lab");
                } else if (colorSpace == 9) {
                    float cyan = (float)w / 10000.0f;
                    float magenta = (float)x / 10000.0f;
                    float yellow = (float)y / 10000.0f;
                    float black = (float)z / 10000.0f;
                    log.warn((Object)"Unsupported color space: Wide CMYK");
                } else {
                    log.warn((Object)("Unknown color space: " + colorSpace));
                }
                String name = "";
                if (version == 1) {
                    name = String.format("Color %s", counter);
                } else if (version == 2) {
                    int len = (words[offset + 7] & 0xFFFF) - 1;
                    name = String.copyValueOf(words, offset + 8, len);
                    offset += len + 3;
                    String n = name;
                    int c = 2;
                    while (entries.containsKey(n)) {
                        n = String.format("%s %s", name, c);
                        ++c;
                    }
                    name = n;
                }
                if (value != null) {
                    entries.put(name, value);
                }
                offset += 5;
                ++counter;
            }
            return entries;
        }
    }
}

