/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.presets;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

@XObject(value="preset")
public class PresetType
implements Type {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@value")
    protected String value;
    @XNode(value="@group")
    protected String group;
    @XNode(value="@category")
    protected String category = "";

    public PresetType() {
    }

    public PresetType(String name, String value, String group, String category) {
        this.name = name;
        this.value = value;
        this.group = group;
        this.category = category;
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.PRESET;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        if (this.group != null && !"".equals(this.group)) {
            return String.format("%s (%s)", this.name, this.group);
        }
        return this.name;
    }

    public String getEffectiveName() {
        return this.getTypeName();
    }

    public String getValue() {
        return this.value;
    }

    public String getCategory() {
        return this.category;
    }

    public String getGroup() {
        return this.group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

