/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

@XObject(value="theme")
public class ThemeDescriptor
implements Type {
    protected RuntimeContext ctx;
    private boolean configured = false;
    private boolean customized = false;
    private Date lastSaved;
    private Date lastLoaded;
    private boolean loadingFailed = false;
    private String name;
    private URL url;
    private List<String> templateEngines;
    @XNode(value="src")
    public String src = "";

    public void setContext(RuntimeContext ctx) {
        this.ctx = ctx;
    }

    public RuntimeContext getContext() {
        return this.ctx;
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.THEME;
    }

    @Override
    public String getTypeName() {
        return this.src;
    }

    private URL getUrl() {
        if (this.url != null) {
            return this.url;
        }
        try {
            this.url = new URL(this.src);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.url;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public boolean isCustom() {
        return !this.isXmlConfigured();
    }

    public boolean isLoaded() {
        return this.lastLoaded != null;
    }

    public boolean isXmlConfigured() {
        return this.configured;
    }

    public boolean isWritable() {
        if (this.getUrl() == null) {
            return false;
        }
        String protocol = this.getUrl().getProtocol();
        return protocol.equals("ftp") || protocol.equals("file");
    }

    public boolean isLoadable() {
        return !this.isLoaded();
    }

    public boolean isReloadable() {
        return this.isLoaded() && !this.isCustomized();
    }

    public boolean isSaveable() {
        return this.isWritable() && (this.isLoaded() || this.isCustom()) && !this.isCustomized();
    }

    public boolean isExportable() {
        return (this.isCustom() || this.isLoaded()) && !this.isCustomized();
    }

    public boolean isRepairable() {
        return (this.isCustom() || this.isLoaded()) && !this.isCustomized();
    }

    public boolean isLoadingFailed() {
        return this.loadingFailed;
    }

    public void setLoadingFailed(boolean loadingFailed) {
        this.loadingFailed = loadingFailed;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public void setCustomized(boolean customized) {
        this.customized = customized;
    }

    public Date getLastLoaded() {
        return this.lastLoaded;
    }

    public void setLastLoaded(Date lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public Date getLastSaved() {
        return this.lastSaved;
    }

    public void setLastSaved(Date lastSaved) {
        this.lastSaved = lastSaved;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getTemplateEngines() {
        return this.templateEngines;
    }

    public void setTemplateEngines(List<String> templateEngines) {
        this.templateEngines = templateEngines;
    }

    public boolean isCompatibleWith(String templateEngine) {
        return this.templateEngines == null || this.templateEngines.isEmpty() || this.templateEngines.contains(templateEngine);
    }
}

