/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.views.AbstractView;
import org.nuxeo.theme.views.ViewType;

public class TemplateView
extends AbstractView {
    private static final Log log = LogFactory.getLog(TemplateView.class);

    @Override
    public String render(RenderingInfo info) {
        ViewType viewType = this.getViewType();
        String template = viewType.getTemplate();
        return this.getTemplateContent(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTemplateContent(String template) {
        String result = "";
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
            if (is == null) {
                String warTemplate = "nuxeo.war/" + template;
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(warTemplate);
            }
            if (is == null) {
                log.warn((Object)("Template file not found: " + template));
                return result.trim();
            }
            Reader in = null;
            try {
                int ch;
                in = new BufferedReader(new InputStreamReader(is));
                StringBuilder rendered = new StringBuilder();
                while ((ch = in.read()) > -1) {
                    rendered.append((char)ch);
                }
                result = rendered.toString();
                return result.trim();
            }
            catch (IOException e) {
                e.printStackTrace();
                return result.trim();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return result.trim();
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }
}

