/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.schema.NXSchema;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.IdGenerator;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.SimpleDataSource;
import org.nuxeo.ecm.directory.sql.SimpleIdGenerator;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.ConfigurationException;
import org.nuxeo.ecm.directory.sql.repository.FieldMapper;
import org.nuxeo.ecm.directory.sql.repository.Table;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;

public class SQLDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(SQLDirectory.class);
    private final SQLDirectoryDescriptor config;
    private boolean managedSQLSession;
    private DataSource dataSource;
    private final SimpleIdGenerator idGenerator;
    private List<Session> sessions = new ArrayList<Session>();
    private final Table table;
    private final Schema schema;
    private final Map<String, Field> schemaFieldMap;
    private final List<String> storedFieldNames;
    private final Dialect dialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDirectory(SQLDirectoryDescriptor config) throws ClientException {
        this.config = config;
        this.addReferences(config.getInverseReferences());
        this.addReferences(config.getTableReferences());
        this.cache.setMaxSize(config.getCacheMaxSize());
        this.cache.setTimeout(config.getCacheTimeout());
        this.dialect = this.buildDialect();
        if (config.initDependencies != null) {
            RuntimeService runtime = Framework.getRuntime();
            DirectoryServiceImpl directoryService = (DirectoryServiceImpl)runtime.getComponent(DirectoryService.NAME);
            for (String dependency : config.initDependencies) {
                log.debug((Object)("initializing dependencies first: " + dependency));
                Directory dir = directoryService.getDirectory(dependency);
                dir.getName();
            }
        }
        this.table = new Table(config.tableName);
        this.schema = NXSchema.getSchemaManager().getSchema(config.schemaName);
        if (this.schema == null) {
            throw new DirectoryException("schema not found: " + config.schemaName);
        }
        this.schemaFieldMap = new LinkedHashMap<String, Field>();
        this.storedFieldNames = new LinkedList<String>();
        boolean hasPrimary = false;
        for (Field f : this.schema.getFields()) {
            Object defaultValue;
            int fieldSqlType;
            String fieldName = f.getName().toString();
            this.schemaFieldMap.put(fieldName, f);
            if (this.isReference(fieldName)) continue;
            this.storedFieldNames.add(fieldName);
            try {
                fieldSqlType = FieldMapper.getSqlField(f.getType().getName());
            }
            catch (DirectoryException e) {
                log.warn((Object)String.format("Field %s of type %s in SQLDirectory %s is not supported and thus ignored", fieldName, f.getType().getName(), config.getName()));
                continue;
            }
            Column column = new Column(fieldName, fieldSqlType, null);
            if (fieldName.equals(config.getIdField())) {
                column.setPrimary(true);
                hasPrimary = true;
            }
            if ((defaultValue = f.getDefaultValue()) != null) {
                column.setDefaultValue(defaultValue.toString());
            }
            try {
                this.table.addColumn(column);
            }
            catch (ConfigurationException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        if (!hasPrimary) {
            throw new DirectoryException(String.format("Directory '%s' id field '%s' is not present in schema '%s'", this.getName(), this.getIdField(), this.getSchema()));
        }
        Connection sqlConnection = this.getConnection();
        try {
            SQLHelper helper = new SQLHelper(sqlConnection, this.dialect, this.table, config.dataFileName, config.createTablePolicy);
            helper.setupTable();
            this.idGenerator = config.autoincrementIdField ? new SimpleIdGenerator(sqlConnection, this.table, this.dialect, config.getIdField()) : null;
            try {
                if (config.dataSourceName == null) {
                    sqlConnection.commit();
                }
            }
            catch (SQLException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        finally {
            try {
                sqlConnection.close();
            }
            catch (Exception e) {
                throw new DirectoryException((Throwable)e);
            }
        }
    }

    public SQLDirectoryDescriptor getConfig() {
        return this.config;
    }

    public DataSource getDataSource() throws DirectoryException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            if (this.config.dataSourceName != null) {
                this.managedSQLSession = true;
                this.dataSource = DataSourceHelper.getDataSource((String)this.config.dataSourceName);
            } else {
                this.managedSQLSession = false;
                this.dataSource = new SimpleDataSource(this.config.dbUrl, this.config.dbDriver, this.config.dbUser, this.config.dbPassword);
            }
            log.trace((Object)("found datasource: " + this.dataSource));
            return this.dataSource;
        }
        catch (Exception e) {
            log.error((Object)"dataSource lookup failed", (Throwable)e);
            throw new DirectoryException("dataSource lookup failed", (Throwable)e);
        }
    }

    private Connection getConnection() throws DirectoryException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new DirectoryException("could not obtain a connection", (Throwable)e);
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getSchema() {
        return this.config.getSchemaName();
    }

    public String getParentDirectory() {
        return this.config.getParentDirectory();
    }

    public String getIdField() {
        return this.config.getIdField();
    }

    public String getPasswordField() {
        return this.config.getPasswordField();
    }

    public Session getSession() throws DirectoryException {
        SQLSession session = new SQLSession(this, this.config, this.idGenerator, this.managedSQLSession);
        this.sessions.add((Session)session);
        return session;
    }

    void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public void shutdown() {
        try {
            for (Object session : this.sessions.toArray()) {
                ((Session)session).close();
            }
            this.sessions = null;
        }
        catch (ClientException e) {
            log.error((Object)"exception during shutdown", (Throwable)e);
        }
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public List<String> getStoredFieldNames() {
        return this.storedFieldNames;
    }

    public Table getTable() {
        return this.table;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    private Dialect buildDialect() throws DirectoryException {
        int dbmajor;
        String dbname;
        String dialectName = this.config.getDialectName();
        if (dialectName != null) {
            return DialectFactory.buildDialect((String)dialectName);
        }
        Connection connection = this.getConnection();
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            dbname = metadata.getDatabaseProductName();
            dbmajor = metadata.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new DirectoryException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new DirectoryException((Throwable)e);
                }
            }
        }
        return DialectFactory.determineDialect((String)dbname, (int)dbmajor);
    }
}

