/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Collection;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.IdGenerator;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;

public class SQLDirectoryProxy
implements Directory {
    private final SQLDirectoryDescriptor descriptor;
    private SQLDirectory directory;

    public SQLDirectoryProxy(SQLDirectoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public SQLDirectory getDirectory() throws DirectoryException {
        if (this.directory == null) {
            try {
                this.directory = new SQLDirectory(this.descriptor);
            }
            catch (ClientException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return this.directory;
    }

    public IdGenerator getIdGenerator() throws DirectoryException {
        return this.getDirectory().getIdGenerator();
    }

    public String getName() throws DirectoryException {
        return this.getDirectory().getName();
    }

    public String getSchema() throws DirectoryException {
        return this.getDirectory().getSchema();
    }

    public String getParentDirectory() throws DirectoryException {
        return this.getDirectory().getParentDirectory();
    }

    public String getIdField() throws DirectoryException {
        return this.getDirectory().getIdField();
    }

    public String getPasswordField() throws DirectoryException {
        return this.getDirectory().getPasswordField();
    }

    public Session getSession() throws DirectoryException {
        return this.getDirectory().getSession();
    }

    public void shutdown() throws DirectoryException {
        if (this.directory != null) {
            this.getDirectory().shutdown();
        }
    }

    public Reference getReference(String referenceFieldName) throws DirectoryException {
        return this.getDirectory().getReference(referenceFieldName);
    }

    public Collection<Reference> getReferences() throws DirectoryException {
        return this.getDirectory().getReferences();
    }

    public SQLDirectoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DirectoryCache getCache() throws DirectoryException {
        return this.getDirectory().getCache();
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
    }
}

