/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.ecm.platform.url.codec.descriptor.DocumentViewCodecDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentViewCodecService
extends DefaultComponent
implements DocumentViewCodecManager {
    private static final long serialVersionUID = -4521897334653742494L;
    private static final Log log = LogFactory.getLog(DocumentViewCodecService.class);
    public static final String NAME = DocumentViewCodecService.class.getName();
    public static final String CODECS_EXTENSION_POINT = "codecs";
    protected String defaultCodecName;
    protected final Map<String, DocumentViewCodecDescriptor> descriptors = new HashMap<String, DocumentViewCodecDescriptor>();
    protected final Map<String, DocumentViewCodec> codecs = new HashMap<String, DocumentViewCodec>();

    public void deactivate(ComponentContext context) {
        this.descriptors.clear();
        this.codecs.clear();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DocumentViewCodecManager.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CODECS_EXTENSION_POINT.equals(extensionPoint)) {
            DocumentViewCodecDescriptor codecDesc = (DocumentViewCodecDescriptor)contribution;
            String codecName = codecDesc.getName();
            this.descriptors.put(codecName, codecDesc);
            if (codecDesc.getDefaultCodec()) {
                this.defaultCodecName = codecName;
            }
            log.debug((Object)("Added URL codec: " + codecName));
            this.codecs.remove(codecName);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CODECS_EXTENSION_POINT.equals(extensionPoint)) {
            DocumentViewCodecDescriptor codecDesc = (DocumentViewCodecDescriptor)contribution;
            String codecName = codecDesc.getName();
            this.descriptors.remove(codecName);
            this.codecs.remove(codecName);
            log.debug((Object)("Removed URL codec: " + codecName));
        }
    }

    public List<String> getDocumentViewCodecDescriptorNames() {
        ArrayList<String> lst = new ArrayList<String>();
        for (String k : this.descriptors.keySet()) {
            if (!this.descriptors.get(k).getEnabled()) continue;
            lst.add(k);
        }
        return lst;
    }

    public String getDefaultCodecName() {
        List<String> descs;
        String name = this.defaultCodecName;
        if (name == null && (descs = this.getDocumentViewCodecDescriptorNames()) != null && !descs.isEmpty()) {
            Collections.sort(descs);
            name = descs.get(0);
        }
        return name;
    }

    public DocumentViewCodec getCodec() {
        return this.getCodec(this.defaultCodecName);
    }

    public DocumentViewCodec getCodec(String codecName) {
        DocumentViewCodec codec = this.codecs.get(codecName);
        if (codec == null) {
            DocumentViewCodecDescriptor desc = this.descriptors.get(codecName);
            if (desc == null) {
                throw new IllegalArgumentException("Unknown codec " + codecName);
            }
            String className = desc.getClassName();
            if (className == null) {
                throw new IllegalArgumentException("Invalid class for codec " + codecName);
            }
            try {
                codec = (DocumentViewCodec)DocumentViewCodecManager.class.getClassLoader().loadClass(className).newInstance();
            }
            catch (Exception e) {
                String msg = String.format("Caught error when instantiating codec %s with class %s ", codecName, className);
                throw new IllegalArgumentException(msg, e);
            }
            String prefix = desc.getPrefix();
            if (prefix != null) {
                codec.setPrefix(prefix);
            }
            this.codecs.put(codecName, codec);
        }
        return codec;
    }

    public String getUrlFromDocumentView(DocumentView docView, boolean needBaseUrl, String baseUrl) {
        String url;
        block1: {
            String defaultCodecName = this.getDefaultCodecName();
            url = this.getUrlFromDocumentView(defaultCodecName, docView, needBaseUrl, baseUrl);
            if (url != null) break block1;
            for (String codecName : this.descriptors.keySet()) {
                if (!codecName.equals(defaultCodecName) && (url = this.getUrlFromDocumentView(codecName, docView, needBaseUrl, baseUrl)) != null) break;
            }
        }
        return url;
    }

    public String getUrlFromDocumentView(String codecName, DocumentView docView, boolean needBaseUrl, String baseUrl) {
        DocumentViewCodec codec = this.getCodec(codecName);
        if (codec.handleDocumentView(docView)) {
            String partialUrl = codec.getUrlFromDocumentView(docView);
            if (needBaseUrl && baseUrl != null) {
                return baseUrl + partialUrl;
            }
            return partialUrl;
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url, boolean hasBaseUrl, String baseUrl) {
        DocumentView docView;
        block1: {
            String defaultCodecName = this.getDefaultCodecName();
            docView = this.getDocumentViewFromUrl(defaultCodecName, url, hasBaseUrl, baseUrl);
            if (docView != null) break block1;
            for (String codecName : this.descriptors.keySet()) {
                if (!codecName.equals(defaultCodecName) && (docView = this.getDocumentViewFromUrl(codecName, url, hasBaseUrl, baseUrl)) != null) break;
            }
        }
        return docView;
    }

    public DocumentView getDocumentViewFromUrl(String codecName, String url, boolean hasBaseUrl, String baseUrl) {
        if (hasBaseUrl && baseUrl != null && url.startsWith(baseUrl)) {
            url = url.substring(baseUrl.length());
        }
        DocumentViewCodec codec = this.getCodec(codecName);
        DocumentView docView = null;
        if (codec.handleUrl(url)) {
            docView = codec.getDocumentViewFromUrl(url);
        }
        return docView;
    }
}

