/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import java.util.HashSet;
import java.util.Set;

public class AggCountDistinct
implements AggregateFactory {
    private static AggCountDistinct singleton = new AggCountDistinct();

    public static AggregateFactory get() {
        return singleton;
    }

    private AggCountDistinct() {
    }

    public Aggregator create() {
        return new AggCountDistinctWorker();
    }

    static class AccCountDistinct
    implements Accumulator {
        private Set rows = new HashSet();

        public void accumulate(Binding binding) {
            this.rows.add(binding);
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.rows.size());
        }
    }

    static class AggCountDistinctWorker
    extends AggregatorBase {
        public String toString() {
            return "count(distinct *)";
        }

        public String toPrefixString() {
            return "(count distinct)";
        }

        protected Accumulator createAccumulator() {
            return new AccCountDistinct();
        }
    }
}

