/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BuilderNode {
    public static Node buildNode(Item item) {
        if (!item.isNode()) {
            BuilderBase.broken((ItemLocation)item, "Not a node", item);
        }
        return item.getNode();
    }

    public static Var buildVar(Item item) {
        if (!item.isNode() || !Var.isVar(item.getNode())) {
            BuilderBase.broken((ItemLocation)item, "Not a variable", item);
        }
        return Var.alloc(item.getNode());
    }

    public static List buildVarList(Item item) {
        BuilderBase.checkList(item);
        ItemList list = item.getList();
        return BuilderNode.buildVarList(list);
    }

    public static List buildVarList(ItemList list) {
        ArrayList<Var> vars = new ArrayList<Var>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Item x = (Item)iter.next();
            Var v = BuilderNode.buildVar(x);
            vars.add(v);
        }
        return vars;
    }

    public static String buildSymbol(Item item) {
        if (!item.isSymbol()) {
            BuilderBase.broken((ItemLocation)item, "Not a symbol", item);
        }
        return item.getSymbol();
    }

    public static List buildVars(ItemList list, int start) {
        ArrayList<Var> x = new ArrayList<Var>();
        for (int i = start; i < list.size(); ++i) {
            Item item = list.get(i);
            Var var = BuilderNode.buildVar(item);
            x.add(Var.alloc(item.getNode()));
        }
        return x;
    }

    private static BigInteger buildInteger(Item item, boolean allowDefault) {
        NodeValue nv;
        Node node;
        if (allowDefault && item.equals(Item.defaultItem)) {
            return null;
        }
        if (!item.isNode()) {
            BuilderBase.broken(item, "Not an integer: " + item);
        }
        if (!(node = item.getNode()).isLiteral()) {
            BuilderBase.broken(item, "Not an integer: " + item);
        }
        if (!(nv = NodeValue.makeNode(node)).isInteger()) {
            BuilderBase.broken(item, "Not an integer: " + item);
        }
        return nv.getInteger();
    }

    public static int buildInt(Item item) {
        BigInteger i = BuilderNode.buildInteger(item, false);
        return i.intValue();
    }

    public static int buildInt(Item item, int dft) {
        BigInteger i = BuilderNode.buildInteger(item, true);
        if (i == null) {
            return dft;
        }
        return i.intValue();
    }

    public static int buildInt(ItemList list, int idx) {
        return BuilderNode.buildInt(list.get(idx));
    }

    public static int buildInt(ItemList list, int idx, int dft) {
        return BuilderNode.buildInt(list.get(idx), dft);
    }
}

