/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webengine.sites.JsonAdapter;
import org.nuxeo.webengine.sites.utils.ContextTransmitterHelper;

public class SiteUtils {
    private SiteUtils() {
    }

    public static Response getLogoResponse(DocumentModel document) throws Exception {
        Blob blob = SiteUtils.getBlob(document, "webc:logo");
        if (blob != null) {
            return Response.ok().entity((Object)blob).type(blob.getMimeType()).build();
        }
        return null;
    }

    public static DocumentModel getFirstWebSiteParent(CoreSession session, DocumentModel doc) throws Exception {
        List parents = session.getParentDocuments(doc.getRef());
        Collections.reverse(parents);
        for (DocumentModel currentDocumentModel : parents) {
            if (!currentDocumentModel.hasFacet("WebView") || !currentDocumentModel.hasSchema("webcontainer") || !Boolean.TRUE.equals(currentDocumentModel.getPropertyValue("webc:isWebContainer"))) continue;
            return currentDocumentModel;
        }
        return null;
    }

    public static int getNumberCommentsForPage(CoreSession session, DocumentModel page) throws Exception {
        List comments = SiteUtils.getCommentManager().getComments(page);
        if (SiteUtils.isCurrentModerated(session, page)) {
            ArrayList<DocumentModel> publishedComments = new ArrayList<DocumentModel>();
            for (DocumentModel comment : comments) {
                if (!"moderation_published".equals(comment.getCurrentLifeCycleState())) continue;
                publishedComments.add(comment);
            }
            return publishedComments.size();
        }
        return comments.size();
    }

    public static String getUserDetails(String username) throws Exception {
        UserManager userManager = SiteUtils.getUserManager();
        NuxeoPrincipal principal = userManager.getPrincipal(username);
        if (principal == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)principal.getFirstName()) && StringUtils.isEmpty((String)principal.getLastName())) {
            return principal.toString();
        }
        return principal.getFirstName() + " " + principal.getLastName();
    }

    public static StringBuilder getWebContainersPath() {
        WebContext context = WebEngine.getActiveContext();
        return new StringBuilder(context.getRoot().getPath());
    }

    public static String getPagePath(DocumentModel ws, DocumentModel documentModel) {
        StringBuilder path = new StringBuilder(SiteUtils.getWebContainersPath()).append('/');
        if (ws.hasSchema("webcontainer")) {
            try {
                path.append(ws.getPropertyValue("webc:url")).append("/");
            }
            catch (Exception e) {
                path.append(ws.getPath().segment(ws.getPath().segmentCount() - 1)).append('/');
            }
        } else {
            path.append(ws.getPath().segment(ws.getPath().segmentCount() - 1)).append('/');
        }
        path.append(JsonAdapter.getRelativePath(ws, documentModel));
        return path.toString();
    }

    public static DocumentModel createDocument(HttpServletRequest request, CoreSession session, String parentPath, String documentType) throws Exception {
        String title = request.getParameter("title");
        String pageName = request.getParameter("pageName");
        String description = request.getParameter("description");
        Boolean isRichtext = Boolean.parseBoolean(request.getParameter("isRichtext"));
        String wikitextEditor = request.getParameter("wikitextEditor");
        String richtextEditor = request.getParameter("richtextEditor");
        String pushToMenu = request.getParameter("pushToMenu");
        String theName = (StringUtils.isEmpty((String)pageName) ? title : pageName).trim();
        theName = IdUtils.generateId((String)theName);
        DocumentModel documentModel = session.createDocumentModel(parentPath, theName, documentType);
        documentModel.setPropertyValue("dc:title", (Serializable)((Object)title));
        documentModel.setPropertyValue("dc:description", (Serializable)((Object)description));
        documentModel.setPropertyValue("webp:isRichtext", (Serializable)isRichtext);
        if (isRichtext.booleanValue()) {
            documentModel.setPropertyValue("webp:content", (Serializable)((Object)richtextEditor));
        } else {
            documentModel.setPropertyValue("webp:content", (Serializable)((Object)wikitextEditor));
        }
        documentModel.setPropertyValue("webp:pushtomenu", (Serializable)Boolean.valueOf(pushToMenu));
        ContextTransmitterHelper.feedContext(documentModel);
        documentModel = session.createDocument(documentModel);
        session.save();
        return documentModel;
    }

    public static ArrayList<String> getUsersWithPermission(CoreSession session, DocumentModel doc, Set<String> permissions) throws Exception {
        DocumentModel parentWebSite = SiteUtils.getFirstWebSiteParent(session, doc);
        if (parentWebSite != null) {
            String[] moderators = parentWebSite.getACP().listUsernamesForAnyPermission(permissions);
            return new ArrayList<String>(Arrays.asList(moderators));
        }
        return new ArrayList<String>();
    }

    public static boolean isCurrentModerated(CoreSession session, DocumentModel doc) throws Exception {
        return SiteUtils.getModerationType(session, doc).equals("apriori");
    }

    public static boolean isModeratedByCurrentUser(CoreSession session, DocumentModel doc) throws Exception {
        return session.hasPermission(doc.getRef(), "Moderate");
    }

    public static CommentManager getCommentManager() throws Exception {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager == null) {
            throw new Exception("Unable to get commentManager");
        }
        return commentManager;
    }

    public static UserManager getUserManager() throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager == null) {
            throw new Exception("unable to get userManager");
        }
        return userManager;
    }

    public static DocumentModel getPageForComment(DocumentModel comment) throws Exception {
        DocumentModel page;
        List list = SiteUtils.getCommentManager().getDocumentsForComment(comment);
        if (!list.isEmpty() && !"deleted".equals((page = (DocumentModel)list.get(0)).getCurrentLifeCycleState())) {
            return page;
        }
        return null;
    }

    public static ArrayList<String> getModerators(CoreSession session, DocumentModel doc) throws Exception {
        HashSet<String> moderatePermissions = new HashSet<String>();
        moderatePermissions.addAll(Arrays.asList(session.getPermissionsToCheck("Moderate")));
        return SiteUtils.getUsersWithPermission(session, doc, moderatePermissions);
    }

    public static String getModerationType(CoreSession session, DocumentModel doc) throws Exception {
        DocumentModel parentWebSite = SiteUtils.getFirstWebSiteParent(session, doc);
        if (parentWebSite != null) {
            return SiteUtils.getString(parentWebSite, "webcontainer:moderationType", "aposteriori");
        }
        return "aposteriori";
    }

    public static String getString(DocumentModel d, String xpath, String defaultValue) {
        try {
            return SiteUtils.getString(d, xpath);
        }
        catch (ClientException e) {
            return defaultValue;
        }
    }

    public static String getString(DocumentModel d, String xpath) throws ClientException {
        Serializable v;
        Property p = d.getProperty(xpath);
        if (p != null && (v = p.getValue()) != null) {
            return v.toString();
        }
        return "";
    }

    public static GregorianCalendar getGregorianCalendar(DocumentModel d, String xpath) throws ClientException {
        Serializable v;
        Property p = d.getProperty(xpath);
        if (p != null && (v = p.getValue()) != null) {
            return (GregorianCalendar)v;
        }
        return null;
    }

    public static Long getNumber(DocumentModel d, String xpath) throws ClientException {
        Serializable v;
        Property p = d.getProperty(xpath);
        if (p != null && (v = p.getValue()) != null && v instanceof Long) {
            return (Long)v;
        }
        return new Long(0L);
    }

    public static Long getNumber(DocumentModel d, String xpath, Long defaultValue) {
        try {
            return SiteUtils.getNumber(d, xpath);
        }
        catch (ClientException ce) {
            return defaultValue;
        }
    }

    public static Blob getBlob(DocumentModel d, String xpath) throws ClientException {
        Serializable v;
        Property p = d.getProperty(xpath);
        if (p != null && (v = p.getValue()) != null) {
            return (Blob)v;
        }
        return null;
    }

    public static boolean getBoolean(DocumentModel d, String xpath, boolean defaultValue) {
        try {
            return SiteUtils.getBoolean(d, xpath);
        }
        catch (ClientException e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(DocumentModel d, String xpath) throws ClientException {
        Serializable v;
        Property p = d.getProperty(xpath);
        if (p != null && (v = p.getValue()) != null) {
            return (Boolean)v;
        }
        throw new ClientException("value is null");
    }

    public static String getFistNWordsFromString(String string, int n) {
        String[] result = string.split(" ", n + 1);
        StringBuffer firstNwords = new StringBuffer();
        for (int i = 0; i < (n <= result.length ? n : result.length); ++i) {
            firstNwords.append(result[i]);
            firstNwords.append(" ");
        }
        return new String(firstNwords);
    }

    public static Map<String, Object> getRssFeedArguments(WebContext ctx, String key) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("title", ctx.getMessage(key));
        root.put("link", " ");
        root.put("description", " ");
        return root;
    }
}

