/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

public class DocumentModelWriter
extends AbstractDocumentModelWriter {
    public DocumentModelWriter(CoreSession session, String parentPath) {
        super(session, parentPath);
    }

    public DocumentModelWriter(CoreSession session, String parentPath, int saveInterval) {
        super(session, parentPath, saveInterval);
    }

    @Override
    public DocumentTranslationMap write(ExportedDocument xdoc) throws IOException {
        if (xdoc.getDocument() == null) {
            return null;
        }
        Path path = xdoc.getPath();
        path = this.root.append(path);
        try {
            return this.doWrite(xdoc, path);
        }
        catch (ClientException e) {
            IOException ioe = new IOException("Failed to import document in repository: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            e.printStackTrace();
            return null;
        }
    }

    private DocumentTranslationMap doWrite(ExportedDocument xdoc, Path targetPath) throws ClientException {
        DocumentModel previousDoc = null;
        PathRef pathRef = new PathRef(targetPath.toString());
        try {
            if (this.session.exists((DocumentRef)pathRef)) {
                previousDoc = this.session.getDocument((DocumentRef)pathRef);
            }
        }
        catch (ClientException ce) {
            previousDoc = null;
        }
        DocumentModel doc = previousDoc == null ? this.createDocument(xdoc, targetPath) : this.updateDocument(xdoc, previousDoc);
        DocumentLocation source = xdoc.getSourceLocation();
        DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(source.getServerName(), doc.getRepositoryName());
        map.put(source.getDocRef(), doc.getRef());
        return map;
    }
}

