/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.descriptors.FieldDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;

@XObject(value="widget")
public class WidgetDescriptor
implements WidgetDefinition {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WidgetDescriptor.class);
    @XNode(value="@name")
    String name;
    @XNode(value="@type")
    String type;
    @XNodeList(value="fields/field", type=FieldDescriptor[].class, componentType=FieldDescriptor.class)
    FieldDefinition[] fields = new FieldDefinition[0];
    @XNodeMap(value="widgetModes/mode", key="@value", type=HashMap.class, componentType=String.class)
    Map<String, String> modes = new HashMap<String, String>();
    @XNodeMap(value="labels/label", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> labels = new HashMap<String, String>();
    @XNodeMap(value="helpLabels/label", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> helpLabels = new HashMap<String, String>();
    @XNode(value="translated")
    boolean translated = true;
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();
    @XNodeMap(value="properties", key="@widgetMode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> widgetModeProperties = new HashMap<String, PropertiesDescriptor>();
    @XNodeList(value="subWidgets/widget", type=WidgetDescriptor[].class, componentType=WidgetDescriptor.class)
    WidgetDefinition[] subWidgets = new WidgetDefinition[0];

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public FieldDefinition[] getFieldDefinitions() {
        return this.fields;
    }

    public String getMode(String layoutMode) {
        String mode = this.modes.get(layoutMode);
        if (mode == null) {
            mode = this.modes.get("any");
        }
        return mode;
    }

    public String getRequired(String layoutMode, String mode) {
        String res = "false";
        Map<String, Serializable> props = this.getProperties(layoutMode, mode);
        if (props != null && props.containsKey("required")) {
            Serializable value = props.get("required");
            if (value instanceof String) {
                res = (String)((Object)value);
            } else {
                log.error((Object)String.format("Invalid property \"%s\" on widget %s: %s", "required", value, this.name));
            }
        }
        return res;
    }

    public String getLabel(String mode) {
        String label = this.labels.get(mode);
        if (label == null) {
            label = this.labels.get("any");
        }
        return label;
    }

    public String getHelpLabel(String mode) {
        String label = this.helpLabels.get(mode);
        if (label == null) {
            label = this.helpLabels.get("any");
        }
        return label;
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public static Map<String, Serializable> getProperties(Map<String, PropertiesDescriptor> map, String mode) {
        if (map == null) {
            return null;
        }
        PropertiesDescriptor defaultProps = map.get("any");
        PropertiesDescriptor props = map.get(mode);
        if (defaultProps == null && props == null) {
            return null;
        }
        if (defaultProps == null) {
            return props.getProperties();
        }
        if (props == null) {
            return defaultProps.getProperties();
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>(defaultProps.getProperties());
        res.putAll(props.getProperties());
        return res;
    }

    public Map<String, Serializable> getProperties(String layoutMode, String mode) {
        Map<String, Serializable> modeProps = WidgetDescriptor.getProperties(this.properties, layoutMode);
        Map<String, Serializable> widgetModeProps = WidgetDescriptor.getProperties(this.widgetModeProperties, mode);
        if (modeProps == null && widgetModeProps == null) {
            return null;
        }
        if (widgetModeProps == null) {
            return modeProps;
        }
        if (modeProps == null) {
            return widgetModeProps;
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>(modeProps);
        res.putAll(widgetModeProps);
        return res;
    }

    public WidgetDefinition[] getSubWidgetDefinitions() {
        return this.subWidgets;
    }
}

