/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LayoutTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class DocumentLayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(DocumentLayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute template;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "mode", "value", "template"};

    public DocumentLayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
        this.template = this.getAttribute("template");
        this.vars = this.tag.getAttributes().getAll();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        Object document = this.value.getObject(ctx, DocumentModel.class);
        if (!(document instanceof DocumentModel)) {
            return;
        }
        TypeInfo typeInfo = (TypeInfo)((DocumentModel)document).getAdapter(TypeInfo.class);
        if (typeInfo == null) {
            return;
        }
        String modeValue = this.mode.getValue(ctx);
        String[] layoutNames = typeInfo.getLayouts(modeValue);
        if (layoutNames == null || layoutNames.length == 0) {
            return;
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        TagAttribute modeAttr = helper.createAttribute("mode", (Serializable)((Object)modeValue));
        ArrayList<LayoutTagHandler> handlers = new ArrayList<LayoutTagHandler>();
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        for (String layoutName : layoutNames) {
            TagAttributes attributes = FaceletHandlerHelper.getTagAttributes(helper.createAttribute("name", (Serializable)((Object)layoutName)), modeAttr, this.value);
            if (this.template != null) {
                attributes = FaceletHandlerHelper.addTagAttribute(attributes, this.template);
            }
            List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
            for (TagAttribute var : this.vars) {
                String localName = var.getLocalName();
                if (reservedVars.contains(localName)) continue;
                attributes = FaceletHandlerHelper.addTagAttribute(attributes, var);
            }
            TagConfig tagConfig = TagConfigFactory.createTagConfig(this.config, attributes, leaf);
            handlers.add(new LayoutTagHandler(tagConfig));
        }
        CompositeFaceletHandler composite = new CompositeFaceletHandler(handlers.toArray(new FaceletHandler[0]));
        composite.apply(ctx, parent);
    }
}

