/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import com.sun.facelets.tag.jsf.ConvertHandler;
import com.sun.facelets.tag.jsf.ConverterConfig;
import com.sun.facelets.tag.jsf.ValidateHandler;
import com.sun.facelets.tag.jsf.ValidatorConfig;
import com.sun.facelets.tag.jsf.html.HtmlComponentHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;

public final class FaceletHandlerHelper {
    private static final Log log = LogFactory.getLog(FaceletHandlerHelper.class);
    public static final String LAYOUT_ID_PREFIX = "nxl_";
    public static final String WIDGET_ID_PREFIX = "nxw_";
    public static final String MESSAGE_ID_SUFFIX = "_message";
    final FaceletContext context;
    final TagConfig tagConfig;

    public FaceletHandlerHelper(FaceletContext context, TagConfig tagConfig) {
        this.context = context;
        this.tagConfig = tagConfig;
    }

    public String generateUniqueId() {
        TagAttribute idAttr = this.tagConfig.getTag().getAttributes().get("id");
        String id = idAttr != null ? idAttr.getValue(this.context) : this.context.getFacesContext().getViewRoot().createUniqueId();
        return this.generateUniqueId(id);
    }

    public String generateUniqueId(String base) {
        return this.context.generateUniqueId(base);
    }

    public String generateValidIdString(String base) {
        if (base == null) {
            throw new IllegalArgumentException(base);
        }
        int n = base.length();
        if (n < 1) {
            throw new IllegalArgumentException(base);
        }
        StringBuilder newId = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = base.charAt(i);
            if (i == 0) {
                if (!Character.isLetter(c) && c != '_') {
                    newId.append("_");
                    continue;
                }
                newId.append(c);
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_') {
                newId.append("_");
                continue;
            }
            newId.append(c);
        }
        return newId.toString();
    }

    public String generateWidgetId(String widgetName) {
        return this.generateUniqueId(this.generateValidIdString(WIDGET_ID_PREFIX + widgetName));
    }

    public String generateLayoutId(String layoutName) {
        return this.generateUniqueId(this.generateValidIdString(LAYOUT_ID_PREFIX + layoutName));
    }

    public String generateMessageId(String widgetName) {
        return this.generateUniqueId(this.generateValidIdString(WIDGET_ID_PREFIX + widgetName + MESSAGE_ID_SUFFIX));
    }

    public TagAttribute createIdAttribute(String base) {
        String value = this.generateUniqueId(base);
        return new TagAttribute(this.tagConfig.getTag().getLocation(), "", "id", "id", value);
    }

    public TagAttribute createAttribute(String name, Serializable value) {
        if (value == null || value instanceof String) {
            return new TagAttribute(this.tagConfig.getTag().getLocation(), "", name, name, (String)((Object)value));
        }
        return null;
    }

    public static TagAttributes getTagAttributes(TagAttribute ... attributes) {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        return new TagAttributes(attributes);
    }

    public static TagAttributes getTagAttributes(List<TagAttribute> attributes) {
        return FaceletHandlerHelper.getTagAttributes(attributes.toArray(new TagAttribute[0]));
    }

    public static TagAttributes addTagAttribute(TagAttributes orig, TagAttribute newAttr) {
        if (orig == null) {
            return new TagAttributes(new TagAttribute[]{newAttr});
        }
        ArrayList<TagAttribute> allAttrs = new ArrayList<TagAttribute>(Arrays.asList(orig.getAll()));
        allAttrs.add(newAttr);
        return FaceletHandlerHelper.getTagAttributes(allAttrs);
    }

    public TagAttributes copyTagAttributes(String id, String ... names) {
        ArrayList<TagAttribute> list = new ArrayList<TagAttribute>();
        list.add(this.createIdAttribute(id));
        for (String name : names) {
            TagAttribute attr;
            if ("id".equals(name) || (attr = this.tagConfig.getTag().getAttributes().get(name)) == null) continue;
            list.add(attr);
        }
        TagAttribute[] attrs = list.toArray(new TagAttribute[list.size()]);
        return new TagAttributes(attrs);
    }

    public TagAttributes getTagAttributes(String id, Widget widget) {
        Map properties;
        ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
        attrs.add(this.createAttribute("id", (Serializable)((Object)id)));
        FieldDefinition[] fields = widget.getFieldDefinitions();
        if (fields != null && fields.length > 0) {
            FieldDefinition field = fields[0];
            TagAttribute valueAttr = this.createAttribute("value", (Serializable)((Object)ValueExpressionHelper.createExpressionString(widget.getValueName(), field)));
            attrs.add(valueAttr);
        }
        if ((properties = widget.getProperties()) != null) {
            for (Map.Entry property : properties.entrySet()) {
                TagAttribute attr = this.createAttribute((String)property.getKey(), (Serializable)property.getValue());
                if (attr == null) continue;
                attrs.add(attr);
            }
        }
        return FaceletHandlerHelper.getTagAttributes(attrs);
    }

    public ComponentHandler getHtmlComponentHandler(TagAttributes attributes, FaceletHandler nextHandler, String componentType, String rendererType) {
        ComponentConfig config = TagConfigFactory.createComponentConfig(this.tagConfig, attributes, nextHandler, componentType, rendererType);
        return new HtmlComponentHandler(config);
    }

    public ConvertHandler getConvertHandler(TagAttributes attributes, FaceletHandler nextHandler, String converterId) {
        ConverterConfig config = TagConfigFactory.createConverterConfig(this.tagConfig, attributes, nextHandler, converterId);
        return new ConvertHandler(config);
    }

    public ValidateHandler getValidateHandler(TagAttributes attributes, FaceletHandler nextHandler, String validatorId) {
        ValidatorConfig config = TagConfigFactory.createValidatorConfig(this.tagConfig, attributes, nextHandler, validatorId);
        return new ValidateHandler(config);
    }

    public ComponentHandler getMessageComponentHandler(String id, String forId, String styleClass) {
        TagAttribute forAttr = this.createAttribute("for", (Serializable)((Object)forId));
        TagAttribute idAttr = this.createAttribute("id", (Serializable)((Object)id));
        if (styleClass == null) {
            styleClass = "errorMessage";
        }
        TagAttribute styleAttr = this.createAttribute("styleClass", (Serializable)((Object)styleClass));
        TagAttributes attributes = FaceletHandlerHelper.getTagAttributes(forAttr, idAttr, styleAttr);
        ComponentConfig config = TagConfigFactory.createComponentConfig(this.tagConfig, attributes, new LeafFaceletHandler(), "javax.faces.HtmlMessage", null);
        return new ComponentHandler(config);
    }
}

