/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;

public class LayoutRowTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutRowTagHandler.class);
    protected final TagConfig config;

    public LayoutRowTagHandler(TagConfig config) {
        super(config);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        Layout layout = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        String layoutVariableName = RenderVariables.layoutVariables.layout.name();
        TagAttribute layoutAttribute = helper.createAttribute(layoutVariableName, (Serializable)((Object)String.format("#{%s}", layoutVariableName)));
        if (layoutAttribute != null) {
            layout = (Layout)layoutAttribute.getObject(ctx, Layout.class);
        }
        if (layout == null) {
            log.error((Object)("Could not resolve layout " + layoutAttribute));
            return;
        }
        LayoutRow[] rows = layout.getRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        VariableMapper orig = ctx.getVariableMapper();
        ctx.setVariableMapper((VariableMapper)new VariableMapperWrapper(orig));
        try {
            int rowCounter = 0;
            for (LayoutRow row : rows) {
                VariableMapper vm = ctx.getVariableMapper();
                ValueExpression rowVe = ctx.getExpressionFactory().createValueExpression((Object)row, LayoutRow.class);
                vm.setVariable(RenderVariables.rowVariables.layoutRow.name(), rowVe);
                vm.setVariable(RenderVariables.columnVariables.layoutColumn.name(), rowVe);
                ValueExpression rowIndexVe = ctx.getExpressionFactory().createValueExpression((Object)rowCounter, Integer.class);
                vm.setVariable(RenderVariables.rowVariables.layoutRowIndex.name(), rowIndexVe);
                vm.setVariable(RenderVariables.columnVariables.layoutColumnIndex.name(), rowIndexVe);
                this.nextHandler.apply(ctx, parent);
                ++rowCounter;
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

