/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.service;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.LayoutException;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebLayoutManagerImpl
extends DefaultComponent
implements WebLayoutManager {
    public static final ComponentName NAME = new ComponentName(WebLayoutManagerImpl.class.getName());
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    private static final long serialVersionUID = -4778456059717447736L;
    private static final Log log = LogFactory.getLog(WebLayoutManagerImpl.class);
    private final Map<String, WidgetType> widgetTypeRegistry = new HashMap<String, WidgetType>();
    private final Map<String, LayoutDefinition> layoutRegistry = new HashMap<String, LayoutDefinition>();
    private final Map<String, WidgetDefinition> widgetRegistry = new HashMap<String, WidgetDefinition>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.registerWidgetType(contribution);
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.registerLayout(contribution);
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.registerWidget(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.unregisterWidgetType(contribution);
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.unregisterLayout(contribution);
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.unregisterWidget(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(WebLayoutManager.class)) {
            return (T)this;
        }
        return null;
    }

    private void registerWidgetType(Object contribution) {
        Class<?> widgetTypeClass;
        String className;
        WidgetTypeDescriptor desc = (WidgetTypeDescriptor)contribution;
        String name = desc.getName();
        if (this.widgetTypeRegistry.containsKey(name)) {
            log.warn((Object)String.format("Overriding definition for widget type %s", name));
            this.widgetTypeRegistry.remove(name);
        }
        if ((className = desc.getHandlerClassName()) == null) {
            log.error((Object)("Handler class missing for widget type " + name));
            return;
        }
        try {
            widgetTypeClass = WebLayoutManagerImpl.class.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            log.error((Object)"Caught error when instantiating widget type handler", (Throwable)e);
            return;
        }
        WidgetTypeImpl widgetType = new WidgetTypeImpl(name, widgetTypeClass, desc.getProperties());
        this.widgetTypeRegistry.put(name, (WidgetType)widgetType);
        log.info((Object)("Registered widget type: " + name));
    }

    private void unregisterWidgetType(Object contribution) {
        WidgetTypeDescriptor desc = (WidgetTypeDescriptor)contribution;
        String name = desc.getName();
        if (this.widgetTypeRegistry.containsKey(name)) {
            this.widgetTypeRegistry.remove(name);
            log.debug((Object)("Unregistered widget type: " + name));
        }
    }

    private void registerLayout(Object contribution) {
        LayoutDefinition layoutDef = (LayoutDefinition)contribution;
        String name = layoutDef.getName();
        if (this.layoutRegistry.containsKey(name)) {
            this.layoutRegistry.remove(name);
        }
        this.layoutRegistry.put(name, layoutDef);
        log.info((Object)("Registered layout: " + name));
    }

    private void unregisterLayout(Object contribution) {
        LayoutDefinition layoutDef = (LayoutDefinition)contribution;
        String name = layoutDef.getName();
        if (this.layoutRegistry.containsKey(name)) {
            this.layoutRegistry.remove(name);
            log.debug((Object)("Unregistered layout: " + name));
        }
    }

    private void registerWidget(Object contribution) {
        WidgetDefinition widgetDef = (WidgetDefinition)contribution;
        String name = widgetDef.getName();
        if (this.widgetRegistry.containsKey(name)) {
            this.widgetRegistry.remove(name);
        }
        this.widgetRegistry.put(name, widgetDef);
        log.info((Object)("Registered widget: " + name));
    }

    private void unregisterWidget(Object contribution) {
        WidgetDefinition widgetDef = (WidgetDefinition)contribution;
        String name = widgetDef.getName();
        if (this.widgetRegistry.containsKey(name)) {
            this.widgetRegistry.remove(name);
            log.debug((Object)("Unregistered widget: " + name));
        }
    }

    public WidgetType getWidgetType(String typeName) {
        return this.widgetTypeRegistry.get(typeName);
    }

    public LayoutDefinition getLayoutDefinition(String layoutName) {
        return this.layoutRegistry.get(layoutName);
    }

    public WidgetDefinition getWidgetDefinition(String widgetName) {
        return this.widgetRegistry.get(widgetName);
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(String typeName) throws WidgetException {
        WidgetTypeHandler handler;
        WidgetType type = this.getWidgetType(typeName);
        if (type == null) {
            return null;
        }
        try {
            handler = (WidgetTypeHandler)type.getWidgetTypeClass().newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Caught error when instanciating widget type handler", (Throwable)e);
            return null;
        }
        handler.setProperties(type.getProperties());
        return handler;
    }

    private static Object evaluateExpression(FaceletContext context, String expression) {
        String strValue;
        if (expression == null) {
            return null;
        }
        if (context == null) {
            return expression;
        }
        ExpressionFactory eFactory = context.getExpressionFactory();
        ELContext elContext = context.getFacesContext().getELContext();
        ValueExpression expr = eFactory.createValueExpression((ELContext)context, expression, Object.class);
        Object value = expr.getValue(elContext);
        if (value != null && value instanceof String && (strValue = (String)value).contains("#{") && strValue.indexOf("#{") < strValue.indexOf(125)) {
            expr = eFactory.createValueExpression((ELContext)context, strValue, Object.class);
            value = expr.getValue(elContext);
        }
        return value;
    }

    private static Boolean getBooleanValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        log.error((Object)("Could not get boolean value for " + value));
        return false;
    }

    private static String getStringValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        log.error((Object)("Could not get string value for " + value));
        return null;
    }

    private static String getModeFromLayoutMode(FaceletContext context, WidgetDefinition wDef, String layoutMode) {
        String wMode = WebLayoutManagerImpl.getStringValue(context, wDef.getMode(layoutMode));
        if (wMode == null) {
            wMode = "create".equals(layoutMode) || "edit".equals(layoutMode) || "search".equals(layoutMode) || "bulkEdit".equals(layoutMode) ? "edit" : "view";
        }
        return wMode;
    }

    private Widget getWidget(FaceletContext context, LayoutDefinition lDef, WidgetDefinition wDef, String layoutMode, String valueName, int level) {
        VariableMapper orig = null;
        if (context != null) {
            orig = context.getVariableMapper();
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            context.setVariableMapper((VariableMapper)vm);
            ExpressionFactory eFactory = context.getExpressionFactory();
            ValueExpression modeVe = eFactory.createValueExpression((Object)layoutMode, String.class);
            vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        }
        String wMode = WebLayoutManagerImpl.getModeFromLayoutMode(context, wDef, layoutMode);
        if (context != null) {
            context.setVariableMapper(orig);
        }
        if ("hidden".equals(wMode)) {
            return null;
        }
        ArrayList<Widget> subWidgets = new ArrayList<Widget>();
        for (WidgetDefinition swDef : wDef.getSubWidgetDefinitions()) {
            Widget subWidget = this.getWidget(context, lDef, swDef, wMode, valueName, level + 1);
            if (subWidget == null) continue;
            subWidgets.add(subWidget);
        }
        boolean required = WebLayoutManagerImpl.getBooleanValue(context, wDef.getRequired(layoutMode, wMode));
        WidgetImpl widget = new WidgetImpl(lDef.getName(), wDef.getName(), wMode, wDef.getType(), valueName, wDef.getFieldDefinitions(), wDef.getLabel(layoutMode), wDef.getHelpLabel(layoutMode), wDef.isTranslated(), wDef.getProperties(layoutMode, wMode), required, subWidgets.toArray(new Widget[0]), level);
        return widget;
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName) throws LayoutException {
        LayoutDefinition lDef = this.getLayoutDefinition(layoutName);
        if (lDef == null) {
            log.debug((Object)String.format("Layout %s not found", layoutName));
            return null;
        }
        if (ctx == null) {
            log.warn((Object)"Layout creation computed in a null facelet context: expressions found in the layout definition will not be evaluated");
        }
        LayoutRowDefinition[] rowsDef = lDef.getRows();
        ArrayList<LayoutRowImpl> rows = new ArrayList<LayoutRowImpl>();
        for (LayoutRowDefinition rowDef : rowsDef) {
            boolean emptyRow = true;
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            for (String widgetName : rowDef.getWidgets()) {
                if (widgetName == null || widgetName.length() == 0) {
                    widgets.add(null);
                    continue;
                }
                WidgetDefinition wDef = lDef.getWidgetDefinition(widgetName);
                if (wDef == null) {
                    wDef = this.getWidgetDefinition(widgetName);
                }
                if (wDef == null) {
                    log.error((Object)String.format("Widget %s not found in layout %s", widgetName, layoutName));
                    widgets.add(null);
                    continue;
                }
                Widget widget = this.getWidget(ctx, lDef, wDef, mode, valueName, 0);
                if (widget != null) {
                    emptyRow = false;
                }
                widgets.add(widget);
            }
            if (emptyRow) continue;
            rows.add(new LayoutRowImpl(widgets, rowDef.getProperties(mode)));
        }
        int columns = lDef.getColumns();
        LayoutImpl layout = new LayoutImpl(lDef.getName(), mode, lDef.getTemplate(mode), rows, columns, lDef.getProperties(mode));
        return layout;
    }

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig config, Widget widget) {
        String widgetTypeName = widget.getType();
        WidgetTypeHandler handler = this.getWidgetTypeHandler(widgetTypeName);
        if (handler != null) {
            FaceletHandler[] subHandlers = null;
            Widget[] subWidgets = widget.getSubWidgets();
            if (subWidgets != null) {
                ArrayList<FaceletHandler> subHandlersList = new ArrayList<FaceletHandler>();
                for (Widget subWidget : subWidgets) {
                    subHandlersList.add(this.getFaceletHandler(ctx, config, subWidget));
                }
                subHandlers = subHandlersList.toArray(new FaceletHandler[0]);
            }
            FaceletHandler fHandler = handler.getFaceletHandler(ctx, config, widget, subHandlers);
            return fHandler;
        }
        log.error((Object)("No widget handler found for type " + widgetTypeName));
        return null;
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, Map<String, Serializable> properties, Widget[] subWidgets) {
        Serializable requiredProp = properties.get("required");
        boolean required = false;
        if (requiredProp != null) {
            if (requiredProp instanceof String) {
                required = WebLayoutManagerImpl.getBooleanValue(ctx, (String)((Object)requiredProp));
            } else {
                log.error((Object)String.format("Invalid property \"%s\" on widget: %s", "required", requiredProp));
            }
        }
        WidgetImpl widget = new WidgetImpl("layout", "widget", mode, type, valueName, null, null, null, required, properties, required, subWidgets, 0);
        return widget;
    }
}

