/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.opensocial.gadgets.service.ExternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class GadgetServiceImpl
extends DefaultComponent
implements GadgetService {
    private static final String URL_SEPARATOR = "/";
    private static final String GWTGADGETS_PORT = "gwtgadgets.port";
    private static final String GWTGADGETS_HOST = "gwtgadgets.host";
    private static final String GWTGADGETS_PATH = "gwtgadgets.path";
    private static final String GADGET_XP = "gadget";
    private static final HashMap<String, GadgetDeclaration> internalGadgets = new HashMap();
    private static final String GADGET_DIRECTORY = "external gadget list";
    private static final Log log = LogFactory.getLog(GadgetServiceImpl.class);
    private static final String GADGET_DIR_SCHEMA = "externalgadget";
    private static final String EXTERNAL_PROP_NAME = "label";
    private static final String EXTERNAL_PROP_CATEGORY = "category";
    private static final String EXTERNAL_PROP_ENABLED = "enabled";
    private static final String EXTERNAL_PROP_URL = "url";
    private static final String EXTERNAL_PROP_ICON_URL = "iconUrl";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GADGET_XP.equals(extensionPoint)) {
            InternalGadgetDescriptor gadget = (InternalGadgetDescriptor)contribution;
            gadget.setComponentName(contributor.getName());
            this.registerNewGadget(gadget);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GADGET_XP.equals(extensionPoint)) {
            InternalGadgetDescriptor gadget = (InternalGadgetDescriptor)contribution;
            this.unregisterNewGadget(gadget, contributor);
        }
    }

    public void registerNewGadget(GadgetDeclaration gadget) {
        if (internalGadgets.containsKey(gadget.getName())) {
            internalGadgets.remove(gadget.getName());
        }
        if (!gadget.getDisabled()) {
            internalGadgets.put(gadget.getName(), gadget);
        }
    }

    private void unregisterNewGadget(GadgetDeclaration gadget, ComponentInstance contributor) {
        if (internalGadgets.containsKey(gadget.getName())) {
            internalGadgets.remove(gadget.getName());
        }
    }

    @Override
    public GadgetDeclaration getGadget(String name) {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        if (gadgets.containsKey(name)) {
            return gadgets.get(name);
        }
        return null;
    }

    @Override
    public InputStream getGadgetResource(String gadgetName, String resourcePath) throws IOException {
        return this.getGadget(gadgetName).getResourceAsStream(resourcePath);
    }

    @Override
    public List<GadgetDeclaration> getGadgetList() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        ArrayList<GadgetDeclaration> gadgetList = new ArrayList<GadgetDeclaration>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            gadgetList.add(gadget);
        }
        return gadgetList;
    }

    @Override
    public List<GadgetDeclaration> getGadgetList(String category) {
        return this.getGadgetList();
    }

    public HashMap<String, ArrayList<String>> getGadgetNameByCategory() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        HashMap<String, ArrayList<String>> listByCategories = new HashMap<String, ArrayList<String>>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            ArrayList<String> listGadget;
            if (listByCategories.containsKey(gadget.getCategory())) {
                listGadget = listByCategories.get(gadget.getCategory());
                listGadget.add(gadget.getName());
                continue;
            }
            if (gadget.getCategory() == null) continue;
            listGadget = new ArrayList();
            listGadget.add(gadget.getName());
            listByCategories.put(gadget.getCategory(), listGadget);
        }
        return listByCategories;
    }

    @Override
    public URL getGadgetDefinition(String gadgetName) {
        GadgetDeclaration gadget = this.getGadget(gadgetName);
        if (gadget == null) {
            log.warn((Object)("Unable to find gadget" + gadgetName));
            return null;
        }
        try {
            return gadget.getGadgetDefinition();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getGadgetCategory() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        ArrayList<String> categories = new ArrayList<String>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            if (categories.contains(gadget.getCategory())) continue;
            categories.add(gadget.getCategory());
        }
        return categories;
    }

    @Override
    public String getIconUrl(String gadgetName) {
        return this.getGadget(gadgetName).getIconUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, GadgetDeclaration> getInternalAndExternalGadgets() {
        HashMap<String, GadgetDeclaration> result = new HashMap<String, GadgetDeclaration>();
        for (String key : internalGadgets.keySet()) {
            result.put(key, internalGadgets.get(key));
        }
        try {
            DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = dirService.open(GADGET_DIRECTORY);
            try {
                for (DocumentModel model : session.getEntries()) {
                    String iconURL;
                    String gadgetDefinition;
                    long enabled;
                    boolean disabled;
                    String name = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_NAME);
                    String category = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_CATEGORY);
                    ExternalGadgetDescriptor desc = new ExternalGadgetDescriptor(category, disabled = (enabled = ((Long)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_ENABLED)).longValue()) == 0L, new URL(gadgetDefinition = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_URL)), iconURL = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_ICON_URL), name);
                    if (desc.getDisabled()) continue;
                    result.put(desc.getName(), desc);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read external gadget directory!", (Throwable)e);
        }
        return result;
    }
}

