/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.osgi.framework.Bundle;

@XObject(value="internalGadget")
public class InternalGadgetDescriptor
implements GadgetDeclaration {
    public static final String GADGETS_PORT = "gadgets.port";
    public static final String GADGETS_HOST = "gadgets.host";
    public static final String GADGETS_PATH = "gadgets.path";
    public static final String HTTP = "http://";
    public static final String HTTP_SEPARATOR = ":";
    public static final String URL_SEPARATOR = "/";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@disabled")
    protected Boolean disabled;
    @XNode(value="entryPoint")
    protected String entryPoint = "";
    @XNode(value="mountPoint")
    protected String mountPoint = "";
    @XNode(value="directory")
    protected String directory = "";
    @XNode(value="category")
    protected String category;
    @XNode(value="icon")
    protected String icon;
    protected Bundle bundle;
    protected ComponentName componentName;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled;
    }

    public String getIcon() {
        return this.icon;
    }

    public final String getMountPoint() {
        if ("".equals(this.mountPoint)) {
            return this.name;
        }
        return this.mountPoint;
    }

    @Override
    public final String getCategory() {
        return this.category;
    }

    public final void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public final Bundle getBundle() {
        return this.bundle;
    }

    public final void setComponentName(ComponentName name) {
        this.componentName = name;
    }

    public final ComponentName getComponentName() {
        return this.componentName;
    }

    public final void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public final String getEntryPoint() {
        if ("".equals(this.entryPoint)) {
            return this.name + ".xml";
        }
        return this.entryPoint;
    }

    public String getDirectory() {
        if (StringUtils.isBlank((String)this.directory)) {
            return this.name;
        }
        return this.directory;
    }

    @Override
    public String getIconUrl() {
        StringBuilder sb = new StringBuilder(Framework.getProperty((String)GADGETS_PATH));
        sb.append(this.getMountPoint());
        sb.append(URL_SEPARATOR);
        sb.append(this.icon);
        return sb.toString();
    }

    public StringBuilder getUrlPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(HTTP);
        sb.append(Framework.getProperty((String)GADGETS_HOST));
        sb.append(HTTP_SEPARATOR);
        sb.append(Framework.getProperty((String)GADGETS_PORT));
        sb.append(Framework.getProperty((String)GADGETS_PATH));
        return sb;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        ComponentInstance component = Framework.getRuntime().getComponentInstance(this.componentName);
        Bundle bundle = component.getRuntimeContext().getBundle();
        URL gadgetURL = bundle.getEntry("gadget/" + this.getDirectory() + URL_SEPARATOR + resourcePath);
        if (gadgetURL != null) {
            return gadgetURL.openStream();
        }
        return null;
    }

    @Override
    public URL getGadgetDefinition() throws MalformedURLException {
        StringBuilder sb = this.getUrlPrefix();
        sb.append(this.getMountPoint());
        sb.append(URL_SEPARATOR);
        sb.append(this.getEntryPoint());
        return new URL(sb.toString());
    }
}

