/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.bindings;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.RepositoryManager;
import org.apache.chemistry.RepositoryService;
import org.apache.chemistry.atompub.server.jaxrs.AbderaResource;
import org.apache.chemistry.impl.simple.SimpleRepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.chemistry.impl.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ChemistryComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(ChemistryComponent.class);
    protected RepositoryService repositoryService;

    public void activate(ComponentContext context) throws Exception {
        AbderaResource.pathMunger = new WebEnginePathMunger();
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        RepositoryManager.getInstance().registerActivator(new Runnable(){

            public void run() {
                try {
                    ChemistryComponent.this.registerRepositories();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot register repositories with Chemistry", (Throwable)e);
                }
            }
        });
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.unregisterRepositories();
    }

    protected void registerRepositories() throws Exception {
        org.nuxeo.ecm.core.api.repository.RepositoryManager mgr = (org.nuxeo.ecm.core.api.repository.RepositoryManager)Framework.getService(org.nuxeo.ecm.core.api.repository.RepositoryManager.class);
        if (mgr == null) {
            throw new RuntimeException("Cannot lookup Nuxeo RepositoryManager");
        }
        ArrayList<NuxeoRepository> repositories = new ArrayList<NuxeoRepository>();
        for (Repository nxrepo : mgr.getRepositories()) {
            NuxeoRepository repo = new NuxeoRepository(nxrepo.getName());
            if ("default".equals(repo.getName())) {
                repositories.add(0, repo);
                continue;
            }
            repositories.add(repo);
        }
        this.repositoryService = new SimpleRepositoryService(repositories);
        RepositoryManager.getInstance().registerService(this.repositoryService);
    }

    protected void unregisterRepositories() {
        if (this.repositoryService == null) {
            return;
        }
        RepositoryManager.getInstance().unregisterService(this.repositoryService);
        this.repositoryService = null;
    }

    public static class WebEnginePathMunger
    implements AbderaResource.PathMunger {
        public AbderaResource.PathMunger.ContextAndServletPath munge(HttpServletRequest request, String contextPath, String servletPath) {
            AbderaResource.PathMunger.ContextAndServletPath cs = new AbderaResource.PathMunger.ContextAndServletPath();
            String basePath = request.getHeader("nuxeo-webengine-base-path");
            if (",".equals(basePath)) {
                basePath = "";
            }
            if (basePath == null) {
                cs.contextPath = contextPath;
                cs.servletPath = servletPath;
            } else {
                if (!basePath.startsWith("/")) {
                    basePath = '/' + basePath;
                }
                if (basePath.equals("/")) {
                    basePath = "";
                } else if (basePath.endsWith("/")) {
                    basePath = basePath.substring(0, basePath.length() - 1);
                }
                cs.contextPath = "";
                cs.servletPath = basePath;
            }
            return cs;
        }
    }
}

