/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.chemistry.bindings;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.chemistry.soap.server.AuthHandler;
import org.apache.chemistry.soap.server.CallContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.chemistry.bindings.LoginProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoAuthHandler
extends AuthHandler
implements LoginProvider {
    private static final Log log = LogFactory.getLog(NuxeoAuthHandler.class);
    public static final String LOGIN_CONTEXT = "nuxeo.LoginContext";
    public static final String LOGIN_PROVIDER_PROP = LoginProvider.class.getName();
    protected LoginProvider loginProvider;

    protected boolean handleInboundMessage(SOAPMessageContext soapContext) {
        boolean cont = super.handleInboundMessage(soapContext);
        if (!cont) {
            return cont;
        }
        CallContext callContext = CallContext.fromMessageContext((MessageContext)soapContext);
        String username = callContext.getUsername();
        String password = callContext.getPassword();
        try {
            LoginContext loginContext = this.getLoginProvider().login(username, password);
            soapContext.put((Object)LOGIN_CONTEXT, (Object)loginContext);
            soapContext.setScope(LOGIN_CONTEXT, MessageContext.Scope.APPLICATION);
        }
        catch (LoginException e) {
            throw new RuntimeException("Login failed for user '" + username + "'", e);
        }
        return true;
    }

    protected LoginProvider getLoginProvider() {
        if (this.loginProvider == null) {
            this.loginProvider = this;
            String className = Framework.getProperty((String)LOGIN_PROVIDER_PROP);
            if (className != null) {
                try {
                    Object instance = Class.forName(className).newInstance();
                    if (instance instanceof LoginProvider) {
                        this.loginProvider = (LoginProvider)instance;
                    } else {
                        log.error((Object)(className + " is not an instance of " + LoginProvider.class.getName()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return this.loginProvider;
    }

    public LoginContext login(String username, String password) {
        try {
            if (!this.getUserManager().checkUsernamePassword(username, password)) {
                throw new RuntimeException("Authentication failed for user '" + username + "'");
            }
            return Framework.login((String)username, (Object)password);
        }
        catch (ClientException e) {
            throw new RuntimeException("Cannot authenticate", e);
        }
        catch (LoginException e) {
            throw new RuntimeException("Login failed for user '" + username + "'", e);
        }
    }

    protected UserManager getUserManager() {
        try {
            return (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get UserManager service", e);
        }
    }

    public void close(MessageContext context) {
        LoginContext loginContext = (LoginContext)context.get((Object)LOGIN_CONTEXT);
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot logout", (Throwable)e);
            }
        }
        super.close(context);
    }
}

