/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import org.jboss.seam.deployment.DeploymentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentHandler
implements DeploymentHandler {
    protected static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassFile getClassFile(String name, ClassLoader classLoader) throws IOException {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            throw new IllegalStateException("Cannot load " + name + " from " + classLoader + " (using getResourceAsStream() returned null)");
        }
        DataInputStream dstream = new DataInputStream(stream);
        try {
            ClassFile classFile = new ClassFile(dstream);
            return classFile;
        }
        finally {
            dstream.close();
            stream.close();
        }
    }

    protected boolean hasAnnotation(ClassFile classFile, Class<? extends java.lang.annotation.Annotation> annotationType) {
        AnnotationsAttribute visible = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            return visible.getAnnotation(annotationType.getName()) != null;
        }
        return false;
    }

    protected String getAnnotationValue(ClassFile classFile, Class<? extends java.lang.annotation.Annotation> annotationType, String memberName) {
        AnnotationsAttribute visible = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            Annotation annotation = visible.getAnnotation(annotationType.getName());
            if (annotation == null) {
                return null;
            }
            MemberValue memberValue = annotation.getMemberValue(memberName);
            return memberValue == null ? null : memberValue.toString();
        }
        return null;
    }
}

