/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.abdera;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Repository;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.abdera.AllowableActionsElement;
import org.apache.chemistry.atompub.abdera.PropertiesElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectElement
extends ExtensibleElementWrapper {
    protected PropertiesElement properties;
    protected AllowableActionsElement allowableActions;

    public ObjectElement(Element internal, Repository repository) {
        super(internal);
        Element propsel = this.getFirstChild(CMIS.PROPERTIES);
        this.properties = propsel == null ? null : new PropertiesElement(propsel, repository);
    }

    public ObjectElement(Factory factory, ObjectEntry object, Type type) {
        super(factory, AtomPubCMIS.OBJECT);
        this.setProperties(object.getValues(), type);
        this.setAllowableActions(object.getAllowableActions());
    }

    public Map<String, Serializable> getProperties(String typeId) {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties.getProperties(typeId);
    }

    public void setProperties(Map<String, Serializable> values, Type type) {
        this.properties = new PropertiesElement(this.getFactory());
        this.addExtension((Element)this.properties);
        this.properties.setProperties(values, type);
    }

    public void setAllowableActions(Set<QName> aa) {
        if (aa == null) {
            this.allowableActions = null;
        } else {
            this.allowableActions = new AllowableActionsElement(this.getFactory());
            this.addExtension((Element)this.allowableActions);
            this.allowableActions.setAllowableActions(aa);
        }
    }
}

