/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ejb.ws.session;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSessionManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.ws.session.WSRemotingSessionManagerImpl;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={WSRemotingSessionManager.class})
@Remote(value={WSRemotingSessionManager.class})
public class WSRemotingSessionBean
implements WSRemotingSessionManager {
    private static final Log log = LogFactory.getLog(WSRemotingSessionBean.class);
    private WSRemotingSessionManager manager;

    private WSRemotingSessionManager getManager() {
        if (this.manager == null) {
            this.manager = (WSRemotingSessionManager)Framework.getRuntime().getComponent(WSRemotingSessionManagerImpl.NAME);
        }
        return this.manager;
    }

    @Override
    public void addSession(String sid, WSRemotingSession session) {
        WSRemotingSessionManager manager = this.getManager();
        if (manager != null) {
            manager.addSession(sid, session);
        } else {
            log.error((Object)"Cannot find Nuxeo runtime service... Canceling");
        }
    }

    @Override
    public WSRemotingSession createSession(String username, String password, String repository, UserManager um, CoreSession session) {
        WSRemotingSessionManager manager = this.getManager();
        if (manager != null) {
            return manager.createSession(username, password, repository, um, session);
        }
        log.error((Object)"Cannot find Nuxeo runtime service... Cancelling");
        return null;
    }

    @Override
    public void delSession(String sid) throws ClientException {
        WSRemotingSessionManager manager = this.getManager();
        if (manager == null) {
            throw new ClientException("Cannot find Nuxeo runtime service... Cancelling");
        }
        manager.delSession(sid);
    }

    @Override
    public WSRemotingSession getSession(String sid) throws ClientException {
        WSRemotingSessionManager manager = this.getManager();
        if (manager != null) {
            return manager.getSession(sid);
        }
        throw new ClientException("Cannot find Nuxeo runtime service... Cancelling");
    }
}

