/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import javax.annotation.security.PermitAll;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.security.auth.login.LoginContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.api.login.UserSession;
import org.nuxeo.ecm.platform.api.ws.BaseNuxeoWebService;
import org.nuxeo.ecm.platform.api.ws.WSException;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSessionManager;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSessionServiceDelegate;
import org.nuxeo.ecm.platform.api.ws.session.impl.WSRemotingSessionImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractNuxeoWebService
implements BaseNuxeoWebService {
    private static final long serialVersionUID = 5530614356404354863L;
    private WSRemotingSessionManager sessionsManager;

    protected WSRemotingSessionManager getSessionsManager() throws ClientException {
        if (this.sessionsManager == null) {
            try {
                this.sessionsManager = WSRemotingSessionServiceDelegate.getRemoteWSRemotingSessionManager();
            }
            catch (WSException wse) {
                throw new ClientException((Throwable)wse);
            }
        }
        if (this.sessionsManager == null) {
            throw new ClientException("Cannot find Web Service remoting session manager...");
        }
        return this.sessionsManager;
    }

    @PermitAll
    @WebMethod
    public String connectOnRepository(@WebParam(name="userName") String username, @WebParam(name="password") String password, @WebParam(name="repositoryName") String repositoryName) throws ClientException {
        String sid = null;
        try {
            LoginContext loginContext = Framework.login();
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repository = null;
            repository = repositoryName == null ? mgr.getDefaultRepository() : mgr.getRepository(repositoryName);
            loginContext.logout();
            sid = this._connect(username, password, repository);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        return sid;
    }

    @Override
    @PermitAll
    @WebMethod
    public String connect(@WebParam(name="userName") String username, @WebParam(name="password") String password) throws ClientException {
        return this.connectOnRepository(username, password, null);
    }

    private String _connect(String username, String password, Repository repository) throws ClientException {
        String sid = null;
        try {
            this.login(username, password);
            CoreSession session = repository.open();
            sid = session.getSessionId();
            UserManager userMgr = this.getUserManager();
            WSRemotingSessionImpl rs = new WSRemotingSessionImpl(session, userMgr, repository.getName(), username, password);
            this.getSessionsManager().addSession(sid, rs);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage());
        }
        return sid;
    }

    @Override
    @WebMethod
    public void disconnect(@WebParam(name="sessionId") String sid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        CoreInstance.getInstance().close(rs.getDocumentManager());
    }

    protected void login(String username, String password) throws ClientException {
        try {
            UserSession userSession = new UserSession(username, password);
            userSession.login();
        }
        catch (Exception e) {
            throw new ClientException("Login failed for " + username, (Throwable)e);
        }
    }

    protected WSRemotingSession initSession(String sid) throws ClientException {
        WSRemotingSession rs = this.getSessionsManager().getSession(sid);
        if (rs == null) {
            throw new ClientException("Invalid session id: " + sid);
        }
        this.login(rs.getUsername(), rs.getPassword());
        return rs;
    }

    protected UserManager getUserManager() throws Exception {
        return (UserManager)Framework.getService(UserManager.class);
    }
}

