/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.platform.api.ws.DocumentBlob;
import org.nuxeo.ecm.platform.api.ws.DocumentDescriptor;
import org.nuxeo.ecm.platform.api.ws.DocumentProperty;
import org.nuxeo.ecm.platform.api.ws.DocumentSnapshot;
import org.nuxeo.ecm.platform.api.ws.NuxeoRemoting;
import org.nuxeo.ecm.platform.api.ws.WsACE;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.ws.AbstractNuxeoWebService;
import org.nuxeo.runtime.api.Framework;

@Stateless
@SerializedConcurrentAccess
@Local(value={NuxeoRemoting.class})
@Remote(value={NuxeoRemoting.class})
@WebService(name="NuxeoRemotingInterface", serviceName="NuxeoRemotingService")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT)
public class NuxeoRemotingBean
extends AbstractNuxeoWebService
implements NuxeoRemoting {
    private static final long serialVersionUID = 359922583442116202L;
    private static final Log log = LogFactory.getLog(NuxeoRemotingBean.class);

    @Override
    @WebMethod
    public String getRepositoryName(@WebParam(name="sessionId") String sid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        return rs.getRepository();
    }

    @Override
    @WebMethod
    public WsACE[] getDocumentACL(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        ACP acp = rs.getDocumentManager().getACP((DocumentRef)new IdRef(uuid));
        if (acp != null) {
            ACL acl = acp.getMergedACLs("MergedACL");
            return WsACE.wrap((ACE[])acl.toArray((Object[])new ACE[acl.size()]));
        }
        return null;
    }

    @Override
    @WebMethod
    public DocumentSnapshot getDocumentSnapshot(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        return this.getDocumentSnapshotExt(sid, uuid, false);
    }

    @Override
    public DocumentSnapshot getDocumentSnapshotExt(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid, @WebParam(name="useDownloadURL") boolean useDownloadUrl) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        DocumentProperty[] props = this.getDocumentNoBlobProperties(doc, rs);
        DocumentBlob[] blobs = this.getDocumentBlobs(doc, rs, useDownloadUrl);
        ACE[] resACP = null;
        ACP acp = doc.getACP();
        if (acp != null) {
            ACL acl = acp.getMergedACLs("MergedACL");
            resACP = (ACE[])acl.toArray((Object[])new ACE[acl.size()]);
        }
        DocumentSnapshot ds = new DocumentSnapshot(props, blobs, doc.getPathAsString(), WsACE.wrap(resACP));
        return ds;
    }

    @Override
    @WebMethod
    public WsACE[] getDocumentLocalACL(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        ACP acp = rs.getDocumentManager().getACP((DocumentRef)new IdRef(uuid));
        if (acp != null) {
            ACLImpl mergedAcl = new ACLImpl("MergedACL", true);
            for (ACL acl : acp.getACLs()) {
                if ("inherited".equals(acl.getName())) continue;
                mergedAcl.addAll((Collection)acl);
            }
            return WsACE.wrap((ACE[])mergedAcl.toArray((Object[])new ACE[mergedAcl.size()]));
        }
        return null;
    }

    @Override
    public boolean hasPermission(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid, @WebParam(name="permission") String permission) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        CoreSession docMgr = rs.getDocumentManager();
        DocumentModel doc = docMgr.getDocument((DocumentRef)new IdRef(uuid));
        if (doc == null) {
            throw new ClientException("No such document: " + uuid);
        }
        return docMgr.hasPermission(doc.getRef(), permission);
    }

    @Override
    @WebMethod
    public DocumentBlob[] getDocumentBlobs(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        return this.getDocumentBlobsExt(sid, uuid, false);
    }

    @Override
    public DocumentBlob[] getDocumentBlobsExt(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid, @WebParam(name="useDownloadUrl") boolean useDownloadUrl) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        if (doc == null) {
            return null;
        }
        return this.getDocumentBlobs(doc, rs, useDownloadUrl);
    }

    protected DocumentBlob[] getDocumentBlobs(DocumentModel doc, WSRemotingSession rs, boolean useDownloadUrl) throws ClientException {
        String[] schemas;
        ArrayList<DocumentBlob> blobs = new ArrayList<DocumentBlob>();
        for (String schema : schemas = doc.getDeclaredSchemas()) {
            DataModel dm = doc.getDataModel(schema);
            Map map = dm.getMap();
            for (Map.Entry entry : map.entrySet()) {
                this.collectBlobs(doc.getId(), schema, rs, "", map, (String)entry.getKey(), entry.getValue(), blobs, useDownloadUrl);
            }
        }
        return blobs.toArray(new DocumentBlob[blobs.size()]);
    }

    @Override
    @WebMethod
    public String[] listUsers(@WebParam(name="sessionId") String sid, @WebParam(name="startIndex") int from, @WebParam(name="endIndex") int to) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        List userIds = rs.getUserManager().getUserIds();
        return userIds.toArray(new String[userIds.size()]);
    }

    @Override
    @WebMethod
    public String[] listGroups(@WebParam(name="sessionId") String sid, @WebParam(name="startIndex") int from, @WebParam(name="endIndex") int to) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        List groupIds = rs.getUserManager().getGroupIds();
        return groupIds.toArray(new String[groupIds.size()]);
    }

    @Override
    @WebMethod
    public DocumentProperty[] getDocumentProperties(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        ArrayList<DocumentProperty> props = new ArrayList<DocumentProperty>();
        if (doc != null) {
            String[] schemas;
            for (String schema : schemas = doc.getDeclaredSchemas()) {
                DataModel dm = doc.getDataModel(schema);
                Map map = dm.getMap();
                for (Map.Entry entry : map.entrySet()) {
                    this.collectProperty("", (String)entry.getKey(), entry.getValue(), props);
                }
            }
        }
        return props.toArray(new DocumentProperty[props.size()]);
    }

    @Override
    @WebMethod
    public DocumentProperty[] getDocumentNoBlobProperties(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        return this.getDocumentNoBlobProperties(doc, rs);
    }

    protected DocumentProperty[] getDocumentNoBlobProperties(DocumentModel doc, WSRemotingSession rs) throws ClientException {
        ArrayList<DocumentProperty> props = new ArrayList<DocumentProperty>();
        if (doc != null) {
            String[] schemas;
            for (String schema : schemas = doc.getDeclaredSchemas()) {
                DataModel dm = doc.getDataModel(schema);
                Map map = dm.getMap();
                for (Map.Entry entry : map.entrySet()) {
                    this.collectNoBlobProperty("", (String)entry.getKey(), entry.getValue(), props);
                }
            }
        }
        return props.toArray(new DocumentProperty[props.size()]);
    }

    @Override
    public DocumentDescriptor getCurrentVersion(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getLastDocumentVersion((DocumentRef)new IdRef(uuid));
        if (doc != null) {
            return new DocumentDescriptor(doc, (String)((Object)doc.getContextData("version.label")));
        }
        return null;
    }

    @Override
    public DocumentDescriptor getSourceDocument(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uid));
        String srcid = doc.getSourceId();
        if (srcid != null && srcid != uid) {
            doc = rs.getDocumentManager().getSourceDocument(doc.getRef());
        }
        if (doc != null) {
            return new DocumentDescriptor(doc);
        }
        return null;
    }

    @Override
    public DocumentDescriptor[] getVersions(@WebParam(name="sessionId") String sid, @WebParam(name="uuid") String uid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        List versions = rs.getDocumentManager().getVersions((DocumentRef)new IdRef(uid));
        if (versions == null) {
            return null;
        }
        DocumentDescriptor[] docs = new DocumentDescriptor[versions.size()];
        int i = 0;
        for (DocumentModel version : versions) {
            docs[i++] = new DocumentDescriptor(version, (String)((Object)version.getContextData("version.label")));
        }
        return null;
    }

    @Override
    @WebMethod
    public DocumentDescriptor getRootDocument(@WebParam(name="sessionId") String sessionId) throws ClientException {
        WSRemotingSession rs = this.initSession(sessionId);
        DocumentModel doc = rs.getDocumentManager().getRootDocument();
        return doc != null ? new DocumentDescriptor(doc) : null;
    }

    @Override
    @WebMethod
    public DocumentDescriptor getDocument(@WebParam(name="sessionId") String sessionId, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sessionId);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        return doc != null ? new DocumentDescriptor(doc) : null;
    }

    @Override
    @WebMethod
    public DocumentDescriptor[] getChildren(@WebParam(name="sessionId") String sessionId, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sessionId);
        DocumentModelList docList = rs.getDocumentManager().getChildren((DocumentRef)new IdRef(uuid));
        DocumentDescriptor[] docs = new DocumentDescriptor[docList.size()];
        int i = 0;
        for (DocumentModel doc : docList) {
            docs[i++] = new DocumentDescriptor(doc);
        }
        return docs;
    }

    protected void collectProperty(String prefix, String name, Object value, List<DocumentProperty> props) throws ClientException {
        String STRINGS_LIST_SEP = ";";
        if (value instanceof Map) {
            Map map = (Map)value;
            prefix = prefix + name + '/';
            for (Map.Entry entry : map.entrySet()) {
                this.collectProperty(prefix, (String)entry.getKey(), entry.getValue(), props);
            }
        } else if (value instanceof List) {
            prefix = prefix + name + '/';
            List list = (List)value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                this.collectProperty(prefix, String.valueOf(i), list.get(i), props);
            }
        } else {
            String strValue = null;
            if (value != null) {
                if (value instanceof Blob) {
                    try {
                        byte[] bytes = ((Blob)value).getByteArray();
                        strValue = Base64.encodeBytes((byte[])bytes);
                    }
                    catch (IOException e) {
                        throw new ClientException("Failed to get blob property value", (Throwable)e);
                    }
                } else if (value instanceof Calendar) {
                    strValue = ((Calendar)value).getTime().toString();
                } else if (value instanceof String[]) {
                    for (String each : (String[])value) {
                        strValue = strValue == null ? each : strValue + ";" + each;
                    }
                } else if (value instanceof List) {
                    for (String each : (List)value) {
                        if (strValue == null) {
                            strValue = each;
                            continue;
                        }
                        strValue = strValue + ";" + each;
                    }
                } else {
                    strValue = value.toString();
                }
            }
            props.add(new DocumentProperty(prefix + name, strValue));
        }
    }

    protected void collectNoBlobProperty(String prefix, String name, Object value, List<DocumentProperty> props) throws ClientException {
        if (value instanceof Map) {
            Map map = (Map)value;
            prefix = prefix + name + '/';
            for (Map.Entry entry : map.entrySet()) {
                this.collectNoBlobProperty(prefix, (String)entry.getKey(), entry.getValue(), props);
            }
        } else if (value instanceof List) {
            prefix = prefix + name + '/';
            List list = (List)value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                this.collectNoBlobProperty(prefix, String.valueOf(i), list.get(i), props);
            }
        } else if (!(value instanceof Blob)) {
            if (value == null) {
                props.add(new DocumentProperty(prefix + name, null));
            } else {
                this.collectProperty(prefix, name, value, props);
            }
        }
    }

    protected void collectBlobs(String docId, String schemaName, WSRemotingSession rs, String prefix, Map<String, Object> container, String name, Object value, List<DocumentBlob> blobs, boolean useDownloadUrl) throws ClientException {
        if (value instanceof Map) {
            Map map = (Map)value;
            prefix = prefix + name + '/';
            for (Map.Entry entry : map.entrySet()) {
                this.collectBlobs(docId, schemaName, rs, prefix, map, (String)entry.getKey(), entry.getValue(), blobs, useDownloadUrl);
            }
        } else if (value instanceof List) {
            prefix = prefix + name + '/';
            List list = (List)value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                this.collectBlobs(docId, schemaName, rs, prefix, container, String.valueOf(i), list.get(i), blobs, useDownloadUrl);
            }
        } else if (value instanceof Blob) {
            try {
                Blob blob = (Blob)value;
                String filename = (String)container.get("filename");
                if (filename == null) {
                    filename = prefix + name;
                }
                DocumentBlob db = null;
                if (useDownloadUrl) {
                    String repoName = rs.getDocumentManager().getRepositoryName();
                    String downloadUrl = this.getDownloadUrl(repoName, docId, schemaName, prefix + name, filename);
                    db = new DocumentBlob(filename, blob.getEncoding(), blob.getMimeType(), downloadUrl);
                } else {
                    db = new DocumentBlob(filename, blob);
                }
                blobs.add(db);
            }
            catch (IOException e) {
                throw new ClientException("Failed to get document blob", (Throwable)e);
            }
        }
    }

    protected String getSchemaPrefix(String schemaName) {
        return schemaName;
    }

    protected String getDownloadUrl(String repoName, String docId, String schemaName, String xPath, String fileName) {
        schemaName = this.getSchemaPrefix(schemaName);
        StringBuilder sb = new StringBuilder();
        sb.append("/nxbigfile/");
        sb.append(repoName);
        sb.append("/");
        sb.append(docId);
        sb.append("/");
        sb.append(schemaName);
        sb.append(":");
        sb.append(xPath);
        sb.append("/");
        sb.append(fileName);
        return sb.toString();
    }

    @Override
    @WebMethod
    public String[] getUsers(@WebParam(name="sessionId") String sid, @WebParam(name="parentGroup") String parentGroup) throws ClientException {
        List users;
        if (parentGroup == null) {
            return this.listUsers(sid, 0, Integer.MAX_VALUE);
        }
        WSRemotingSession rs = this.initSession(sid);
        if (parentGroup == null) {
            users = rs.getUserManager().getUserIds();
        } else {
            NuxeoGroup group = rs.getUserManager().getGroup(parentGroup);
            if (group == null) {
                return null;
            }
            users = group.getMemberUsers();
        }
        return users.toArray(new String[users.size()]);
    }

    @Override
    @WebMethod
    public String[] getGroups(@WebParam(name="sessionId") String sid, @WebParam(name="parentGroup") String parentGroup) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        List groups = parentGroup == null ? rs.getUserManager().getTopLevelGroups() : rs.getUserManager().getGroupsInGroup(parentGroup);
        return groups.toArray(new String[groups.size()]);
    }

    @Override
    @WebMethod
    public String getRelativePathAsString(@WebParam(name="sessionId") String sessionId, @WebParam(name="uuid") String uuid) throws ClientException {
        WSRemotingSession rs = this.initSession(sessionId);
        DocumentModel doc = rs.getDocumentManager().getDocument((DocumentRef)new IdRef(uuid));
        if (doc == null) {
            log.debug((Object)("Document not found for uuid=" + uuid));
            return "";
        }
        return doc.getPathAsString();
    }

    private Map<String, Object> createDataMap(String[] propertiesArray) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < propertiesArray.length; i += 2) {
            String key = propertiesArray[i];
            String value = propertiesArray[i + 1];
            String[] path = key.split("\\.");
            this.createSubMaps(map, path, value, 0);
        }
        return map;
    }

    private void createSubMaps(Map<String, Object> map, String[] path, String value, int depth) {
        String key = path[depth];
        if (depth == path.length - 1) {
            map.put(key, value);
        } else {
            HashMap<String, Object> subMap = (HashMap<String, Object>)map.get(key);
            if (subMap == null) {
                subMap = new HashMap<String, Object>();
                map.put(path[depth], subMap);
            }
            this.createSubMaps(subMap, path, value, depth + 1);
        }
    }

    @Override
    @WebMethod
    public String uploadDocument(@WebParam(name="sessionId") String sid, @WebParam(name="parentUuid") String parentUUID, @WebParam(name="type") String type, @WebParam(name="properties") String[] properties) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        String name = "file_" + System.currentTimeMillis();
        CoreSession documentManager = rs.getDocumentManager();
        IdRef parentRef = new IdRef(parentUUID);
        DocumentModelImpl document = new DocumentModelImpl(documentManager.getDocument((DocumentRef)parentRef), name, type);
        document = documentManager.createDocument((DocumentModel)document);
        Map<String, Object> propertiesMap = this.createDataMap(properties);
        Map fileMap = (Map)propertiesMap.get("file");
        Map contentMap = (Map)fileMap.get("content");
        Map dublincoreMap = (Map)propertiesMap.get("dublincore");
        document.setProperty("dublincore", "description", dublincoreMap.get("description"));
        document.setProperty("dublincore", "title", dublincoreMap.get("title"));
        String filname = (String)fileMap.get("filename");
        document.setProperty("file", "filename", (Object)filname);
        byte[] contentData = Base64.decode((String)((String)contentMap.get("data")));
        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])contentData);
        MimetypeRegistry mimeService = null;
        try {
            mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        catch (Exception e1) {
            log.error((Object)("Unable to access Mimetype service: " + e1.getMessage()));
        }
        String mimetype = "";
        if (mimeService != null) {
            try {
                mimetype = mimeService.getMimetypeFromFilenameAndBlobWithDefault(filname, (Blob)blob, mimetype);
            }
            catch (MimetypeDetectionException e) {
                log.error((Object)String.format("error during mimetype detection for %s: %s", filname, e.getMessage()));
            }
        }
        String encoding = (String)contentMap.get("encoding");
        blob.setEncoding(encoding);
        blob.setMimeType(mimetype);
        document.setProperty("file", "content", (Object)blob);
        documentManager.saveDocument((DocumentModel)document);
        documentManager.save();
        return "";
    }
}

