/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;

public class BundleResource {
    protected Bundle bundle;

    public BundleResource(Bundle bundle) {
        this.bundle = bundle;
    }

    @GET
    @Produces(value={"application/xml+atom"})
    public Object getDefinition() {
        OSGiRuntimeService runtime = (OSGiRuntimeService)Framework.getRuntime();
        ArrayList<RegistrationInfo> comps = new ArrayList<RegistrationInfo>();
        for (RegistrationInfo ri : runtime.getComponentManager().getRegistrations()) {
            if (!ri.getContext().getBundle().getSymbolicName().equals(this.bundle.getSymbolicName())) continue;
            comps.add(ri);
        }
        return new TemplateView((Object)this, "bundle-components.ftl").arg("components", comps).arg("bundle", (Object)this.bundle);
    }

    @GET
    @Path(value="file")
    @Produces(value={"application/octet-stream"})
    public File getBundleFile() {
        File file = Framework.getRuntime().getBundleFile(this.bundle);
        return file;
    }

    @GET
    @Path(value="manifest")
    @Produces(value={"text/plain"})
    public Object getManifest() {
        URL url = this.bundle.getEntry("META-INF/MANIFEST.MF");
        if (url == null) {
            return "";
        }
        InputStream in = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            in = url.openStream();
            FileUtils.copy((InputStream)in, (OutputStream)out);
            String string = new String(out.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @PUT
    public Response switchBundleState() {
        return Response.ok().build();
    }

    @DELETE
    public Response removeBundle() {
        return Response.ok().build();
    }
}

