/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.GenericServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.url.URLFactory;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.webengine.ApplicationManager;
import org.nuxeo.ecm.webengine.EmptyRegistry;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.ResourceRegistry;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.app.impl.DefaultApplicationManager;
import org.nuxeo.ecm.webengine.debug.ReloadManager;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.GlobalTypes;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.ecm.webengine.scripting.Scripting;
import org.nuxeo.runtime.annotations.AnnotationManager;
import org.nuxeo.runtime.api.Framework;

public class WebEngine
implements ResourceLocator {
    public static final String SKIN_PATH_PREFIX_KEY = "org.nuxeo.ecm.webengine.skinPathPrefix";
    protected static final Map<Object, Object> mimeTypes = WebEngine.loadMimeTypes();
    private static final Log log = LogFactory.getLog(WebEngine.class);
    private static final ThreadLocal<WebContext> CTX = new ThreadLocal();
    protected final File root;
    protected ApplicationManager apps;
    protected volatile ModuleManager moduleMgr;
    protected final Scripting scripting;
    protected final RenderingEngine rendering;
    protected final Map<String, Object> env;
    protected String devMode;
    protected final GlobalTypes globalTypes;
    protected final AnnotationManager annoMgr;
    protected final ResourceRegistry registry;
    protected String skinPathPrefix;
    protected final List<File> registeredModules = new ArrayList<File>();
    protected final WebLoader webLoader;
    protected ReloadManager reloadMgr;

    static Map<Object, Object> loadMimeTypes() {
        HashMap<Object, Object> mimeTypes = new HashMap<Object, Object>();
        Properties p = new Properties();
        URL url = WebEngine.class.getClassLoader().getResource("OSGI-INF/mime.properties");
        InputStream in = null;
        try {
            in = url.openStream();
            p.load(in);
            mimeTypes.putAll(p);
        }
        catch (IOException e) {
            throw new Error("Failed to load mime types");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return mimeTypes;
    }

    public static WebContext getActiveContext() {
        return CTX.get();
    }

    public static void setActiveContext(WebContext ctx) {
        CTX.set(ctx);
    }

    public WebEngine(File root) {
        this(new EmptyRegistry(), root);
    }

    public WebEngine(ResourceRegistry registry, File root) {
        this.registry = registry;
        this.root = root;
        this.devMode = Framework.getProperty((String)"org.nuxeo.dev");
        if (this.devMode != null) {
            this.reloadMgr = new ReloadManager(this);
        }
        this.webLoader = new WebLoader(this);
        this.apps = new DefaultApplicationManager(this);
        this.scripting = new Scripting(this.webLoader);
        this.annoMgr = new AnnotationManager();
        this.globalTypes = new GlobalTypes(this);
        this.skinPathPrefix = Framework.getProperty((String)SKIN_PATH_PREFIX_KEY);
        if (this.skinPathPrefix == null) {
            this.skinPathPrefix = System.getProperty("jboss.home.dir") != null ? "/nuxeo/site/skin" : "/skin";
        }
        this.env = new HashMap<String, Object>();
        this.env.put("installDir", root);
        this.env.put("engine", "Nuxeo Web Engine");
        this.env.put("version", "1.0.0.rc");
        this.rendering = new FreemarkerEngine();
        this.rendering.setResourceLocator((ResourceLocator)this);
        this.rendering.setSharedVariable("env", this.getEnvironment());
    }

    public ApplicationManager getApplicationManager() {
        return this.apps;
    }

    public void loadJspTaglib(GenericServlet servlet) {
        if (this.rendering instanceof FreemarkerEngine) {
            FreemarkerEngine fm = (FreemarkerEngine)this.rendering;
            ServletContextHashModel servletContextModel = new ServletContextHashModel(servlet, (ObjectWrapper)fm.getObjectWrapper());
            fm.setSharedVariable("Application", (Object)servletContextModel);
            fm.setSharedVariable("__FreeMarkerServlet.Application__", (Object)servletContextModel);
            fm.setSharedVariable("Application", (Object)servletContextModel);
            fm.setSharedVariable("__FreeMarkerServlet.Application__", (Object)servletContextModel);
            fm.setSharedVariable("JspTaglibs", (Object)new TaglibFactory(servlet.getServletContext()));
        }
    }

    public void initJspRequestSupport(GenericServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        if (this.rendering instanceof FreemarkerEngine) {
            FreemarkerEngine fm = (FreemarkerEngine)this.rendering;
            HttpRequestHashModel requestModel = new HttpRequestHashModel(request, response, (ObjectWrapper)fm.getObjectWrapper());
            fm.setSharedVariable("__FreeMarkerServlet.Request__", (Object)requestModel);
            fm.setSharedVariable("Request", (Object)requestModel);
            fm.setSharedVariable("RequestParameters", (Object)new HttpRequestParametersHashModel(request));
        }
    }

    public WebLoader getWebLoader() {
        return this.webLoader;
    }

    public void setSkinPathPrefix(String skinPathPrefix) {
        this.skinPathPrefix = skinPathPrefix;
    }

    public String getSkinPathPrefix() {
        return this.skinPathPrefix;
    }

    @Deprecated
    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.webLoader.loadClass(className);
    }

    public GlobalTypes getGlobalTypes() {
        return this.globalTypes;
    }

    public String getMimeType(String ext) {
        return (String)mimeTypes.get(ext);
    }

    public AnnotationManager getAnnotationManager() {
        return this.annoMgr;
    }

    public boolean isDevMode() {
        return this.devMode != null;
    }

    public String getDevMode() {
        return this.devMode;
    }

    public void setDevMode(String devModeId) {
        this.devMode = devModeId;
    }

    public void registerRenderingExtension(String id, Object obj) {
        this.rendering.setSharedVariable(id, obj);
    }

    public void unregisterRenderingExtension(String id) {
        this.rendering.setSharedVariable(id, null);
    }

    public Map<String, Object> getEnvironment() {
        return this.env;
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public void registerModule(File config) {
        this.registerModule(config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModule(File config, boolean addToClassPath) {
        if (addToClassPath) {
            this.getWebLoader().addClassPathElement(config.getParentFile());
        }
        this.registeredModules.add(config);
        if (this.moduleMgr != null) {
            WebEngine webEngine = this;
            synchronized (webEngine) {
                if (this.moduleMgr != null) {
                    this.moduleMgr.loadModule(config);
                }
            }
        }
    }

    public File[] getRegisteredModules() {
        return this.registeredModules.toArray(new File[this.registeredModules.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleManager getModuleManager() {
        if (this.moduleMgr == null) {
            WebEngine webEngine = this;
            synchronized (webEngine) {
                if (this.moduleMgr == null) {
                    ModuleManager moduleMgr = new ModuleManager(this);
                    File deployRoot = this.getDeploymentDirectory();
                    if (deployRoot.isDirectory()) {
                        for (String name : deployRoot.list()) {
                            String path = (String)name + "/module.xml";
                            File file = new File(deployRoot, path);
                            if (!file.isFile()) continue;
                            this.webLoader.addClassPathElement(file.getParentFile());
                            moduleMgr.loadModule(file);
                        }
                    }
                    for (File mod : this.registeredModules.toArray(new File[this.registeredModules.size()])) {
                        moduleMgr.loadModule(mod);
                    }
                    this.moduleMgr = moduleMgr;
                }
            }
        }
        return this.moduleMgr;
    }

    public Module getModule(String name) {
        ModuleConfiguration md = this.getModuleManager().getModule(name);
        if (md != null) {
            return md.get();
        }
        return null;
    }

    public File getRootDirectory() {
        return this.root;
    }

    public File getDeploymentDirectory() {
        return new File(this.root, "deploy");
    }

    public File getModulesDirectory() {
        return new File(this.root, "modules");
    }

    public ReloadManager getReloadManager() {
        return this.reloadMgr;
    }

    public RenderingEngine getRendering() {
        return this.rendering;
    }

    public void addResourceBinding(ResourceBinding binding) {
        try {
            binding.resolve(this);
            this.registry.addBinding(binding);
        }
        catch (Exception e) {
            throw WebException.wrap("Failed o register binding: " + binding, e);
        }
    }

    public void removeResourceBinding(ResourceBinding binding) {
        this.registry.removeBinding(binding);
    }

    public ResourceBinding[] getBindings() {
        return this.registry.getBindings();
    }

    public synchronized void reload2() {
        log.info((Object)"Reloading WebEngine");
        this.webLoader.flushCache();
        this.apps.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() {
        log.info((Object)"Reloading WebEngine");
        this.apps.reload();
        if (this.moduleMgr != null) {
            for (ModuleConfiguration mc : this.moduleMgr.getModules()) {
                if (!mc.isLoaded()) continue;
                mc.get().flushCache();
            }
            WebEngine webEngine = this;
            synchronized (webEngine) {
                if (this.moduleMgr != null) {
                    this.moduleMgr = null;
                }
            }
        }
        this.webLoader.flushCache();
        this.apps.reload();
    }

    public synchronized void reloadModules() {
        this.moduleMgr.reloadModules();
    }

    public void start() {
        if (this.reloadMgr != null) {
            this.reloadMgr.start();
        }
    }

    public void stop() {
        if (this.reloadMgr != null) {
            this.reloadMgr.stop();
        }
        this.registry.clear();
    }

    protected ModuleConfiguration getModuleFromPath(String rootPath, String path) {
        path = path.substring(rootPath.length() + 1);
        int p = path.indexOf(47);
        String moduleName = path;
        if (p > -1) {
            moduleName = path.substring(0, p);
        }
        return this.moduleMgr.getModule(moduleName);
    }

    public URL getResourceURL(String key) {
        try {
            return URLFactory.getURL((String)key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getResourceFile(String key) {
        WebContext ctx = WebEngine.getActiveContext();
        if (key.startsWith("@")) {
            Resource rs = ctx.getTargetObject();
            if (rs != null) {
                return rs.getView(key.substring(1)).script().getFile();
            }
        } else {
            ScriptFile file = ctx.getFile(key);
            if (file != null) {
                return file.getFile();
            }
        }
        return null;
    }
}

