/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.impl.DefaultContext;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.AbstractWebContext;
import org.nuxeo.ecm.webengine.session.UserSession;
import org.nuxeo.runtime.api.Framework;

public class WebEngineFilter
implements Filter {
    protected WebEngine engine;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.engine = (WebEngine)Framework.getLocalService(WebEngine.class);
    }

    public void destroy() {
        this.engine = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            DefaultContext ctx = new DefaultContext((HttpServletRequest)request);
            WebEngine.setActiveContext(ctx);
            request.setAttribute(WebContext.class.getName(), (Object)ctx);
            try {
                this.preRequest(req, resp);
                chain.doFilter(request, response);
                this.postRequest(req, resp);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                this.cleanup(ctx, req, resp);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void preRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (null == request.getCharacterEncoding()) {
            request.setCharacterEncoding("UTF-8");
        }
    }

    public void postRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (null != request.getAttribute("org.nuxeo.webengine.DisableAutoHeaders")) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.addHeader("Cache-Control", "must-revalidate");
            response.addHeader("Expires", "0");
            response.setDateHeader("Expires", 0L);
        }
    }

    public void cleanup(AbstractWebContext ctx, HttpServletRequest request, HttpServletResponse response) {
        UserSession us;
        if (ctx != null && (us = UserSession.tryGetCurrentSession(request)) != null) {
            us.terminateRequest(request);
        }
        WebEngine.setActiveContext(null);
    }
}

