/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.document;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.webengine.app.extensions.ExtensibleResource;
import org.nuxeo.ecm.webengine.model.WebContext;

public abstract class DocumentResource
extends ExtensibleResource {
    protected DocumentModel doc;

    public DocumentResource(DocumentModel doc) {
        this.doc = doc;
    }

    public DocumentResource(WebContext ctx, DocumentModel doc) {
        super(ctx);
        this.doc = doc;
    }

    protected DocumentModel getDocument() {
        return this.doc;
    }

    protected DocumentResource getDocumentResource(DocumentModel doc) {
        return null;
    }

    @Override
    protected Object resolveUnmatchedSegment(String key) {
        try {
            DocumentModel child = this.getContext().getCoreSession().getDocument((DocumentRef)new PathRef(this.doc.getPath().append(key).toString()));
            return this.getDocumentResource(child);
        }
        catch (Exception e) {
            return super.resolveUnmatchedSegment(key);
        }
    }
}

