/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.debug;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.debug.DirectoryEntry;
import org.nuxeo.ecm.webengine.debug.FileEntry;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;

public abstract class ModuleTracker
implements Runnable {
    private static final Log log = LogFactory.getLog(ModuleTracker.class);
    protected final ModuleImpl module;
    protected final FileEntry moduleXml;
    protected final FileEntry webTypes;
    protected final FileEntry i18n;
    protected final DirectoryEntry skin;

    public ModuleTracker(ModuleImpl module) {
        this.module = module;
        this.moduleXml = new FileEntry(module.getModuleConfiguration().file);
        File root = module.getRoot();
        this.i18n = new FileEntry(new File(root, "i18n"));
        this.skin = new DirectoryEntry(new File(root, "skin"));
        this.webTypes = new FileEntry(new File(root, "META-INF/web-types"));
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            log.error((Object)("Failed to check module changes for " + this.module.getName()), (Throwable)e);
        }
    }

    protected void doRun() throws Exception {
        if (this.moduleXml.check()) {
            this.module.getEngine().getModuleManager().reloadModule(this.module.getName());
            return;
        }
        if (this.i18n.check()) {
            this.module.reloadMessages();
        }
        if (this.webTypes.check()) {
            this.module.flushTypeCache();
        }
        if (this.skin.check()) {
            ModuleTracker.flushSkinCache(this.module);
        }
    }

    public static void flushTypeCache(ModuleImpl module) {
        ModuleConfiguration[] modules;
        for (ModuleConfiguration mc : modules = module.getEngine().getModuleManager().getModules()) {
            if (!mc.isLoaded()) continue;
            ((ModuleImpl)mc.get()).flushTypeCache();
        }
    }

    public static void flushRootResourcesCache(ModuleImpl module) {
        ModuleConfiguration[] modules;
        for (ModuleConfiguration mc : modules = module.getEngine().getModuleManager().getModules()) {
            if (!mc.isLoaded() || mc.resources == null) continue;
            ((ModuleImpl)mc.get()).flushRootResourcesCache();
        }
    }

    public static void flushSkinCache(ModuleImpl module) {
        ModuleConfiguration[] modules;
        for (ModuleConfiguration mc : modules = module.getEngine().getModuleManager().getModules()) {
            if (!mc.isLoaded()) continue;
            ((ModuleImpl)mc.get()).flushSkinCache();
        }
    }
}

