/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectoryStack {
    protected final List<File> dirs = new ArrayList<File>();

    public DirectoryStack() {
    }

    public DirectoryStack(List<File> entries) {
        this();
        this.dirs.addAll(entries);
    }

    public List<File> getDirectories() {
        return this.dirs;
    }

    public boolean isEmpty() {
        return this.dirs.isEmpty();
    }

    public void addDirectory(File dir) throws IOException {
        this.dirs.add(dir.getCanonicalFile());
    }

    public File getFile(String name) throws IOException {
        for (File entry : this.dirs) {
            File file = new File(entry, name);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        return null;
    }

    public File[] listFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (File entry : this.dirs) {
            File[] files = entry.listFiles();
            result.addAll(Arrays.asList(files));
        }
        return result.toArray(new File[result.size()]);
    }

    public File[] listFiles(FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        for (File entry : this.dirs) {
            File[] files = entry.listFiles(filter);
            result.addAll(Arrays.asList(files));
        }
        return result.toArray(new File[result.size()]);
    }

    public static void main(String[] args) {
        try {
            DirectoryStack vd = new DirectoryStack();
            vd.addDirectory(new File("/home/bstefanescu/Desktop"));
            vd.addDirectory(new File("/home/bstefanescu/src"));
            for (File file : vd.listFiles()) {
                System.out.println("> " + file);
            }
            System.out.println("dummy: " + vd.getFile("dummy"));
            System.out.println("dev: " + vd.getFile("dev"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

