/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.runtime.api.Framework;

public class ModuleManager {
    private static final Log log = LogFactory.getLog(ModuleManager.class);
    protected final Map<String, ModuleConfiguration> modules;
    protected final Map<String, ModuleConfiguration> paths;
    protected WebEngine engine;

    public ModuleManager(WebEngine engine) {
        this.engine = engine;
        this.modules = new ConcurrentHashMap<String, ModuleConfiguration>();
        this.paths = new ConcurrentHashMap<String, ModuleConfiguration>();
    }

    public ModuleConfiguration getModule(String key) {
        return this.modules.get(key);
    }

    public ModuleConfiguration getModuleByPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.paths.get(path);
    }

    public ModuleConfiguration getRootModule() {
        return this.paths.get("/");
    }

    public ModuleConfiguration[] getModules() {
        return this.modules.values().toArray(new ModuleConfiguration[this.modules.size()]);
    }

    public ModuleConfiguration getModuleByConfigFile(File file) {
        ModuleConfiguration[] ar;
        for (ModuleConfiguration mc : ar = this.getModules()) {
            if (!file.equals(mc.file)) continue;
            return mc;
        }
        return null;
    }

    public synchronized void registerModule(ModuleConfiguration descriptor) {
        log.info((Object)("Registering web module: " + descriptor.name));
        this.modules.put(descriptor.name, descriptor);
        String path = descriptor.path;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.paths.put(path, descriptor);
    }

    public synchronized File unregisterModule(String name) {
        ModuleConfiguration md = this.modules.remove(name);
        if (md == null) {
            return null;
        }
        Iterator<ModuleConfiguration> it = this.paths.values().iterator();
        while (it.hasNext()) {
            ModuleConfiguration p = it.next();
            if (!p.name.equals(md.name)) continue;
            it.remove();
        }
        return md.file;
    }

    public synchronized void bind(String name, String path) {
        ModuleConfiguration md = this.modules.get(name);
        if (md != null) {
            this.paths.put(path, md);
        }
    }

    public void loadModules(File root) {
        for (String name : root.list()) {
            String path = name + "/module.xml";
            File file = new File(root, path);
            if (!file.isFile()) continue;
            this.loadModule(file);
        }
    }

    public void loadModule(File file) {
        ModuleConfiguration md = this.loadConfiguration(file);
        this.loadModuleRootResources(md);
        md.setEngine(this.engine);
        this.registerModule(md);
    }

    public void loadModuleFromDir(File moduleRoot) {
        File file = new File(moduleRoot, "module.xml");
        if (file.isFile()) {
            this.loadModule(file);
        }
    }

    public void reloadModule(String name) {
        log.info((Object)("Reloading module: " + name));
        File cfg = this.unregisterModule(name);
        if (cfg != null) {
            this.loadModule(cfg);
        }
    }

    public void reloadModules() {
        log.info((Object)"Reloading modules");
        for (ModuleConfiguration mc : this.getModules()) {
            try {
                this.reloadModule(mc.name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to redeploy module: " + mc.name));
            }
        }
    }

    protected ModuleConfiguration loadConfiguration(File file) {
        if (this.engine == null) {
            this.engine = (WebEngine)Framework.getLocalService(WebEngine.class);
        }
        try {
            XMap xmap = new XMap();
            xmap.register(ModuleConfiguration.class);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            ModuleConfiguration mc = (ModuleConfiguration)xmap.load(this.createXMapContext(), (InputStream)in);
            mc.file = file;
            if (mc.directory == null) {
                mc.directory = file.getParentFile().getCanonicalFile();
            }
            return mc;
        }
        catch (Exception e) {
            throw WebException.wrap("Faile to load module configuration: " + file, e);
        }
    }

    public void loadModuleRootResources(ModuleConfiguration mc) {
        if (mc.resources != null) {
            for (ResourceBinding rb : mc.resources) {
                try {
                    rb.resolve(this.engine);
                    this.engine.addResourceBinding(rb);
                }
                catch (Exception e) {
                    throw WebException.wrap("Faile to load module root resource: " + rb, e);
                }
            }
        }
    }

    protected Context createXMapContext() {
        return new Context(){
            private static final long serialVersionUID = 1L;

            public Class<?> loadClass(String className) throws ClassNotFoundException {
                return ModuleManager.this.engine.getWebLoader().loadClass(className);
            }

            public URL getResource(String name) {
                return ModuleManager.this.engine.getWebLoader().getResource(name);
            }
        };
    }
}

