/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectoryStack {
    protected final List<Entry> dirs = new ArrayList<Entry>();

    public DirectoryStack() {
    }

    public DirectoryStack(List<Entry> entries) {
        this();
        this.dirs.addAll(entries);
    }

    public List<Entry> getEntries() {
        return this.dirs;
    }

    public boolean isEmpty() {
        return this.dirs.isEmpty();
    }

    public void addDirectory(File dir, int priority) throws IOException {
        this.dirs.add(new Entry(dir.getCanonicalFile(), priority));
    }

    public File getFile(String name) throws IOException {
        for (Entry entry : this.dirs) {
            File file = new File(entry.file, name);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        return null;
    }

    public File[] listFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (Entry entry : this.dirs) {
            File[] files = entry.file.listFiles();
            result.addAll(Arrays.asList(files));
        }
        return result.toArray(new File[result.size()]);
    }

    public File[] listFiles(FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        for (Entry entry : this.dirs) {
            File[] files = entry.file.listFiles(filter);
            result.addAll(Arrays.asList(files));
        }
        return result.toArray(new File[result.size()]);
    }

    public static void main(String[] args) {
        try {
            DirectoryStack vd = new DirectoryStack();
            vd.addDirectory(new File("/home/bstefanescu/Desktop"), 1);
            vd.addDirectory(new File("/home/bstefanescu/src"), 1);
            for (File file : vd.listFiles()) {
                System.out.println("> " + file);
            }
            System.out.println("dummy: " + vd.getFile("dummy"));
            System.out.println("dev: " + vd.getFile("dev"));
            System.out.println("dummy: " + vd.getFile("dummy"));
            System.out.println("dev: " + vd.getFile("dev"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        public final File file;
        public final int priority;

        public Entry(File file, int priority) {
            this.file = file;
            this.priority = priority;
        }

        @Override
        public int compareTo(Entry o) {
            return o.priority - this.priority;
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

