/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DataModelMap;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;

public interface DocumentModel
extends Serializable {
    public static final int REFRESH_LOCK = 1;
    public static final int REFRESH_LIFE_CYCLE = 2;
    public static final int REFRESH_PREFETCH = 4;
    public static final int REFRESH_ACP_IF_LOADED = 8;
    public static final int REFRESH_ACP_LAZY = 16;
    public static final int REFRESH_ACP = 32;
    public static final int REFRESH_CONTENT_IF_LOADED = 64;
    public static final int REFRESH_CONTENT_LAZY = 128;
    public static final int REFRESH_CONTENT = 256;
    public static final int REFRESH_STATE = 3;
    public static final int REFRESH_IF_LOADED = 79;
    public static final int REFRESH_LAZY = 151;
    public static final int REFRESH_ALL = 295;
    public static final int REFRESH_DEFAULT = 143;

    public DocumentType getDocumentType();

    public String getSessionId();

    public CoreSession getCoreSession();

    public DocumentRef getRef();

    public DocumentRef getParentRef();

    public String getId();

    public String getName();

    public String getTitle() throws ClientException;

    public String getPathAsString();

    public Path getPath();

    public String getType();

    public String[] getDeclaredSchemas();

    public Set<String> getDeclaredFacets();

    public Collection<DataModel> getDataModelsCollection();

    public DataModelMap getDataModels();

    public DataModel getDataModel(String var1) throws ClientException;

    public void setPathInfo(String var1, String var2);

    public String getLock();

    public boolean isLocked();

    public void setLock(String var1) throws ClientException;

    public void unlock() throws ClientException;

    public ACP getACP() throws ClientException;

    public void setACP(ACP var1, boolean var2) throws ClientException;

    public Object getProperty(String var1, String var2) throws ClientException;

    public void setProperty(String var1, String var2, Object var3) throws ClientException;

    public Map<String, Object> getProperties(String var1) throws ClientException;

    public void setProperties(String var1, Map<String, Object> var2) throws ClientException;

    public boolean hasSchema(String var1);

    public boolean hasFacet(String var1);

    public boolean isFolder();

    public boolean isVersionable();

    public boolean isDownloadable() throws ClientException;

    public boolean isVersion();

    public boolean isProxy();

    public boolean isImmutable();

    public <T> T getAdapter(Class<T> var1);

    public <T> T getAdapter(Class<T> var1, boolean var2);

    public String getCurrentLifeCycleState() throws ClientException;

    public String getLifeCyclePolicy() throws ClientException;

    public boolean followTransition(String var1) throws ClientException;

    public Collection<String> getAllowedStateTransitions() throws ClientException;

    public ScopedMap getContextData();

    public Serializable getContextData(ScopeType var1, String var2);

    public void putContextData(ScopeType var1, String var2, Serializable var3);

    public Serializable getContextData(String var1);

    public void putContextData(String var1, Serializable var2);

    public void copyContextData(DocumentModel var1);

    public void copyContent(DocumentModel var1) throws ClientException;

    public String getRepositoryName();

    public String getCacheKey() throws ClientException;

    public String getSourceId();

    public String getVersionLabel();

    public Map<String, Serializable> getPrefetch();

    public void prefetchProperty(String var1, Object var2);

    public void prefetchCurrentLifecycleState(String var1);

    public void prefetchLifeCyclePolicy(String var1);

    public boolean isLifeCycleLoaded();

    public <T extends Serializable> T getSystemProp(String var1, Class<T> var2) throws ClientException, DocumentException;

    public DocumentPart getPart(String var1) throws ClientException;

    public DocumentPart[] getParts() throws ClientException;

    public Property getProperty(String var1) throws PropertyException, ClientException;

    public Serializable getPropertyValue(String var1) throws PropertyException, ClientException;

    public void setPropertyValue(String var1, Serializable var2) throws PropertyException, ClientException;

    public long getFlags();

    public void reset();

    public void refresh(int var1, String[] var2) throws ClientException;

    public void refresh() throws ClientException;

    public DocumentModel clone() throws CloneNotSupportedException;
}

