/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultBlob;

public class StringBlob
extends DefaultBlob
implements Serializable {
    private static final long serialVersionUID = -1369527636846459436L;
    protected final String content;

    public StringBlob(String content) {
        this(content, null, null);
    }

    public StringBlob(String content, String ctype) {
        this(content, ctype, null);
    }

    public StringBlob(String content, String mimeType, String encoding) {
        this.content = content;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    @Override
    public long getLength() {
        if (this.content == null) {
            return 0L;
        }
        return this.content.length();
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_INPUT_STREAM;
        }
        return new ByteArrayInputStream(this.getByteArray());
    }

    @Override
    public byte[] getByteArray() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.getBytes(this.encoding == null ? "UTF-8" : this.encoding);
    }

    @Override
    public String getString() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return "";
        }
        return this.content;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_READER;
        }
        return new StringReader(this.content);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public Blob persist() throws IOException {
        return this;
    }
}

